/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.robotium.solo.RobotiumUtils;
import com.robotium.solo.Sleeper;
import com.robotium.solo.Solo;
import com.robotium.solo.ViewFetcher;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scroller {
    public static final int DOWN = 0;
    public static final int UP = 1;
    private boolean canScroll = false;
    private final Instrumentation inst;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;
    private final Solo.Config config;

    public Scroller(Solo.Config config, Instrumentation inst, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.config = config;
        this.inst = inst;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float y = fromY;
        float x = fromX;
        float yStep = (toY - fromY) / (float)stepCount;
        float xStep = (toX - fromX) / (float)stepCount;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)fromX, (float)fromY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        for (int i = 0; i < stepCount; ++i) {
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x += xStep), (float)(y += yStep), (int)0);
            try {
                this.inst.sendPointerSync(event);
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)toX, (float)toY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    private boolean scrollView(final View view, int direction) {
        if (view == null) {
            return false;
        }
        int height = view.getHeight();
        --height;
        int scrollTo = -1;
        if (direction == 0) {
            scrollTo = height;
        } else if (direction == 1) {
            scrollTo = -height;
        }
        int originalY = view.getScrollY();
        final int scrollAmount = scrollTo;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.scrollBy(0, scrollAmount);
            }
        });
        return originalY != view.getScrollY();
    }

    private void scrollViewAllTheWay(View view, int direction) {
        while (this.scrollView(view, direction)) {
        }
    }

    public boolean scroll(int direction) {
        return this.scroll(direction, false);
    }

    public boolean scrollDown() {
        if (!this.config.shouldScroll) {
            return false;
        }
        return this.scroll(0);
    }

    public boolean scroll(int direction, boolean allTheWay) {
        ArrayList<View> viewList = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getAllViews(true));
        ArrayList<View> views = RobotiumUtils.filterViewsToSet(new Class[]{ListView.class, ScrollView.class, GridView.class, WebView.class}, viewList);
        View view = this.viewFetcher.getFreshestView(views);
        if (view == null && (view = this.getRecyclerView(viewList)) == null) {
            return false;
        }
        if (view instanceof AbsListView) {
            return this.scrollList((AbsListView)view, direction, allTheWay);
        }
        if (view instanceof WebView) {
            return this.scrollWebView((WebView)view, direction, allTheWay);
        }
        if (allTheWay) {
            this.scrollViewAllTheWay(view, direction);
            return false;
        }
        return this.scrollView(view, direction);
    }

    public boolean scrollWebView(final WebView webView, int direction, final boolean allTheWay) {
        if (direction == 0) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    Scroller.this.canScroll = webView.pageDown(allTheWay);
                }
            });
        }
        if (direction == 1) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    Scroller.this.canScroll = webView.pageUp(allTheWay);
                }
            });
        }
        return this.canScroll;
    }

    public <T extends AbsListView> boolean scrollList(T absListView, int direction, boolean allTheWay) {
        if (absListView == null) {
            return false;
        }
        if (direction == 0) {
            int listCount = absListView.getCount();
            int lastVisiblePosition = absListView.getLastVisiblePosition();
            if (allTheWay) {
                this.scrollListToLine(absListView, listCount - 1);
                return false;
            }
            if (lastVisiblePosition >= listCount - 1) {
                if (lastVisiblePosition > 0) {
                    this.scrollListToLine(absListView, lastVisiblePosition);
                }
                return false;
            }
            int firstVisiblePosition = absListView.getFirstVisiblePosition();
            if (firstVisiblePosition != lastVisiblePosition) {
                this.scrollListToLine(absListView, lastVisiblePosition);
            } else {
                this.scrollListToLine(absListView, firstVisiblePosition + 1);
            }
        } else if (direction == 1) {
            int firstVisiblePosition = absListView.getFirstVisiblePosition();
            if (allTheWay || firstVisiblePosition < 2) {
                this.scrollListToLine(absListView, 0);
                return false;
            }
            int lastVisiblePosition = absListView.getLastVisiblePosition();
            int lines = lastVisiblePosition - firstVisiblePosition;
            int lineToScrollTo = firstVisiblePosition - lines;
            if (lineToScrollTo == lastVisiblePosition) {
                --lineToScrollTo;
            }
            if (lineToScrollTo < 0) {
                lineToScrollTo = 0;
            }
            this.scrollListToLine(absListView, lineToScrollTo);
        }
        this.sleeper.sleep();
        return true;
    }

    public <T extends AbsListView> void scrollListToLine(final T view, int line) {
        if (view == null) {
            Assert.fail((String)"AbsListView is null!");
        }
        final int lineToMoveTo = view instanceof GridView ? line + 1 : line;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.setSelection(lineToMoveTo);
            }
        });
    }

    public void scrollToSide(Side side, float scrollPosition, int stepCount) {
        WindowManager windowManager = (WindowManager)this.inst.getTargetContext().getSystemService("window");
        int screenHeight = windowManager.getDefaultDisplay().getHeight();
        int screenWidth = windowManager.getDefaultDisplay().getWidth();
        float x = (float)screenWidth * scrollPosition;
        float y = (float)screenHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(70.0f, x, y, y, stepCount);
        } else if (side == Side.RIGHT) {
            this.drag(x, 0.0f, y, y, stepCount);
        }
    }

    public void scrollViewToSide(View view, Side side, float scrollPosition, int stepCount) {
        int[] corners = new int[2];
        view.getLocationOnScreen(corners);
        int viewHeight = view.getHeight();
        int viewWidth = view.getWidth();
        float x = (float)corners[0] + (float)viewWidth * scrollPosition;
        float y = (float)corners[1] + (float)viewHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(corners[0], x, y, y, stepCount);
        } else if (side == Side.RIGHT) {
            this.drag(x, corners[0], y, y, stepCount);
        }
    }

    private View getRecyclerView(ArrayList<View> viewList) {
        ArrayList<View> views = RobotiumUtils.filterViewsToSet(new Class[]{ViewGroup.class}, viewList);
        for (View view : views) {
            if (!this.isViewType(view.getClass(), "widget.RecyclerView")) continue;
            return view;
        }
        return null;
    }

    private boolean isViewType(Class<?> aClass, String typeName) {
        if (aClass.getName().contains(typeName)) {
            return true;
        }
        if (aClass.getSuperclass() != null) {
            return this.isViewType(aClass.getSuperclass(), typeName);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT,
        RIGHT;

    }
}

