/*
 * Decompiled with CFR 0.152.
 */
package com.android.hosttest;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hosttest.DeviceTest;
import com.android.hosttest.DeviceTestSuite;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.textui.TestRunner;

public class DeviceTestRunner
extends TestRunner {
    private static final String LOG_TAG = "DeviceTestRunner";
    private String mDeviceSerial = null;
    private IDevice mDevice = null;
    private String mTestDataPath = null;

    private DeviceTestRunner() {
    }

    public TestResult start(String[] args) throws Exception {
        ArrayList<String> parentArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-s")) {
                this.mDeviceSerial = this.extractArg(args, ++i);
                continue;
            }
            if (args[i].equals("-p")) {
                this.mTestDataPath = this.extractArg(args, ++i);
                continue;
            }
            parentArgs.add(args[i]);
        }
        this.mDevice = this.connectToDevice(this.mDeviceSerial);
        return super.start(parentArgs.toArray(new String[parentArgs.size()]));
    }

    private String extractArg(String[] args, int index) {
        if (args.length <= index) {
            DeviceTestRunner.printUsage();
            throw new IllegalArgumentException("Error: not enough arguments");
        }
        return args[index];
    }

    private IDevice connectToDevice(String deviceSerial) {
        AndroidDebugBridge.init((boolean)false);
        AndroidDebugBridge adbBridge = AndroidDebugBridge.createBridge();
        for (IDevice device : adbBridge.getDevices()) {
            if (deviceSerial == null) {
                return device;
            }
            if (!deviceSerial.equals(device.getSerialNumber())) continue;
            return device;
        }
        System.out.println("Waiting for device...");
        NewDeviceListener listener = new NewDeviceListener(deviceSerial);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
        IDevice device = listener.waitForDevice(5000L);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
        if (device == null) {
            throw new IllegalArgumentException("Could not connect to device");
        }
        return device;
    }

    public static void main(String[] args) {
        DeviceTestRunner aTestRunner = new DeviceTestRunner();
        try {
            TestResult r = aTestRunner.start(args);
            if (!r.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: DeviceTestRunner <test_class> [-s device_serial] [-p test_data_path]");
    }

    public TestResult doRun(Test test, boolean wait) {
        if (test instanceof DeviceTest) {
            DeviceTest deviceTest = (DeviceTest)test;
            deviceTest.setDevice(this.mDevice);
            deviceTest.setTestAppPath(this.mTestDataPath);
        } else {
            Log.w((String)LOG_TAG, (String)String.format("%s test class is not a DeviceTest.", test.getClass().getName()));
        }
        return super.doRun(test, wait);
    }

    protected TestResult runSingleMethod(String testCase, String method, boolean wait) throws Exception {
        Class testClass = this.loadSuiteClass(testCase);
        Test test = DeviceTestSuite.createTest((Class)testClass, (String)method);
        return this.doRun(test, wait);
    }

    private static class NewDeviceListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private IDevice mDevice;
        private String mSerial;

        public NewDeviceListener(String serial) {
            this.mSerial = serial;
        }

        public void deviceChanged(IDevice device, int changeMask) {
        }

        public void deviceConnected(IDevice device) {
            if (this.mSerial == null) {
                this.setDevice(device);
            } else if (this.mSerial.equals(device.getSerialNumber())) {
                this.setDevice(device);
            }
        }

        private synchronized void setDevice(IDevice device) {
            this.mDevice = device;
            this.notify();
        }

        public void deviceDisconnected(IDevice device) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IDevice waitForDevice(long waitTime) {
            NewDeviceListener newDeviceListener = this;
            synchronized (newDeviceListener) {
                if (this.mDevice == null) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Waiting for device interrupted");
                    }
                }
            }
            return this.mDevice;
        }
    }
}

