/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.ADBServerNeedRestartException;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceObserver;
import com.android.cts.Log;
import com.android.cts.Test;
import com.android.cts.TestDevice;
import com.android.cts.TestSuite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCase
implements DeviceObserver {
    private TestSuite mParentSuite;
    private Collection<Test> mTests;
    private String mName;
    private String mPriority;
    private Test mCurrentTest;
    private boolean mTestStop;

    public TestCase(TestSuite suite, String name, String priority) {
        this.mParentSuite = suite;
        this.mName = name;
        this.mPriority = priority;
        this.mTests = new ArrayList<Test>();
        this.mTestStop = false;
        this.mCurrentTest = null;
    }

    public TestSuite getParent() {
        return this.mParentSuite;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        TestSuite suite = this.getParent();
        return suite.getFullName() + "." + this.getName();
    }

    public String getPriority() {
        return this.mPriority;
    }

    public void addTest(Test test) {
        this.mTests.add(test);
    }

    public Collection<Test> getTests() {
        return this.mTests;
    }

    public ArrayList<String> getExcludedList(String resultType) {
        ArrayList<String> excludedList = new ArrayList<String>();
        for (Test test : this.getTests()) {
            if (resultType == null) {
                if (!test.getResult().isPass()) continue;
                excludedList.add(test.getFullName());
                continue;
            }
            if (test.getResult().getResultString().equals(resultType)) continue;
            excludedList.add(test.getFullName());
        }
        if (excludedList.size() == this.getTests().size()) {
            excludedList.removeAll(excludedList);
            excludedList.add(this.getFullName());
        }
        return excludedList;
    }

    public ArrayList<String> getAllTestNames() {
        ArrayList<String> testNameList = new ArrayList<String>();
        for (Test test : this.getTests()) {
            testNameList.add(test.getFullName());
        }
        return testNameList;
    }

    public Test searchTest(String testName) {
        String sName = this.mParentSuite.getFullName();
        String caseFullName = sName + "." + this.mName;
        int index = 0;
        int testNameStartIndex = testName.lastIndexOf(35) + 1;
        Log.d("searchTest(): testName=" + testName + ",caseFullName=" + caseFullName);
        if (!testName.substring(index).startsWith(caseFullName + "#")) {
            return null;
        }
        if ((index += caseFullName.length() + 1) == testNameStartIndex) {
            String name = testName.substring(testNameStartIndex);
            for (Test test : this.mTests) {
                if (!test.getName().equals(name)) continue;
                return test;
            }
        }
        return null;
    }

    public void setTestStopped(boolean testStopped) {
        this.mTestStop = testStopped;
        if (this.mCurrentTest != null) {
            this.mCurrentTest.setTestStopped(this.mTestStop);
        }
    }

    public void run(TestDevice device) throws DeviceDisconnectedException, ADBServerNeedRestartException {
        this.mTestStop = false;
        Iterator<Test> tests = this.getTests().iterator();
        while (tests.hasNext() && !this.mTestStop) {
            this.mCurrentTest = tests.next();
            if (!this.mCurrentTest.getResult().isNotExecuted()) continue;
            this.mCurrentTest.run(device);
        }
    }

    public void run(TestDevice device, Test test) throws DeviceDisconnectedException, ADBServerNeedRestartException {
        this.mTestStop = false;
        this.mCurrentTest = test;
        this.mCurrentTest.run(device);
    }

    @Override
    public void notifyInstallingComplete(int resultCode) {
        if (this.mCurrentTest != null) {
            this.mCurrentTest.notifyInstallingComplete(resultCode);
        }
    }

    @Override
    public void notifyUninstallingComplete(int resultCode) {
        if (this.mCurrentTest != null) {
            this.mCurrentTest.notifyUninstallingComplete(resultCode);
        }
    }

    @Override
    public void notifyInstallingTimeout(TestDevice testDevice) {
        if (this.mCurrentTest != null) {
            this.mCurrentTest.notifyInstallingTimeout(testDevice);
        }
    }

    @Override
    public void notifyUninstallingTimeout(TestDevice testDevice) {
        if (this.mCurrentTest != null) {
            this.mCurrentTest.notifyUninstallingTimeout(testDevice);
        }
    }

    @Override
    public void notifyTestingDeviceDisconnected() {
        if (this.mCurrentTest != null) {
            this.mCurrentTest.notifyTestingDeviceDisconnected();
        }
    }
}

