/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.ConsoleUi;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Selector {
    public static final String PACKAGE_SELECTOR = "packageSelector";
    public static final String SUITE_SELECTOR = "suiteSelector";
    public static final String CASE_SELECTOR = "caseSelector";
    public static final String TEST_SELECTOR = "testSelector";
    public static final String PACKAGE_HDR = "[Choose package] ";
    public static final String PACKAGE_TAIL = ": select[Y], reject[n], or choose suite in it[m]?  [Y/n/m] ";
    public static final String SUITE_HDR = "[Choose suite]   ";
    public static final String SUITE_TAIL = ": select[Y], reject[n], or choose case in it[m]?  [Y/n/m] ";
    public static final String CASE_HDR = "[Choose case]    ";
    public static final String CASE_TAIL = ": select[Y], reject[n], or choose method in it[m]?  [Y/n/m] ";
    public static final String TEST_HDR = "[Choose test]    ";
    public static final String TEST_TAIL = "?: [Y/n] ";
    public List<String> mRecords;
    public String mHdr;
    public String mTail;
    public String mType;
    public BufferedReader mBufferedReader;

    public Selector(String type, List<String> records) {
        this.mRecords = records;
        Collections.sort(this.mRecords);
        this.mBufferedReader = null;
        this.mType = type;
        if (type.equals(PACKAGE_SELECTOR)) {
            this.mHdr = PACKAGE_HDR;
            this.mTail = PACKAGE_TAIL;
        } else if (type.equals(SUITE_SELECTOR)) {
            this.mHdr = SUITE_HDR;
            this.mTail = SUITE_TAIL;
        } else if (type.equals(CASE_SELECTOR)) {
            this.mHdr = CASE_HDR;
            this.mTail = CASE_TAIL;
        } else if (type.equals(TEST_SELECTOR)) {
            this.mHdr = TEST_HDR;
            this.mTail = TEST_TAIL;
        }
    }

    public void setInputStream(BufferedReader in) {
        this.mBufferedReader = in;
    }

    public String readLine(String prompt) throws IOException {
        String str = null;
        if (this.mBufferedReader != null) {
            CUIOutputStream.print(prompt);
            str = this.mBufferedReader.readLine().trim();
        }
        return str;
    }

    public Selection doAccept(String name) throws IOException {
        Selection selection = Selection.REJECT;
        if (this.mType.equals(TEST_SELECTOR)) {
            String prompt = this.mHdr + "Include " + name + this.mTail;
            String answer = this.readLine(prompt);
            while (!answer.matches("[yn]?")) {
                CUIOutputStream.println("Invalid input. Please chose 'y' or 'n' (default is 'y')");
                answer = this.readLine(prompt);
            }
            if (ConsoleUi.isConfirmation(answer, true)) {
                selection = Selection.ACCEPT;
            }
        } else {
            String prompt = this.mHdr + name + this.mTail;
            String answer = this.readLine(prompt);
            while (!answer.matches("[ynm]?")) {
                CUIOutputStream.println("Invalid input. Please chose 'y', 'n', or 'm' (default is 'y')");
                answer = this.readLine(prompt);
            }
            if (ConsoleUi.isConfirmation(answer, true)) {
                selection = Selection.ACCEPT;
            } else if (0 == "m".compareToIgnoreCase(answer)) {
                selection = Selection.MORE;
            }
        }
        return selection;
    }

    public boolean isSelected(ArrayList<String> selectedList, String name) {
        for (String str : selectedList) {
            if (!name.equals(str) && !this.isSubName(str, name)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubName(String parent, String name) {
        return name.startsWith(parent + ".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Selection {
        ACCEPT,
        REJECT,
        MORE;

    }
}

