/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.HostConfig;
import com.android.cts.Log;
import com.android.cts.Selector;
import com.android.cts.TestPackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlanBuilder
extends Selector {
    private SuiteSelector mSuiteSelector;

    public PlanBuilder(List<String> records) {
        super("packageSelector", records);
    }

    public HashMap<String, ArrayList<String>> doSelect() throws IOException {
        HashMap<String, ArrayList<String>> packages = new HashMap<String, ArrayList<String>>();
        for (String javaPkgName : this.mRecords) {
            Selector.Selection select = this.doAccept(javaPkgName);
            TestPackage testPackage = HostConfig.getInstance().getTestPackage(javaPkgName);
            if (select == Selector.Selection.ACCEPT) {
                packages.put(javaPkgName, null);
                continue;
            }
            if (select != Selector.Selection.MORE) continue;
            List<String> suiteNames = testPackage.getAllTestSuiteNames();
            this.mSuiteSelector = new SuiteSelector(suiteNames, testPackage);
            if (this.mBufferedReader != null) {
                this.mSuiteSelector.setInputStream(this.mBufferedReader);
            }
            ArrayList<String> excludedSuites = new ArrayList<String>();
            ArrayList<String> excludedCases = new ArrayList<String>();
            this.mSuiteSelector.doSelect(excludedSuites, excludedCases);
            if (suiteNames.size() == excludedSuites.size()) {
                Log.i("package=" + javaPkgName + " has been removed all.");
                continue;
            }
            excludedSuites.addAll(excludedCases);
            packages.put(javaPkgName, excludedSuites);
        }
        if (packages.size() == 0) {
            return null;
        }
        return packages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSelector
    extends Selector {
        public TestSelector(List<String> records) {
            super("testSelector", records);
        }

        public ArrayList<String> doSelect() throws IOException {
            ArrayList<String> records = new ArrayList<String>();
            for (String test : this.mRecords) {
                Selector.Selection select = this.doAccept(test);
                if (select != Selector.Selection.REJECT) continue;
                records.add(test);
            }
            return records;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestCaseSelector
    extends Selector {
        private TestSelector mTestSelector;
        private TestPackage mTestPackage;

        public TestCaseSelector(List<String> testCases, TestPackage testPackage) {
            super("caseSelector", testCases);
            this.mTestPackage = testPackage;
        }

        public void doSelect(ArrayList<String> excludedTestCases, ArrayList<String> excludedTests) throws IOException {
            ArrayList<String> selectedList = new ArrayList<String>();
            for (String testCaseName : this.mRecords) {
                if (this.isSelected(selectedList, testCaseName)) continue;
                Selector.Selection select = this.doAccept(testCaseName);
                if (select == Selector.Selection.REJECT) {
                    excludedTestCases.add(testCaseName);
                } else if (select == Selector.Selection.MORE) {
                    ArrayList<String> notIncludedTests;
                    List<String> testNames = this.mTestPackage.getAllTestNames(testCaseName);
                    this.mTestSelector = new TestSelector(testNames);
                    if (this.mBufferedReader != null) {
                        this.mTestSelector.setInputStream(this.mBufferedReader);
                    }
                    if ((notIncludedTests = this.mTestSelector.doSelect()).size() == testNames.size()) {
                        Log.i("testCase=" + testCaseName + " has been removed all");
                        excludedTestCases.add(testCaseName);
                    } else {
                        excludedTests.addAll(notIncludedTests);
                    }
                }
                selectedList.add(testCaseName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SuiteSelector
    extends Selector {
        private TestCaseSelector mCaseSelector;
        private TestPackage mTestPackage;

        public SuiteSelector(List<String> suites, TestPackage testPackage) {
            super("suiteSelector", suites);
            this.mTestPackage = testPackage;
        }

        public void doSelect(ArrayList<String> excludedTestSuites, ArrayList<String> excludedTestCases) throws IOException {
            ArrayList<String> selectedList = new ArrayList<String>();
            for (String suiteName : this.mRecords) {
                if (this.isSelected(selectedList, suiteName)) continue;
                Selector.Selection select = this.doAccept(suiteName);
                if (select == Selector.Selection.REJECT) {
                    excludedTestSuites.add(suiteName);
                } else if (select == Selector.Selection.MORE) {
                    List<String> testCaseNames = this.mTestPackage.getAllTestCaseNames(suiteName);
                    this.mCaseSelector = new TestCaseSelector(testCaseNames, this.mTestPackage);
                    if (this.mBufferedReader != null) {
                        this.mCaseSelector.setInputStream(this.mBufferedReader);
                    }
                    ArrayList<String> notIncludedTestCases = new ArrayList<String>();
                    ArrayList<String> notIncludedTests = new ArrayList<String>();
                    this.mCaseSelector.doSelect(notIncludedTestCases, notIncludedTests);
                    if (testCaseNames.size() == notIncludedTestCases.size()) {
                        Log.i("suite=" + suiteName + " has been removed all");
                        excludedTestSuites.add(suiteName);
                    } else {
                        excludedTestCases.addAll(notIncludedTestCases);
                        excludedTestCases.addAll(notIncludedTests);
                    }
                }
                selectedList.add(suiteName);
            }
        }
    }
}

