/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.CommandHistory;
import com.android.cts.CommandNotFoundException;
import com.android.cts.CommandParser;
import com.android.cts.CtsTestResult;
import com.android.cts.DeviceDisconnectedException;
import com.android.cts.DeviceNotAvailableException;
import com.android.cts.HostConfig;
import com.android.cts.HostUtils;
import com.android.cts.IllegalTestNameException;
import com.android.cts.InvalidApkPathException;
import com.android.cts.InvalidNameSpaceException;
import com.android.cts.Log;
import com.android.cts.PlanBuilder;
import com.android.cts.Test;
import com.android.cts.TestDevice;
import com.android.cts.TestHost;
import com.android.cts.TestNotFoundException;
import com.android.cts.TestPackage;
import com.android.cts.TestPlan;
import com.android.cts.TestPlanNotFoundException;
import com.android.cts.TestSession;
import com.android.cts.TestSessionBuilder;
import com.android.cts.TestSessionLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleUi {
    private static final String OS_NAME_LINUX = "Linux";
    private static final String LS_PLAN_SEPARATOR = "=================================";
    private static final String CMD_TYPE_LEADING_SPACE = "  ";
    private static final String CMD_OPT_LEADING_SPACE = "    ";
    private static final String CREATE_SESSION = "create a new session";
    private static final String CHOOSE_SESSION = "choose a session";
    private TestHost mHost;
    private boolean mKeepRunning;
    private BufferedReader mCommandInput;
    private CommandHistory mCommandHistory = new CommandHistory();
    private String mOsName = "none";
    static final String CASE_NAME_PATTERN_STR = "((\\S+\\.)+\\S+)\\.(\\S+):(\\S+)";
    private static HashMap<String, Integer> mResultCodeMap = new HashMap();

    public ConsoleUi(TestHost host) {
        this.mHost = host;
        this.mCommandInput = new BufferedReader(new InputStreamReader(System.in));
        this.mKeepRunning = true;
        this.initInputStream();
    }

    public void startUi() {
        while (this.mKeepRunning) {
            try {
                String cmdLine = this.readLine("cts_host > ");
                CommandParser cp = CommandParser.parse(cmdLine);
                this.processCommand(cp);
                this.mCommandHistory.addCommand(cp, cmdLine);
            }
            catch (CommandNotFoundException e) {
            }
            catch (Exception e) {
                Log.e("Got exception while processing command.", e);
                this.showHelp();
            }
        }
    }

    private void initInputStream() {
        if (!this.mOsName.equals(OS_NAME_LINUX)) {
            this.mCommandInput = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    private String readLine(String prompt) throws IOException {
        String cmdLine = null;
        if (!this.mOsName.equals(OS_NAME_LINUX)) {
            CUIOutputStream.print(prompt);
            cmdLine = this.mCommandInput.readLine().trim();
        }
        return cmdLine;
    }

    private void showHelp() {
        CUIOutputStream.println("Usage: command options");
        CUIOutputStream.println("Avaiable commands and options:");
        this.showHostCmdHelp();
        this.showPlanCmdHelp();
        this.showPackageCmdHelp();
        this.showResultCmdHelp();
        this.showHistoryCmdHelp();
        this.showDeviceCmdHelp();
    }

    private void showHistoryCmdHelp() {
        String cmdStr = "history/h";
        CUIOutputStream.println("  History:");
        CUIOutputStream.println("    history/h: list all commands in command history");
        CUIOutputStream.println("    history/h count: list the latest count records in command history");
        CUIOutputStream.println("    history/h -e num: run the command designated by 'num' in command history");
    }

    private void showResultCmdHelp() {
        String cmdStr = "ls -r/--result";
        String sessionStr = "-s/--session";
        String resultsStr = " [pass/fail/notExecuted/timeout] ";
        CUIOutputStream.println("  Result:");
        CUIOutputStream.println("    ls -r/--result: list all result of sessions");
        CUIOutputStream.println("    ls -r/--result -s/--session session_id: list detail case result of a specified session");
        CUIOutputStream.println("    ls -r/--result [pass/fail/notExecuted/timeout] -s/--session session_id: list detail cases of a specified session by the specified result.");
    }

    private void showPackageCmdHelp() {
        String cmdStr = "ls -p/--package";
        String pkgStr = "-p/--package";
        CUIOutputStream.println("  Package:");
        CUIOutputStream.println("    ls -p/--package: list available packages");
        CUIOutputStream.println("    ls -p/--package package_name: list contents of the package with specified name");
        CUIOutputStream.println("    add -p/--package root: add packages from root to repository");
        CUIOutputStream.println("    rm -p/--package package_name/all: remove a package or all packages from repository");
    }

    private void showPlanCmdHelp() {
        String lsPlanStr = "ls --plan";
        String addPlanStr = "add --plan";
        String rmPlanStr = "rm --plan";
        String addDerivedPlanStr = "add --derivedplan";
        CUIOutputStream.println("  Plan:");
        CUIOutputStream.println("    ls --plan: list available plans");
        CUIOutputStream.println("    ls --plan plan_name: list contents of the plan with specified name");
        CUIOutputStream.println("    add --plan plan_name: add a new plan with specified name");
        CUIOutputStream.println("    add --derivedplan plan_name -s/--session session_id -r/--result result_type: derive a plan from the given session");
        CUIOutputStream.println("    rm --plan plan_name/all: remove a plan or all plans from repository");
        this.showStartSessionHelp();
    }

    private void showStartSessionHelp() {
        String cmdStr = "start --plan";
        String testStr = "-t/--test";
        String deviceStr = "-d/--device";
        String pkgStr = "-p/--package";
        CUIOutputStream.println("    start --plan test_plan_name: run a test plan");
        CUIOutputStream.println("    start --plan test_plan_name -d/--device device_ID: run a test plan using the specified device");
        CUIOutputStream.println("    start --plan test_plan_name -t/--test test_name: run a specific test");
        CUIOutputStream.println("    start --plan test_plan_name -p/--package java_package_name: run a specific java package");
        CUIOutputStream.println("    start --plan test_plan_name -t/--test test_name -d/--device device_ID: run a specific test using the specified device");
        CUIOutputStream.println("    start --plan test_plan_name -p/--package java_package_name -d/--device device_ID: run a specific java package using the specified device");
    }

    private void showHostCmdHelp() {
        CUIOutputStream.println("  Host:");
        CUIOutputStream.println("    help: show this message");
        CUIOutputStream.println("    exit: exit cts command line");
    }

    private void showDeviceCmdHelp() {
        String deviceStr = "-d/--device";
        CUIOutputStream.println("  Device:");
        CUIOutputStream.println("    ls -d/--device: list available devices");
    }

    public void processCommand(CommandParser cp) throws Exception {
        String action = cp.getAction();
        if (action.equals("exit")) {
            if (cp.getArgSize() != 1) {
                this.showHelp();
                return;
            }
            Log.d("exit cts host");
            this.mKeepRunning = false;
            this.mHost.tearDown();
        } else if (action.equals("help")) {
            this.showHelp();
        } else if (this.mCommandHistory.isHistoryCommand(action)) {
            this.processHistoryCommands(cp);
        } else if (action.equals("add")) {
            this.processAddCommand(cp);
        } else if (action.equals("start")) {
            this.processStartCommand(cp);
        } else if (action.equals("rm")) {
            this.processRmCommand(cp);
        } else if (action.equals("ls")) {
            this.processListCommand(cp);
        } else {
            this.showHelp();
        }
    }

    private void processStartCommand(CommandParser cp) throws SAXException, ParserConfigurationException {
        if (cp.containsKey("--plan")) {
            this.processStartSessionCommand(cp);
        } else if (cp.containsKey("-p") || cp.containsKey("--package")) {
            this.processStartPackageCommand(cp);
        } else {
            this.showHelp();
        }
    }

    private void processStartPackageCommand(CommandParser cp) {
        try {
            String pathName = cp.getValue("--package");
            this.mHost.startZippedPackage(pathName);
        }
        catch (DeviceDisconnectedException e) {
            Log.e("Device " + e.getMessage() + " disconnected", e);
        }
        catch (Exception e) {
            Log.e("Met exception during running zipped package.", e);
        }
    }

    public boolean validateCommandParams(CommandParser cp) {
        if (cp == null) {
            return false;
        }
        if (cp.getAction() == null) {
            return true;
        }
        if (ConsoleUi.isValidCommandOption(cp, "start", "--plan")) {
            return true;
        }
        if (ConsoleUi.isValidCommandOption(cp, "start", "--package")) {
            return true;
        }
        return ConsoleUi.isValidCommandOption(cp, "start", "-p");
    }

    private static boolean isValidCommandOption(CommandParser cp, String command, String option) {
        return cp.getAction().equals(command) && cp.containsKey(option) && cp.getValue(option) != null && cp.getValue(option).length() != 0;
    }

    private void processStartSessionCommand(CommandParser cp) throws SAXException, ParserConfigurationException {
        if (this.mHost.getDeviceList().length == 0) {
            Log.e("No device connected", null);
            return;
        }
        String testPlanPath = null;
        String deviceId = null;
        String testName = null;
        String javaPkgName = null;
        String testPlanName = this.mHost.getPlanName(cp.getValue("--plan"));
        try {
            String[] deviceIdList;
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() < 1 || cp.getOptionSize() > 3) {
                this.showStartSessionHelp();
                return;
            }
            testPlanName = this.mHost.getPlanName(cp.getValue("--plan"));
            testPlanPath = HostConfig.getInstance().getPlanRepository().getPlanPath(testPlanName);
            if (testPlanPath == null) {
                CUIOutputStream.println("Plan " + testPlanName + " is not in repository, please create it!");
                return;
            }
            if (cp.containsKey("--device") && (deviceIdList = (deviceId = cp.getValue("--device")).trim().split(",")).length > 1) {
                Log.e("Just allow choosing one device ID.", null);
                return;
            }
            TestHost.ActionType actionType = TestHost.ActionType.START_NEW_SESSION;
            if (cp.containsKey("--test")) {
                testName = cp.getValue("--test");
                if (-1 == testName.indexOf("#")) {
                    Log.e("Test full name must be in the form of: java_package_name.class_name#method_name.", null);
                    return;
                }
                actionType = TestHost.ActionType.RUN_SINGLE_TEST;
            } else if (cp.containsKey("--package")) {
                javaPkgName = cp.getValue("--package");
                actionType = TestHost.ActionType.RUN_SINGLE_JAVA_PACKAGE;
            }
            TestSession ts = null;
            ArrayList<TestSession> sessionList = this.mHost.getSessionList(testPlanName);
            if (sessionList != null && sessionList.size() > 0) {
                String mode;
                if ((testName == null || testName.length() == 0) && CREATE_SESSION.equals(mode = this.chooseMode(sessionList))) {
                    ts = TestHost.createSession(testPlanName);
                }
                if (ts == null) {
                    ts = this.chooseTestSession(sessionList);
                    deviceId = ts.getDeviceId();
                    if (actionType != TestHost.ActionType.RUN_SINGLE_TEST && actionType != TestHost.ActionType.RUN_SINGLE_JAVA_PACKAGE) {
                        actionType = TestHost.ActionType.RESUME_SESSION;
                    }
                }
            }
            if (deviceId == null) {
                TestDevice td = this.mHost.getFirstAvailableDevice();
                if (td == null) {
                    CUIOutputStream.println("No idle devices found.");
                    return;
                }
                deviceId = td.getSerialNumber();
            }
            if (!this.checkDeviceExists(this.mHost.getDeviceList(), deviceId)) {
                CUIOutputStream.println("Can't find specified device id.  Is it attached?");
                return;
            }
            if (ts == null) {
                ts = TestHost.createSession(testPlanName);
            }
            this.mHost.startSession(ts, deviceId, testName, javaPkgName, actionType);
        }
        catch (IOException e) {
            Log.e("Can't create test session", e);
        }
        catch (DeviceNotAvailableException e) {
            CUIOutputStream.println("Test plan(" + testPlanName + ") " + e.getMessage());
            this.showStartSessionHelp();
        }
        catch (TestNotFoundException e) {
            CUIOutputStream.println(e.getMessage());
        }
        catch (TestPlanNotFoundException e) {
            CUIOutputStream.println("Can't find test plan " + testPlanName);
        }
        catch (IllegalTestNameException e) {
            CUIOutputStream.println("Illegal case name: " + testName);
        }
        catch (DeviceDisconnectedException e) {
            Log.e("Device " + e.getMessage() + " disconnected ", null);
        }
        catch (NoSuchAlgorithmException e) {
            Log.e("Fail to initialise SHA-1 algorithm", e);
        }
        catch (InvalidApkPathException e) {
            Log.e(e.getMessage(), null);
        }
        catch (InvalidNameSpaceException e) {
            Log.e(e.getMessage(), null);
        }
    }

    private TestSession chooseTestSession(ArrayList<TestSession> sessionList) throws IOException {
        if (sessionList == null || sessionList.size() == 0) {
            return null;
        }
        if (sessionList.size() == 1) {
            return sessionList.get(0);
        }
        int index = 0;
        String notification = "Please choose a session from the existed session(s):\n";
        for (TestSession session : sessionList) {
            notification = notification + CMD_TYPE_LEADING_SPACE + session.getId() + "  [" + index + "] \n";
            ++index;
        }
        return sessionList.get(this.getUserInputId(notification, 0, index));
    }

    private String chooseMode(ArrayList<TestSession> sessionList) throws IOException {
        if (TestHost.sMode == TestHost.MODE.RUN || sessionList == null || sessionList.size() == 0) {
            return CREATE_SESSION;
        }
        String planName = sessionList.get(0).getSessionLog().getTestPlanName();
        String notification = "There are " + sessionList.size() + " existing session(s) for plan " + planName + ".\n" + "Create a new session or choose an existing one?\n" + "  Create a new session [0]\n" + "  Choose a session     [1]\n";
        int indexSelected = this.getUserInputId(notification, 0, 2);
        if (indexSelected == 0) {
            return CREATE_SESSION;
        }
        return CHOOSE_SESSION;
    }

    public boolean checkDeviceExists(TestDevice[] availableDevices, String specifiedId) {
        for (TestDevice dev : availableDevices) {
            if (!specifiedId.equals(dev.getSerialNumber())) continue;
            return true;
        }
        return false;
    }

    public int getDeviceId(TestDevice[] availableDevices, String idStr) {
        for (int i = 0; i < availableDevices.length; ++i) {
            TestDevice dev = availableDevices[i];
            if (!idStr.equals(dev.getSerialNumber())) continue;
            return i;
        }
        return -1;
    }

    private int getUserInputId(String notification, int startIndex, int endIndex) throws IOException {
        int indexSelected = 0;
        boolean success = false;
        while (!success) {
            String answer = this.readLine(notification);
            try {
                indexSelected = Integer.parseInt(answer);
                if (indexSelected >= 0 && indexSelected < endIndex) {
                    success = true;
                    continue;
                }
                CUIOutputStream.println("" + indexSelected + " is out of range [0," + (endIndex - 1) + "].");
            }
            catch (NumberFormatException e) {
                CUIOutputStream.println("Invalid nuber is typed in.");
            }
        }
        return indexSelected;
    }

    public boolean isValidDeviceId(int numOfAvailableDevices, int specifiedId) {
        return specifiedId >= 0 && specifiedId < numOfAvailableDevices;
    }

    private void processListCommand(CommandParser cp) throws SAXException, IOException, ParserConfigurationException {
        if (cp.containsKey("--device")) {
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() != 1) {
                this.showDeviceCmdHelp();
                return;
            }
            if (cp.getValue("--device").equals("")) {
                this.listDevices();
            } else {
                this.showDeviceCmdHelp();
            }
        } else if (cp.containsKey("--plan")) {
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() != 1) {
                this.showPlanCmdHelp();
                return;
            }
            String planValue = cp.getValue("--plan");
            if (planValue.equals("")) {
                this.listPlans();
            } else {
                this.listSinglePlan(this.mHost.getPlanName(planValue));
            }
        } else if (cp.containsKey("--result")) {
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() < 1 || cp.getOptionSize() > 2) {
                this.showResultCmdHelp();
                return;
            }
            String resultValue = cp.getValue("--result");
            String sessionId = cp.getValue("--session");
            Integer resultCode = null;
            if (sessionId != null) {
                if (resultValue.length() != 0 && !mResultCodeMap.containsKey(resultValue)) {
                    this.showResultCmdHelp();
                } else {
                    resultCode = mResultCodeMap.get(resultValue);
                    this.listSessionResult(sessionId, resultCode);
                }
            } else if (resultValue.length() == 0) {
                this.listResults();
            } else {
                this.showHelp();
            }
        } else if (cp.containsKey("--package")) {
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() != 1) {
                this.showPackageCmdHelp();
                return;
            }
            this.listPackages(cp);
        } else {
            this.showHelp();
        }
    }

    private void processRmCommand(CommandParser cp) throws IOException {
        if (cp.containsKey("--plan")) {
            String prompt;
            String answer;
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() != 1) {
                this.showPlanCmdHelp();
                return;
            }
            String planName = this.mHost.getPlanName(cp.getValue("--plan"));
            if ("all".equals(planName) && !ConsoleUi.isConfirmation(answer = this.readLine(prompt = "Remove all of the plans?([y/N])").trim(), false)) {
                return;
            }
            this.mHost.removePlans(planName);
        } else if (cp.containsKey("--package")) {
            String prompt;
            String answer;
            if (cp.getActionValues().size() != 0 || cp.getOptionSize() != 1) {
                this.showPackageCmdHelp();
                return;
            }
            String packageName = cp.getValue("--package");
            if ("all".equals(packageName) && !ConsoleUi.isConfirmation(answer = this.readLine(prompt = "Remove all of the packages?([y/N])").trim(), false)) {
                return;
            }
            this.mHost.removePackages(packageName);
        } else {
            this.showHelp();
        }
    }

    public static boolean isConfirmation(String answer, boolean defaultResult) {
        if ("".equals(answer)) {
            return defaultResult;
        }
        return "y".equals(answer.toLowerCase()) || "yes".equals(answer.toLowerCase());
    }

    private void processAddCommand(CommandParser cp) {
        if (cp.containsKey("--plan")) {
            if (this.isValidAddPlanArguments(cp)) {
                this.createPlan(cp, "--plan");
            } else {
                this.showPlanCmdHelp();
            }
        } else if (cp.containsKey("--derivedplan")) {
            if (this.isValidDerivedPlanArguments(cp)) {
                this.createPlan(cp, "--derivedplan");
            } else {
                this.showPlanCmdHelp();
            }
        } else if (cp.containsKey("--package")) {
            try {
                this.addPackage(cp);
            }
            catch (IOException e) {
                Log.e("Can't add package", e);
            }
            catch (IndexOutOfBoundsException e) {
                Log.e("Can't add package", e);
            }
            catch (NoSuchAlgorithmException e) {
                Log.e("Can't add package", e);
            }
        } else {
            this.showHelp();
        }
    }

    private boolean isValidAddPlanArguments(CommandParser cp) {
        return cp.getArgSize() == 3 && cp.getActionValues().size() == 0 && cp.getOptionSize() == 1;
    }

    private boolean isValidDerivedPlanArguments(CommandParser cp) {
        return cp.getArgSize() >= 3 && cp.getActionValues().size() == 0 && cp.getOptionSize() >= 1;
    }

    private void processHistoryCommands(CommandParser cp) throws Exception {
        try {
            if (cp.getOptionSize() == 0 && cp.getActionValues().size() == 0) {
                this.mCommandHistory.show(this.mCommandHistory.size());
            } else if (cp.containsKey("-e") && cp.getActionValues().size() == 0) {
                int cmdNum = 0;
                cmdNum = Integer.parseInt(cp.getValue("-e"));
                if (cmdNum >= 0 && cmdNum < this.mCommandHistory.size()) {
                    String cmdLine = this.mCommandHistory.get(cmdNum);
                    CommandParser cpH = CommandParser.parse(cmdLine);
                    CUIOutputStream.printPrompt();
                    CUIOutputStream.println(cmdLine);
                    this.processCommand(cpH);
                    this.mCommandHistory.addCommand(cpH, cmdLine);
                } else if (this.mCommandHistory.size() > 0) {
                    Log.e("Command index " + cmdNum + " is out of command history range [0," + (this.mCommandHistory.size() - 1) + "].", null);
                } else {
                    Log.e("No command exists in command history.", null);
                }
            } else if (cp.getOptionSize() == 0 && cp.getActionValues().size() == 1) {
                int cmdCount = Integer.parseInt(cp.getActionValues().iterator().next());
                if (cmdCount < 0 || cmdCount > this.mCommandHistory.size()) {
                    cmdCount = this.mCommandHistory.size();
                }
                this.mCommandHistory.show(cmdCount);
            } else {
                this.showHistoryCmdHelp();
            }
        }
        catch (NumberFormatException e) {
            this.showHistoryCmdHelp();
        }
    }

    private void listSinglePlan(String name) throws SAXException, IOException, ParserConfigurationException {
        String planName = null;
        for (String str : this.mHost.getPlanRepository().getAllPlanNames()) {
            if (!str.startsWith(name)) continue;
            planName = str;
            break;
        }
        if (planName == null) {
            Log.e("No plan named " + name + " in repository!", null);
            return;
        }
        String planPath = this.mHost.getPlanRepository().getPlanPath(planName);
        ArrayList<String> removedPkgList = new ArrayList<String>();
        Collection<String> pkgNames = TestPlan.getEntries(planPath, removedPkgList);
        if (removedPkgList.size() != 0) {
            CUIOutputStream.println("The following package(s) contained in plan " + planName + " have been removed:");
            for (String pkgName : removedPkgList) {
                CUIOutputStream.println(CMD_OPT_LEADING_SPACE + pkgName);
            }
        }
        if (pkgNames.size() > 0) {
            CUIOutputStream.println("Packages of plan " + planName + " (" + pkgNames.size() + " in total):");
            CUIOutputStream.println(LS_PLAN_SEPARATOR);
            for (String pkgName : pkgNames) {
                CUIOutputStream.println(pkgName);
            }
        }
    }

    private void createPlanFromSession(String name, TestSession ts, String resultType) throws FileNotFoundException, IOException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        HashMap<String, ArrayList<String>> selectedResult = new HashMap<String, ArrayList<String>>();
        ArrayList<String> packageNames = new ArrayList<String>();
        for (TestPackage pkg : ts.getSessionLog().getTestPackages()) {
            String pkgName = pkg.getAppPackageName();
            ArrayList<String> excludedList = pkg.getExcludedList(resultType);
            if (excludedList == null) continue;
            packageNames.add(pkgName);
            selectedResult.put(pkgName, excludedList);
        }
        if (selectedResult != null && selectedResult.size() > 0) {
            TestSessionBuilder.getInstance().serialize(name, packageNames, selectedResult);
        } else if (resultType == null) {
            Log.i("All tests of session " + ts.getId() + " have passed execution. The plan is not created!");
        } else {
            Log.i("No " + resultType + " tests of session " + ts.getId() + ". The plan is not created!");
        }
    }

    private void addDerivedPlan(CommandParser cp, String name, ArrayList<String> packageNames) {
        try {
            TestSession ts;
            String sessionId = null;
            String resultType = null;
            int id = TestSession.getLastSessionId();
            if (cp.containsKey("--session")) {
                sessionId = cp.getValue("--session");
                id = Integer.parseInt(sessionId);
            }
            if ((ts = this.mHost.getSession(id)) == null) {
                Log.e("The session ID of " + id + " doesn't exist.", null);
                return;
            }
            if (cp.containsKey("--result") && !CtsTestResult.isValidResultType(resultType = cp.getValue("--result"))) {
                Log.e("The following result type is invalid: " + resultType, null);
                return;
            }
            this.createPlanFromSession(name, ts, resultType);
        }
        catch (Exception e) {
            Log.e("Got exception while trying to add a plan!", e);
            return;
        }
    }

    private void addPlan(CommandParser cp, String name, ArrayList<String> packageNames) {
        try {
            PlanBuilder planBuilder = new PlanBuilder(packageNames);
            if (!this.mOsName.equals(OS_NAME_LINUX)) {
                planBuilder.setInputStream(this.mCommandInput);
            }
            HashMap<String, ArrayList<String>> selectedResult = planBuilder.doSelect();
            if (selectedResult != null) {
                TestSessionBuilder.getInstance().serialize(name, packageNames, selectedResult);
            } else {
                Log.i("Selected nothing for the plan of " + name + ". The plan is not created!");
            }
        }
        catch (Exception e) {
            Log.e("Got exception while trying to add a plan!", e);
            return;
        }
    }

    private void createPlan(CommandParser cp, String type) {
        String name = null;
        if ("--plan".equals(type)) {
            name = cp.getValue("--plan");
        } else if ("--derivedplan".equals(type)) {
            name = cp.getValue("--derivedplan");
        } else {
            return;
        }
        if (HostUtils.isFileExist(HostConfig.getInstance().getPlanRepository().getPlanPath(name))) {
            Log.e("Plan " + name + " already exist, please use another name!", null);
            return;
        }
        try {
            if (name != null && !name.matches("\\w+")) {
                CUIOutputStream.println("Only letter of the alphabet, number and '_' are available for test plan name");
                return;
            }
            ArrayList<String> packageNames = HostConfig.getInstance().getCaseRepository().getPackageNames();
            Collection<TestPackage> testPackages = HostConfig.getInstance().getTestPackages();
            if (testPackages.size() == 0) {
                CUIOutputStream.println("No package found in repository, please add package first!");
                return;
            }
            if ("--plan".equals(type)) {
                this.addPlan(cp, name, packageNames);
            } else if ("--derivedplan".equals(type)) {
                this.addDerivedPlan(cp, name, packageNames);
            }
        }
        catch (Exception e) {
            Log.e("Got exception while trying to add a plan!", e);
            return;
        }
    }

    private void listPlans() {
        ArrayList<String> plans = this.mHost.getPlanRepository().getAllPlanNames();
        if (plans.size() == 0) {
            CUIOutputStream.println("No plan created!");
        } else {
            CUIOutputStream.println("List of plans (" + plans.size() + " in total):");
            for (String name : plans) {
                CUIOutputStream.println(name);
            }
        }
    }

    private void listSessionResult(String idStr, Integer resultType) {
        if (!idStr.matches("\\d+")) {
            this.showResultCmdHelp();
            return;
        }
        int sessionId = Integer.parseInt(idStr);
        TestSession ts = this.mHost.getSession(sessionId);
        if (null == ts) {
            Log.e("Can't find specified session", null);
            return;
        }
        TestSessionLog log = ts.getSessionLog();
        CUIOutputStream.println("Result of session " + ts.getId());
        CUIOutputStream.println("Result\t\tCase name");
        CUIOutputStream.println("==============================================================");
        for (Test test : log.getAllResults()) {
            CtsTestResult result = test.getResult();
            if (resultType != null && result.getResultCode() != resultType.intValue()) continue;
            CUIOutputStream.println(result.getResultString() + "\t\t" + test.getFullName());
        }
    }

    private void listResults() {
        Collection<TestSession> sessions = this.mHost.getSessions();
        if (sessions.isEmpty()) {
            CUIOutputStream.println("There isn't any test result!");
        } else {
            CUIOutputStream.println("List of all results: ");
            CUIOutputStream.println("Session\t\tTest result\t\t\t\tStart time\t\tEnd time\t\tTest plan name");
            CUIOutputStream.println("\t\tPass\tFail\tTimeout\tNotExecuted");
            for (TestSession session : sessions) {
                TestSessionLog log = session.getSessionLog();
                int passNum = log.getTestList(1).size();
                int failNum = log.getTestList(2).size();
                int notExecutedNum = log.getTestList(0).size();
                int timeOutNum = log.getTestList(4).size();
                String resStr = Long.toString(passNum) + "\t" + failNum;
                resStr = resStr + "\t" + timeOutNum;
                resStr = resStr + "\t" + notExecutedNum;
                String startTimeStr = HostUtils.getFormattedTimeString(log.getStartTime().getTime(), " ", ".", ":");
                String endTimeStr = HostUtils.getFormattedTimeString(log.getEndTime().getTime(), " ", ".", ":");
                CUIOutputStream.println(Long.toString(session.getId()) + "\t\t" + resStr + "\t\t" + startTimeStr + "\t" + endTimeStr + "\t" + log.getTestPlanName());
            }
        }
    }

    private void addPackage(CommandParser cp) throws IOException, IndexOutOfBoundsException, NoSuchAlgorithmException {
        if (cp.getActionValues().size() != 0 || cp.getOptionSize() != 1) {
            this.showPackageCmdHelp();
            return;
        }
        String pathName = cp.getValue("--package");
        this.mHost.addPackage(pathName);
    }

    private void listPackages(CommandParser cp) {
        block11: {
            ArrayList<String> testList;
            ArrayList<String> caseList;
            ArrayList<String> suiteList;
            ArrayList<String> packageList;
            block13: {
                String expectPackage;
                block12: {
                    Collection<TestPackage> testPackages;
                    block10: {
                        expectPackage = cp.getValue("--package");
                        String caseRoot = this.mHost.getCaseRepository().getRoot();
                        if (caseRoot == null) {
                            Log.e("Case repository is null", null);
                            return;
                        }
                        File root = new File(caseRoot);
                        if (!root.isDirectory()) {
                            Log.e("Case repository must be a directory!", null);
                            return;
                        }
                        testPackages = HostConfig.getInstance().getTestPackages();
                        if (testPackages.size() != 0) break block10;
                        CUIOutputStream.println("No package available under case repository!");
                        break block11;
                    }
                    if (!expectPackage.equals("")) break block12;
                    CUIOutputStream.println("Available packages (" + testPackages.size() + " in total):");
                    for (TestPackage pkg : testPackages) {
                        CUIOutputStream.println(pkg.getAppPackageName());
                    }
                    break block11;
                }
                List<ArrayList<String>> list = this.mHost.getCaseRepository().listAvailablePackage(expectPackage);
                packageList = list.get(0);
                suiteList = list.get(1);
                caseList = list.get(2);
                testList = list.get(3);
                if (packageList.size() != 0 || suiteList.size() != 0 || caseList.size() != 0 || testList.size() != 0) break block13;
                CUIOutputStream.println("Not available test package, suite, cases or tests: " + expectPackage);
                break block11;
            }
            if (packageList.size() != 0) {
                CUIOutputStream.println("Test packages (" + packageList.size() + " in total):");
                for (String packageName : packageList) {
                    CUIOutputStream.println(packageName);
                }
            }
            if (suiteList.size() != 0) {
                CUIOutputStream.println("Test suites (" + suiteList.size() + " in total):");
                for (String suiteName : suiteList) {
                    CUIOutputStream.println(suiteName);
                }
            }
            if (caseList.size() != 0) {
                CUIOutputStream.println("Test cases (" + caseList.size() + " in total):");
                for (String caseName : caseList) {
                    CUIOutputStream.println(caseName);
                }
            }
            if (testList.size() == 0) break block11;
            CUIOutputStream.println("Tests (" + testList.size() + " in total):");
            for (String testName : testList) {
                CUIOutputStream.println(testName);
            }
        }
    }

    private void listDevices() {
        String[] deviceNames = this.mHost.listDevices();
        if (deviceNames.length == 0) {
            CUIOutputStream.println("No device connected.");
            return;
        }
        CUIOutputStream.println("Id\t\tDevice Name\t\tStatus");
        for (int i = 0; i < deviceNames.length; ++i) {
            CUIOutputStream.println(i + "\t\t" + deviceNames[i]);
        }
    }

    static {
        mResultCodeMap.put("pass", 1);
        mResultCodeMap.put("fail", 2);
        mResultCodeMap.put("error", 3);
        mResultCodeMap.put("notExecuted", 0);
        mResultCodeMap.put("timeout", 4);
    }
}

