/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.appsecurity;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.hosttest.DeviceTestCase;
import com.android.hosttest.DeviceTestSuite;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;

public class AppSecurityTests
extends DeviceTestCase {
    private static final String SHARED_UI_APK = "CtsSharedUidInstall.apk";
    private static final String SHARED_UI_PKG = "com.android.cts.shareuidinstall";
    private static final String SHARED_UI_DIFF_CERT_APK = "CtsSharedUidInstallDiffCert.apk";
    private static final String SHARED_UI_DIFF_CERT_PKG = "com.android.cts.shareuidinstalldiffcert";
    private static final String SIMPLE_APP_APK = "CtsSimpleAppInstall.apk";
    private static final String SIMPLE_APP_PKG = "com.android.cts.simpleappinstall";
    private static final String SIMPLE_APP_DIFF_CERT_APK = "CtsSimpleAppInstallDiffCert.apk";
    private static final String APP_WITH_DATA_APK = "CtsAppWithData.apk";
    private static final String APP_WITH_DATA_PKG = "com.android.cts.appwithdata";
    private static final String APP_ACCESS_DATA_APK = "CtsAppAccessData.apk";
    private static final String APP_ACCESS_DATA_PKG = "com.android.cts.appaccessdata";
    private static final String TARGET_INSTRUMENT_APK = "CtsTargetInstrumentationApp.apk";
    private static final String TARGET_INSTRUMENT_PKG = "com.android.cts.targetinstrumentationapp";
    private static final String INSTRUMENT_DIFF_CERT_APK = "CtsInstrumentationAppDiffCert.apk";
    private static final String INSTRUMENT_DIFF_CERT_PKG = "com.android.cts.instrumentationdiffcertapp";
    private static final String DECLARE_PERMISSION_APK = "CtsPermissionDeclareApp.apk";
    private static final String DECLARE_PERMISSION_PKG = "com.android.cts.permissiondeclareapp";
    private static final String PERMISSION_DIFF_CERT_APK = "CtsUsePermissionDiffCert.apk";
    private static final String PERMISSION_DIFF_CERT_PKG = "com.android.cts.usespermissiondiffcertapp";
    private static final String LOG_TAG = "AppSecurityTests";

    protected void setUp() throws Exception {
        super.setUp();
        AppSecurityTests.assertNotNull((Object)this.getTestAppPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedUidDifferentCerts() throws IOException {
        Log.i((String)LOG_TAG, (String)"installing apks with shared uid, but different certs");
        try {
            this.getDevice().uninstallPackage(SHARED_UI_PKG);
            this.getDevice().uninstallPackage(SHARED_UI_DIFF_CERT_PKG);
            String installResult = this.getDevice().installPackage(this.getTestAppFilePath(SHARED_UI_APK), false);
            AppSecurityTests.assertNull((String)"failed to install shared uid app", (Object)installResult);
            installResult = this.getDevice().installPackage(this.getTestAppFilePath(SHARED_UI_DIFF_CERT_APK), false);
            AppSecurityTests.assertNotNull((String)"shared uid app with different cert than existing app installed successfully", (Object)installResult);
            AppSecurityTests.assertEquals((String)"INSTALL_FAILED_UPDATE_INCOMPATIBLE", (String)installResult);
        }
        finally {
            this.getDevice().uninstallPackage(SHARED_UI_PKG);
            this.getDevice().uninstallPackage(SHARED_UI_DIFF_CERT_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppUpgradeDifferentCerts() throws IOException {
        Log.i((String)LOG_TAG, (String)"installing app upgrade with different certs");
        try {
            this.getDevice().uninstallPackage(SIMPLE_APP_PKG);
            String installResult = this.getDevice().installPackage(this.getTestAppFilePath(SIMPLE_APP_APK), false);
            AppSecurityTests.assertNull((String)"failed to install simple app", (Object)installResult);
            installResult = this.getDevice().installPackage(this.getTestAppFilePath(SIMPLE_APP_DIFF_CERT_APK), true);
            AppSecurityTests.assertNotNull((String)"app upgrade with different cert than existing app installed successfully", (Object)installResult);
            AppSecurityTests.assertEquals((String)"INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES", (String)installResult);
        }
        finally {
            this.getDevice().uninstallPackage(SIMPLE_APP_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppFailAccessPrivateData() throws IOException {
        Log.i((String)LOG_TAG, (String)"installing app that attempts to access another app's private data");
        try {
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
            this.getDevice().uninstallPackage(APP_ACCESS_DATA_PKG);
            String installResult = this.getDevice().installPackage(this.getTestAppFilePath(APP_WITH_DATA_APK), false);
            AppSecurityTests.assertNull((String)"failed to install app with data", (Object)installResult);
            AppSecurityTests.assertTrue((String)"failed to create app's private data", (boolean)this.runDeviceTests(APP_WITH_DATA_PKG));
            installResult = this.getDevice().installPackage(this.getTestAppFilePath(APP_ACCESS_DATA_APK), false);
            AppSecurityTests.assertNull((String)"failed to install app access data", (Object)installResult);
            AppSecurityTests.assertTrue((String)"could access app's private data", (boolean)this.runDeviceTests(APP_ACCESS_DATA_PKG));
        }
        finally {
            this.getDevice().uninstallPackage(APP_WITH_DATA_PKG);
            this.getDevice().uninstallPackage(APP_ACCESS_DATA_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstrumentationDiffCert() throws IOException {
        Log.i((String)LOG_TAG, (String)"installing app that attempts to instrument another app");
        try {
            this.getDevice().uninstallPackage(TARGET_INSTRUMENT_PKG);
            this.getDevice().uninstallPackage(INSTRUMENT_DIFF_CERT_PKG);
            String installResult = this.getDevice().installPackage(this.getTestAppFilePath(TARGET_INSTRUMENT_APK), false);
            AppSecurityTests.assertNull((String)"failed to install target instrumentation app", (Object)installResult);
            installResult = this.getDevice().installPackage(this.getTestAppFilePath(INSTRUMENT_DIFF_CERT_APK), false);
            AppSecurityTests.assertNull((String)"failed to install instrumentation app with diff cert", (Object)installResult);
            String runResults = this.runDeviceTestsWithRunResult(INSTRUMENT_DIFF_CERT_PKG);
            AppSecurityTests.assertNotNull((String)"running instrumentation with diff cert unexpectedly succeeded", (Object)runResults);
            String msg = String.format("Unexpected error message result from %s. Received %s", "instrumentation with diff cert. Expected starts with Permission Denial", runResults);
            AppSecurityTests.assertTrue((String)msg, (boolean)runResults.startsWith("Permission Denial"));
        }
        finally {
            this.getDevice().uninstallPackage(TARGET_INSTRUMENT_PKG);
            this.getDevice().uninstallPackage(INSTRUMENT_DIFF_CERT_PKG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPermissionDiffCert() throws IOException {
        Log.i((String)LOG_TAG, (String)"installing app that attempts to use permission of another app");
        try {
            this.getDevice().uninstallPackage(DECLARE_PERMISSION_PKG);
            this.getDevice().uninstallPackage(PERMISSION_DIFF_CERT_PKG);
            String installResult = this.getDevice().installPackage(this.getTestAppFilePath(DECLARE_PERMISSION_APK), false);
            AppSecurityTests.assertNull((String)"failed to install declare permission app", (Object)installResult);
            installResult = this.getDevice().installPackage(this.getTestAppFilePath(PERMISSION_DIFF_CERT_APK), false);
            AppSecurityTests.assertNull((String)"failed to install permission app with diff cert", (Object)installResult);
            AppSecurityTests.assertTrue((String)"unexpected result when running permission tests", (boolean)this.runDeviceTests(PERMISSION_DIFF_CERT_PKG));
        }
        finally {
            this.getDevice().uninstallPackage(DECLARE_PERMISSION_PKG);
            this.getDevice().uninstallPackage(PERMISSION_DIFF_CERT_PKG);
        }
    }

    private String getTestAppFilePath(String fileName) {
        return String.format("%s%s%s", this.getTestAppPath(), File.separator, fileName);
    }

    private boolean runDeviceTests(String pkgName) {
        CollectingTestRunListener listener = this.doRunTests(pkgName);
        return listener.didAllTestsPass();
    }

    private CollectingTestRunListener doRunTests(String pkgName) {
        RemoteAndroidTestRunner testRunner = new RemoteAndroidTestRunner(pkgName, this.getDevice());
        CollectingTestRunListener listener = new CollectingTestRunListener();
        testRunner.run((ITestRunListener)listener);
        return listener;
    }

    private String runDeviceTestsWithRunResult(String pkgName) {
        CollectingTestRunListener listener = this.doRunTests(pkgName);
        return listener.getTestRunErrorMessage();
    }

    public static Test suite() {
        return new DeviceTestSuite(AppSecurityTests.class);
    }

    private static class CollectingTestRunListener
    implements ITestRunListener {
        private boolean mAllTestsPassed = true;
        private String mTestRunErrorMessage = null;

        private CollectingTestRunListener() {
        }

        public void testEnded(TestIdentifier test) {
        }

        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
            Log.w((String)AppSecurityTests.LOG_TAG, (String)String.format("%s#%s failed: %s", test.getClassName(), test.getTestName(), trace));
            this.mAllTestsPassed = false;
        }

        public void testRunEnded(long elapsedTime) {
        }

        public void testRunFailed(String errorMessage) {
            Log.w((String)AppSecurityTests.LOG_TAG, (String)String.format("test run failed: %s", errorMessage));
            this.mAllTestsPassed = false;
            this.mTestRunErrorMessage = errorMessage;
        }

        public void testRunStarted(int testCount) {
        }

        public void testRunStopped(long elapsedTime) {
        }

        public void testStarted(TestIdentifier test) {
        }

        boolean didAllTestsPass() {
            return this.mAllTestsPassed;
        }

        String getTestRunErrorMessage() {
            return this.mTestRunErrorMessage;
        }
    }
}

