/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts;

import com.android.cts.CUIOutputStream;
import com.android.cts.CtsTestResult;
import com.android.cts.HostConfig;
import com.android.cts.HostSideOnlyPackage;
import com.android.cts.HostSideOnlyTest;
import com.android.cts.InvalidTestResultStringException;
import com.android.cts.Log;
import com.android.cts.ReferenceAppTestPackage;
import com.android.cts.SignatureCheckPackage;
import com.android.cts.Test;
import com.android.cts.TestCase;
import com.android.cts.TestController;
import com.android.cts.TestNotFoundException;
import com.android.cts.TestPackage;
import com.android.cts.TestPlanNotFoundException;
import com.android.cts.TestSession;
import com.android.cts.TestSessionLog;
import com.android.cts.TestSuite;
import com.android.cts.XMLResourceHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSessionBuilder
extends XMLResourceHandler {
    private static final String TAG_TEST_SUITE = "TestSuite";
    private static final String TAG_TEST_CASE = "TestCase";
    public static final String TAG_TEST = "Test";
    public static final String ATTRIBUTE_SIGNATURE_CHECK = "signatureCheck";
    public static final String ATTRIBUTE_REFERENCE_APP_TEST = "referenceAppTest";
    public static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_RUNNER = "runner";
    private static final String ATTRIBUTE_JAR_PATH = "jarPath";
    private static final String ATTRIBUTE_APP_NAME_SPACE = "appNameSpace";
    public static final String ATTRIBUTE_APP_PACKAGE_NAME = "appPackageName";
    private static final String ATTRIBUTE_TARGET_NAME_SPACE = "targetNameSpace";
    private static final String ATTRIBUTE_TARGET_BINARY_NAME = "targetBinaryName";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_CONTROLLER = "HostController";
    private static final String ATTRIBUTE_KNOWN_FAILURE = "KnownFailure";
    private static final String ATTRIBUTE_HOST_SIDE_ONLY = "hostSideOnly";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_FRAMEWORK_VERSION = "AndroidFramework";
    private static final String ATTRIBUTE_APK_TO_TEST_NAME = "apkToTestName";
    private static final String ATTRIBUTE_PACKAGE_TO_TEST = "packageToTest";
    private static TestSessionBuilder sInstance;
    private DocumentBuilder mDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

    public static TestSessionBuilder getInstance() throws ParserConfigurationException {
        if (sInstance == null) {
            sInstance = new TestSessionBuilder();
        }
        return sInstance;
    }

    private TestSessionBuilder() throws ParserConfigurationException {
    }

    public TestSession build(TestSessionLog log) {
        if (log == null) {
            return null;
        }
        return new TestSession(log, 1);
    }

    public TestSession build(String config) throws SAXException, IOException, TestPlanNotFoundException, TestNotFoundException, NoSuchAlgorithmException {
        File file = new File(config);
        if (!file.exists()) {
            throw new TestPlanNotFoundException();
        }
        Document doc = this.mDocBuilder.parse(file);
        int numOfRequiredDevices = 1;
        try {
            Node deviceConfigNode = doc.getElementsByTagName("RequiredDevice").item(0);
            numOfRequiredDevices = this.getAttributeValue(deviceConfigNode, "amount");
        }
        catch (Exception e) {
            // empty catch block
        }
        Collection<TestPackage> packages = this.loadPackages(doc);
        if (packages.size() == 0) {
            throw new TestNotFoundException("No valid package in test plan.");
        }
        String planFileName = file.getName();
        int index = planFileName.indexOf(".");
        String planName = index != -1 ? planFileName.substring(0, planFileName.indexOf(".")) : planFileName;
        TestSessionLog sessionLog = new TestSessionLog(packages, planName);
        TestSession ts = new TestSession(sessionLog, numOfRequiredDevices);
        return ts;
    }

    private Collection<TestPackage> loadPackages(Document doc) throws SAXException, IOException, NoSuchAlgorithmException {
        ArrayList<TestPackage> packages = new ArrayList<TestPackage>();
        NodeList packageList = doc.getElementsByTagName("Entry");
        ArrayList<String> removedPkgList = new ArrayList<String>();
        for (int i = 0; i < packageList.getLength(); ++i) {
            String packageBinaryName;
            Node pNode = packageList.item(i);
            String uri = TestSessionBuilder.getStringAttributeValue(pNode, "uri");
            String list = TestSessionBuilder.getStringAttributeValue(pNode, "exclude");
            ArrayList<String> excludedList = null;
            if (list != null && list.length() != 0) {
                excludedList = this.getStrArrayList(list);
            }
            if ((packageBinaryName = HostConfig.getInstance().getPackageBinaryName(uri)) != null) {
                String xmlConfigFilePath = HostConfig.getInstance().getCaseRepository().getXmlPath(packageBinaryName);
                File xmlFile = new File(xmlConfigFilePath);
                TestPackage pkg = this.loadPackage(xmlFile, excludedList);
                if (pkg instanceof SignatureCheckPackage) {
                    packages.add(0, pkg);
                    continue;
                }
                packages.add(pkg);
                continue;
            }
            removedPkgList.add(uri);
        }
        if (removedPkgList.size() != 0) {
            CUIOutputStream.println("The following package(s) doesn't exist:");
            for (String pkgName : removedPkgList) {
                CUIOutputStream.println("    " + pkgName);
            }
        }
        return packages;
    }

    public TestPackage loadPackage(File packageConfigFile, ArrayList<String> excludedList) throws SAXException, IOException, NoSuchAlgorithmException {
        Element pNode = this.mDocBuilder.parse(packageConfigFile).getDocumentElement();
        return this.loadPackage(pNode, excludedList);
    }

    public TestPackage loadPackage(Node pkgNode, ArrayList<String> excludedList) throws NoSuchAlgorithmException {
        NodeList suiteList = pkgNode.getChildNodes();
        String appBinaryName = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_NAME);
        String targetNameSpace = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_TARGET_NAME_SPACE);
        String targetBinaryName = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_TARGET_BINARY_NAME);
        String version = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_VERSION);
        String frameworkVersion = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_FRAMEWORK_VERSION);
        String runner = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_RUNNER);
        String jarPath = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_JAR_PATH);
        String appNameSpace = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_APP_NAME_SPACE);
        String appPackageName = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_APP_PACKAGE_NAME);
        String hostSideOnly = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_HOST_SIDE_ONLY);
        String signature = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_SIGNATURE_CHECK);
        String referenceAppTest = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_REFERENCE_APP_TEST);
        TestPackage pkg = null;
        if ("true".equals(referenceAppTest)) {
            String apkToTestName = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_APK_TO_TEST_NAME);
            String packageUnderTest = TestSessionBuilder.getStringAttributeValue(pkgNode, ATTRIBUTE_PACKAGE_TO_TEST);
            pkg = new ReferenceAppTestPackage(runner, appBinaryName, targetNameSpace, targetBinaryName, version, frameworkVersion, jarPath, appNameSpace, appPackageName, apkToTestName, packageUnderTest);
        } else {
            pkg = "true".equals(signature) ? new SignatureCheckPackage(runner, appBinaryName, targetNameSpace, targetBinaryName, version, frameworkVersion, jarPath, appNameSpace, appPackageName) : ("true".equals(hostSideOnly) ? new HostSideOnlyPackage(appBinaryName, version, frameworkVersion, jarPath, appPackageName) : new TestPackage(runner, appBinaryName, targetNameSpace, targetBinaryName, version, frameworkVersion, jarPath, appNameSpace, appPackageName));
        }
        for (int i = 0; i < suiteList.getLength(); ++i) {
            Node sNode = suiteList.item(i);
            if (sNode.getNodeType() != 1 || !TAG_TEST_SUITE.equals(sNode.getNodeName())) continue;
            String fullSuiteName = this.getFullSuiteName(sNode);
            if (!this.checkFullMatch(excludedList, fullSuiteName)) {
                ArrayList<String> excludedCaseList = this.getExcludedList(excludedList, fullSuiteName);
                TestSuite suite = this.loadSuite(pkg, sNode, excludedCaseList);
                if (suite.getTestCases().size() == 0 && suite.getSubSuites().size() == 0) continue;
                pkg.addTestSuite(suite);
                continue;
            }
            Log.d("suite=" + fullSuiteName + " is fully excluded");
        }
        return pkg;
    }

    private ArrayList<String> getStrArrayList(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String[] list = str.split(";");
        if (list == null || list.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(s);
        }
        return result;
    }

    private ArrayList<String> getExcludedList(ArrayList<String> excludedList, String expectation) {
        if (excludedList == null || excludedList.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String str : excludedList) {
            if (!str.startsWith(expectation)) continue;
            list.add(str);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    private boolean checkFullMatch(ArrayList<String> list, String expectation) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (String str : list) {
            if (!str.equals(expectation)) continue;
            return true;
        }
        return false;
    }

    private TestSuite loadSuite(TestPackage pkg, Node sNode, ArrayList<String> excludedCaseList) {
        NodeList cNodes = sNode.getChildNodes();
        String fullSuiteName = this.getFullSuiteName(sNode);
        String suiteName = TestSessionBuilder.getStringAttributeValue(sNode, ATTRIBUTE_NAME);
        TestSuite suite = new TestSuite(pkg, suiteName, fullSuiteName);
        for (int i = 0; i < cNodes.getLength(); ++i) {
            Node cNode = cNodes.item(i);
            if (cNode.getNodeType() != 1) continue;
            if (cNode.getNodeName().equals(TAG_TEST_SUITE)) {
                String subSuiteName = this.getFullSuiteName(cNode);
                if (!this.checkFullMatch(excludedCaseList, subSuiteName)) {
                    ArrayList<String> excludedList = this.getExcludedList(excludedCaseList, subSuiteName);
                    TestSuite subSuite = this.loadSuite(pkg, cNode, excludedList);
                    if (subSuite.getTestCases().size() == 0 && subSuite.getSubSuites().size() == 0) continue;
                    suite.addSubSuite(subSuite);
                    continue;
                }
                Log.d("suite=" + subSuiteName + " is fully excluded");
                continue;
            }
            if (!cNode.getNodeName().equals(TAG_TEST_CASE)) continue;
            String cName = TestSessionBuilder.getStringAttributeValue(cNode, ATTRIBUTE_NAME);
            String priority = TestSessionBuilder.getStringAttributeValue(cNode, ATTRIBUTE_PRIORITY);
            TestCase testCase = new TestCase(suite, cName, priority);
            String fullCaseName = fullSuiteName + "." + testCase.getName();
            if (!this.checkFullMatch(excludedCaseList, fullCaseName)) {
                NodeList mNodes = cNode.getChildNodes();
                for (int t = 0; t < mNodes.getLength(); ++t) {
                    Node testNode = mNodes.item(t);
                    if (testNode.getNodeType() != 1 || !testNode.getNodeName().equals(TAG_TEST)) continue;
                    Test test = this.loadTest(pkg, testCase, testNode);
                    if (!this.checkFullMatch(excludedCaseList, test.getFullName())) {
                        testCase.addTest(test);
                        continue;
                    }
                    Log.d("Test=" + test.getFullName() + " is excluded");
                }
                if (testCase.getTests().size() == 0) continue;
                suite.addTestCase(testCase);
                continue;
            }
            Log.d("case=" + fullCaseName + " is fully excluded");
        }
        return suite;
    }

    private Test loadTest(TestPackage pkg, TestCase testCase, Node testNode) {
        String cType = TestSessionBuilder.getStringAttributeValue(testNode, ATTRIBUTE_TYPE);
        String name = TestSessionBuilder.getStringAttributeValue(testNode, ATTRIBUTE_NAME);
        String description = TestSessionBuilder.getStringAttributeValue(testNode, ATTRIBUTE_CONTROLLER);
        String knownFailure = TestSessionBuilder.getStringAttributeValue(testNode, ATTRIBUTE_KNOWN_FAILURE);
        String fullJarPath = HostConfig.getInstance().getCaseRepository().getRoot() + File.separator + pkg.getJarPath();
        CtsTestResult testResult = this.loadTestResult(testNode);
        Test test = null;
        if (pkg.isHostSideOnly()) {
            test = new HostSideOnlyTest(testCase, name, cType, knownFailure, 0);
            description = test.getFullName();
        } else {
            test = new Test(testCase, name, cType, knownFailure, 0);
        }
        TestController controller = this.genTestControler(fullJarPath, description);
        test.setTestController(controller);
        if (testResult != null) {
            test.addResult(testResult);
        }
        return test;
    }

    private CtsTestResult loadTestResult(Node testNode) {
        String result = TestSessionBuilder.getStringAttributeValue(testNode, "result");
        String failedMessage = null;
        String stackTrace = null;
        NodeList nodes = testNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node rNode = nodes.item(i);
            if (rNode.getNodeType() != 1 || !rNode.getNodeName().equals("FailedScene")) continue;
            failedMessage = TestSessionBuilder.getStringAttributeValue(rNode, "message");
            stackTrace = TestSessionBuilder.getStringAttributeValue(rNode, "StackTrace");
            if (stackTrace != null) break;
            NodeList sNodeList = rNode.getChildNodes();
            for (int j = 0; j < sNodeList.getLength(); ++j) {
                Node sNode = sNodeList.item(i);
                if (sNode.getNodeType() != 1 || !sNode.getNodeName().equals("StackTrace")) continue;
                stackTrace = sNode.getTextContent();
            }
            break;
        }
        CtsTestResult testResult = null;
        if (result != null) {
            try {
                testResult = new CtsTestResult(result, failedMessage, stackTrace);
            }
            catch (InvalidTestResultStringException e) {
                // empty catch block
            }
        }
        return testResult;
    }

    public TestController genTestControler(String jarPath, String description) {
        if (jarPath == null || jarPath.length() == 0 || description == null || description.length() == 0) {
            return null;
        }
        String packageName = description.substring(0, description.lastIndexOf("."));
        String className = description.substring(packageName.length() + 1, description.lastIndexOf("#"));
        String methodName = description.substring(description.lastIndexOf("#") + 1, description.length());
        return new TestController(jarPath, packageName, className, methodName);
    }

    private String getFullSuiteName(Node node) {
        StringBuilder buf = new StringBuilder();
        buf.append(TestSessionBuilder.getStringAttributeValue(node, ATTRIBUTE_NAME));
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (parent.getNodeType() != 1 || parent.getNodeName() != TAG_TEST_SUITE) continue;
            buf.insert(0, ".");
            buf.insert(0, TestSessionBuilder.getStringAttributeValue(parent, ATTRIBUTE_NAME));
        }
        return buf.toString();
    }

    public void serialize(String planName, ArrayList<String> packageNames, HashMap<String, ArrayList<String>> selectedResult) throws ParserConfigurationException, FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        File plan = new File(HostConfig.getInstance().getPlanRepository().getPlanPath(planName));
        if (plan.exists()) {
            Log.e("Plan " + planName + " already exist, please use another name!", null);
            return;
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("TestPlan");
        this.setAttribute(doc, (Node)root, ATTRIBUTE_VERSION, "1.0");
        doc.appendChild(root);
        Element deviceConfigNode = doc.createElement("PlanSettings");
        root.appendChild(deviceConfigNode);
        for (String pName : packageNames) {
            if (!selectedResult.containsKey(pName)) continue;
            Element entryNode = doc.createElement("Entry");
            this.setAttribute(doc, (Node)entryNode, "uri", pName);
            ArrayList<String> excluded = selectedResult.get(pName);
            if (excluded != null && excluded.size() != 0) {
                String excludedList = "";
                for (String str : excluded) {
                    excludedList = excludedList + str + ";";
                }
                this.setAttribute(doc, (Node)entryNode, "exclude", excludedList);
            }
            root.appendChild(entryNode);
        }
        TestSessionBuilder.writeToFile(plan, doc);
    }
}

