/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.util.OptionHelper;
import com.android.tradefed.config.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class OptionHelperTest
extends TestCase {
    private static final String TEST_CLASS = "test-class";
    private static final String TEST_CLASS_SHORTNAME = "c";
    private static final String TEST_FILTER = "test-filter";
    private static final String TEST_LOGPATH = "test-logpath";
    private static final String TEST_NAME = "test-name";
    private static final String TEST_SUITE = "test-suite";
    private static final String TEST_SUITE_SHORTNAME = "s";
    @Option(name="test-class", shortName=99, importance=Option.Importance.ALWAYS)
    private String mTestClass = null;
    @Option(name="test-name", importance=Option.Importance.ALWAYS)
    private String mTestName = null;
    @Option(name="test-suite", shortName=115, importance=Option.Importance.ALWAYS)
    private String mTestSuite = null;
    @Option(name="test-filter", importance=Option.Importance.ALWAYS)
    private List<String> mFilters = new ArrayList<String>();
    @Option(name="test-logpath", importance=Option.Importance.ALWAYS)
    private String mLogPath = null;

    public void testGetOptionNames() throws Exception {
        Set optionNames = OptionHelper.getOptionNames((Object)((Object)this));
        List<String> expectedNames = Arrays.asList(TEST_CLASS, TEST_NAME, TEST_SUITE, TEST_LOGPATH);
        OptionHelperTest.assertEquals((String)"Missing option names", (boolean)true, (boolean)optionNames.containsAll(expectedNames));
        OptionHelperTest.assertEquals((String)"Expected five elements", (int)5, (int)optionNames.size());
    }

    public void testGetOptionShortNames() throws Exception {
        Set optionShortNames = OptionHelper.getOptionShortNames((Object)((Object)this));
        List<String> expectedShortNames = Arrays.asList(TEST_CLASS_SHORTNAME, TEST_SUITE_SHORTNAME);
        OptionHelperTest.assertEquals((String)"Missing option shortnames", (boolean)true, (boolean)optionShortNames.containsAll(expectedShortNames));
        OptionHelperTest.assertEquals((String)"Expected two elements", (int)2, (int)optionShortNames.size());
    }

    public void testGetValidCliArgs() throws Exception {
        String fakeTestClass = "FooTestCases";
        String fakeTestMethod = "android.foo.footestsuite.RealTest#testSuperReal";
        ArrayList noValidNames = new ArrayList();
        List<String> validSubset = Arrays.asList("--test-class", "fooclass", "-s", "foosuite");
        List<String> allValidNames = Arrays.asList("--test-class", "fooclass", "-s", "foosuite:foo-key=fooval", "--test-name", "footest", "--test-logpath", "path/to/log-directory/");
        List<String> validQuoteSubset = Arrays.asList("-c", fakeTestClass, "--test-name", fakeTestMethod, "--test-filter", fakeTestClass + " " + fakeTestMethod);
        CharSequence[] inputArray = new String[]{"foocts ", "-", TEST_CLASS_SHORTNAME, " ", fakeTestClass, " \"--", TEST_NAME, "=", fakeTestMethod, "\" -z \"FAKE1 FAKE2\" --", TEST_FILTER, " \"", fakeTestClass, " ", fakeTestMethod + "\""};
        String inputString = String.join((CharSequence)"", inputArray);
        OptionHelperTest.assertEquals((String)"Expected no valid names", noValidNames, (Object)OptionHelper.getValidCliArgs((String)"test --foo -b", (Object)((Object)this)));
        OptionHelperTest.assertEquals((String)"Expected one long name and one short name", validSubset, (Object)OptionHelper.getValidCliArgs((String)"test --test-class fooclass -b fake -s foosuite", (Object)((Object)this)));
        OptionHelperTest.assertEquals((String)"Expected two long names and one short name", allValidNames, (Object)OptionHelper.getValidCliArgs((String)"test --test-class fooclass -b fake -s foosuite:foo-key=fooval --test-name footest --test-logpath path/to/log-directory/", (Object)((Object)this)));
        OptionHelperTest.assertEquals((String)"Expected matching arrays", validQuoteSubset, (Object)OptionHelper.getValidCliArgs((String)inputString, (Object)((Object)this)));
    }

    public void testGetValidCliArgs_surroundingQuotes() throws Exception {
        List<String> expectedTokens = Arrays.asList("--test-filter", "a b c");
        CharSequence[] inputArray = new String[]{"\"--", TEST_FILTER, "=a b c\""};
        String inputString = String.join((CharSequence)"", inputArray);
        OptionHelperTest.assertEquals((String)"Expected matching arrays", expectedTokens, (Object)OptionHelper.getValidCliArgs((String)inputString, (Object)((Object)this)));
    }
}

