/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.testtype.SubPlan;
import com.android.compatibility.common.util.TestFilter;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class SubPlanTest
extends TestCase {
    private static final String ABI = "armeabi-v7a";
    private static final String MODULE_A = "ModuleA";
    private static final String MODULE_B = "ModuleB";
    private static final String TEST_1 = "android.test.Foo#test1";
    private static final String TEST_2 = "android.test.Foo#test2";
    private static final String TEST_3 = "android.test.Foo#test3";
    private static final String XML_BASE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SubPlan version=\"2.0\">\n%s\n</SubPlan>";
    private static final String XML_ENTRY = "  <Entry %s/>\n";
    private static final String XML_ATTR = "%s=\"%s\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerialization() throws Exception {
        SubPlan subPlan = new SubPlan();
        subPlan.addIncludeFilter(new TestFilter(ABI, MODULE_A, TEST_1).toString());
        HashSet<String> includeFilterSet = new HashSet<String>();
        includeFilterSet.add(new TestFilter(ABI, MODULE_A, TEST_2).toString());
        includeFilterSet.add(new TestFilter(ABI, MODULE_A, TEST_3).toString());
        subPlan.addAllIncludeFilters(includeFilterSet);
        subPlan.addIncludeFilter(new TestFilter(null, MODULE_B, null).toString());
        subPlan.addExcludeFilter(new TestFilter(null, MODULE_B, TEST_1).toString());
        HashSet<String> excludeFilterSet = new HashSet<String>();
        excludeFilterSet.add(new TestFilter(null, MODULE_B, TEST_2).toString());
        excludeFilterSet.add(new TestFilter(null, MODULE_B, TEST_3).toString());
        subPlan.addAllExcludeFilters(excludeFilterSet);
        File subPlanFile = FileUtil.createTempFile((String)"test-subPlan-serialization", (String)".txt");
        try {
            FileOutputStream subPlanOutputStream = new FileOutputStream(subPlanFile);
            subPlan.serialize((OutputStream)subPlanOutputStream);
            ((OutputStream)subPlanOutputStream).close();
            this.checkSubPlan(subPlanFile);
        }
        finally {
            FileUtil.deleteFile((File)subPlanFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParsing() throws Exception {
        File planFile = FileUtil.createTempFile((String)"test-plan-parsing", (String)".txt");
        FileWriter writer = new FileWriter(planFile);
        try {
            HashSet<String> entries = new HashSet<String>();
            entries.add(this.generateEntryXml(ABI, MODULE_A, TEST_1, true));
            entries.add(this.generateEntryXml(ABI, MODULE_A, TEST_2, true));
            entries.add(this.generateEntryXml(null, null, new TestFilter(ABI, MODULE_A, TEST_3).toString(), true));
            entries.add(this.generateEntryXml(null, MODULE_B, null, true));
            entries.add(this.generateEntryXml(null, null, new TestFilter(null, MODULE_B, TEST_1).toString(), false));
            entries.add(this.generateEntryXml(null, null, new TestFilter(null, MODULE_B, TEST_2).toString(), false));
            entries.add(this.generateEntryXml(null, null, new TestFilter(null, MODULE_B, TEST_3).toString(), false));
            String xml = String.format(XML_BASE, String.join((CharSequence)"\n", entries));
            writer.write(xml);
            writer.flush();
            this.checkSubPlan(planFile);
        }
        finally {
            writer.close();
            FileUtil.deleteFile((File)planFile);
        }
    }

    private void checkSubPlan(File subPlanFile) throws Exception {
        FileInputStream subPlanInputStream = new FileInputStream(subPlanFile);
        SubPlan subPlan = new SubPlan();
        subPlan.parse((InputStream)subPlanInputStream);
        Set subPlanIncludes = subPlan.getIncludeFilters();
        Set subPlanExcludes = subPlan.getExcludeFilters();
        SubPlanTest.assertEquals((String)"Expected 4 includes", (int)4, (int)subPlanIncludes.size());
        SubPlanTest.assertTrue((String)"Missing expected test include", (boolean)subPlanIncludes.contains(new TestFilter(ABI, MODULE_A, TEST_1).toString()));
        SubPlanTest.assertTrue((String)"Missing expected test include", (boolean)subPlanIncludes.contains(new TestFilter(ABI, MODULE_A, TEST_2).toString()));
        SubPlanTest.assertTrue((String)"Missing expected test include", (boolean)subPlanIncludes.contains(new TestFilter(ABI, MODULE_A, TEST_3).toString()));
        SubPlanTest.assertTrue((String)"Missing expected module include", (boolean)subPlanIncludes.contains(new TestFilter(null, MODULE_B, null).toString()));
        SubPlanTest.assertEquals((String)"Expected 3 excludes", (int)3, (int)subPlanExcludes.size());
        SubPlanTest.assertTrue((String)"Missing expected exclude", (boolean)subPlanExcludes.contains(new TestFilter(null, MODULE_B, TEST_1).toString()));
        SubPlanTest.assertTrue((String)"Missing expected exclude", (boolean)subPlanExcludes.contains(new TestFilter(null, MODULE_B, TEST_2).toString()));
        SubPlanTest.assertTrue((String)"Missing expected exclude", (boolean)subPlanExcludes.contains(new TestFilter(null, MODULE_B, TEST_3).toString()));
    }

    private String generateEntryXml(String abi, String name, String filter, boolean include) {
        String filterType = include ? "include" : "exclude";
        HashSet<String> attributes = new HashSet<String>();
        if (filter != null) {
            attributes.add(String.format(XML_ATTR, filterType, filter));
        }
        if (name != null) {
            attributes.add(String.format(XML_ATTR, "name", name));
        }
        if (abi != null) {
            attributes.add(String.format(XML_ATTR, "abi", abi));
        }
        return String.format(XML_ENTRY, String.join((CharSequence)" ", attributes));
    }
}

