/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import com.android.compatibility.common.tradefed.testtype.ModuleDef;
import com.android.compatibility.common.tradefed.testtype.ModuleRepo;
import com.android.compatibility.common.tradefed.testtype.TestStub;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class ModuleRepoTest
extends TestCase {
    private static final String TOKEN = "<target_preparer class=\"com.android.compatibility.common.tradefed.targetprep.TokenRequirement\">\n<option name=\"token\" value=\"%s\" />\n</target_preparer>\n";
    private static final String CONFIG = "<configuration description=\"Auto Generated File\">\n%s<test class=\"com.android.compatibility.common.tradefed.testtype.%s\">\n<option name=\"module\" value=\"%s\" /></test>\n</configuration>";
    private static final String FOOBAR_TOKEN = "foobar";
    private static final String SERIAL1 = "abc";
    private static final String SERIAL2 = "def";
    private static final String SERIAL3 = "ghi";
    private static final Set<String> SERIALS = new HashSet<String>();
    private static final Set<IAbi> ABIS = new LinkedHashSet<IAbi>();
    private static final List<String> DEVICE_TOKENS = new ArrayList<String>();
    private static final List<String> TEST_ARGS = new ArrayList<String>();
    private static final List<String> MODULE_ARGS = new ArrayList<String>();
    private static final Set<String> INCLUDES = new HashSet<String>();
    private static final Set<String> EXCLUDES = new HashSet<String>();
    private static final MultiMap<String, String> METADATA_INCLUDES = new MultiMap();
    private static final MultiMap<String, String> METADATA_EXCLUDES = new MultiMap();
    private static final Set<String> FILES = new HashSet<String>();
    private static final String FILENAME = "%s.config";
    private static final String ROOT_DIR_ATTR = "ROOT_DIR";
    private static final String SUITE_NAME_ATTR = "SUITE_NAME";
    private static final String START_TIME_MS_ATTR = "START_TIME_MS";
    private static final String ABI_32 = "armeabi-v7a";
    private static final String ABI_64 = "arm64-v8a";
    private static final String MODULE_NAME_A = "FooModuleA";
    private static final String MODULE_NAME_B = "FooModuleB";
    private static final String MODULE_NAME_C = "FooModuleC";
    private static final String NON_EXISTS_MODULE_NAME = "NonExistModule";
    private static final String ID_A_32 = AbiUtils.createId((String)"armeabi-v7a", (String)"FooModuleA");
    private static final String ID_A_64 = AbiUtils.createId((String)"arm64-v8a", (String)"FooModuleA");
    private static final String ID_B_32 = AbiUtils.createId((String)"armeabi-v7a", (String)"FooModuleB");
    private static final String ID_B_64 = AbiUtils.createId((String)"arm64-v8a", (String)"FooModuleB");
    private static final String ID_C_32 = AbiUtils.createId((String)"armeabi-v7a", (String)"FooModuleC");
    private static final String ID_C_64 = AbiUtils.createId((String)"arm64-v8a", (String)"FooModuleC");
    private static final String TEST_ARG = TestStub.class.getName() + ":foo:bar";
    private static final String MODULE_ARG = "%s:blah:foobar";
    private static final String TEST_STUB = "TestStub";
    private static final String SHARDABLE_TEST_STUB = "ShardableTestStub";
    private static final String[] EXPECTED_MODULE_IDS = new String[]{"arm64-v8a FooModuleB", "arm64-v8a FooModuleC", "armeabi-v7a FooModuleA", "arm64-v8a FooModuleA", "armeabi-v7a FooModuleC", "armeabi-v7a FooModuleB"};
    private ModuleRepo mRepo;
    private File mTestsDir;
    private File mRootDir;
    private IBuildInfo mMockBuildInfo;

    public void setUp() throws Exception {
        this.mTestsDir = this.setUpConfigs();
        this.mRepo = new ModuleRepo();
        this.mMockBuildInfo = (IBuildInfo)EasyMock.createMock(IBuildInfo.class);
        this.mRootDir = FileUtil.createTempDir((String)"root");
        File subRootDir = new File(this.mRootDir, String.format("android-suite", new Object[0]));
        File resultsDir = new File(subRootDir, "results");
        File resultDir = new File(resultsDir, CompatibilityBuildHelper.getDirSuffix((long)0L));
        resultDir.mkdirs();
        HashMap<String, String> mockBuildInfoMap = new HashMap<String, String>();
        mockBuildInfoMap.put(ROOT_DIR_ATTR, this.mRootDir.getAbsolutePath());
        mockBuildInfoMap.put(SUITE_NAME_ATTR, "suite");
        mockBuildInfoMap.put(START_TIME_MS_ATTR, Long.toString(0L));
        EasyMock.expect((Object)this.mMockBuildInfo.getBuildAttributes()).andReturn(mockBuildInfoMap).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mMockBuildInfo});
    }

    private File setUpConfigs() throws IOException {
        File testsDir = FileUtil.createTempDir((String)"testcases");
        this.createConfig(testsDir, MODULE_NAME_A, null);
        this.createConfig(testsDir, MODULE_NAME_B, null);
        this.createConfig(testsDir, MODULE_NAME_C, FOOBAR_TOKEN);
        return testsDir;
    }

    private void createConfig(File testsDir, String name, String token) throws IOException {
        this.createConfig(testsDir, name, token, TEST_STUB);
    }

    private void createConfig(File testsDir, String name, String token, String moduleClass) throws IOException {
        File config = new File(testsDir, String.format(FILENAME, name));
        if (!config.createNewFile()) {
            throw new IOException(String.format("Failed to create '%s'", config.getAbsolutePath()));
        }
        String preparer = "";
        if (token != null) {
            preparer = String.format(TOKEN, token);
        }
        FileUtil.writeToFile((String)String.format(CONFIG, preparer, moduleClass, name), (File)config);
    }

    public void tearDown() throws Exception {
        FileUtil.recursiveDelete((File)this.mTestsDir);
        this.tearDownConfigs(this.mTestsDir);
        this.tearDownConfigs(this.mRootDir);
    }

    private void tearDownConfigs(File testsDir) {
        FileUtil.recursiveDelete((File)testsDir);
    }

    public void testInitialization() throws Exception {
        this.mRepo.initialize(3, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, INCLUDES, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        ModuleRepoTest.assertEquals((String)"Wrong number of shards", (int)3, (int)this.mRepo.getNumberOfShards());
        Map deviceTokens = this.mRepo.getDeviceTokens();
        ModuleRepoTest.assertEquals((String)"Wrong number of devices with tokens", (int)1, (int)deviceTokens.size());
        Set tokens = (Set)deviceTokens.get(SERIAL3);
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)1, (int)tokens.size());
        ModuleRepoTest.assertTrue((String)"Unexpected device token", (boolean)tokens.contains(FOOBAR_TOKEN));
        ModuleRepoTest.assertEquals((String)"Wrong number of modules", (int)4, (int)this.mRepo.getNonTokenModules().size());
        List tokenModules = this.mRepo.getTokenModules();
        ModuleRepoTest.assertEquals((String)"Wrong number of modules with tokens", (int)2, (int)tokenModules.size());
    }

    public void testGetModules() throws Exception {
        this.mRepo.initialize(1, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, INCLUDES, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)2, (int)this.mRepo.getTokenModules().size());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)4, (int)this.mRepo.getNonTokenModules().size());
    }

    public void testGetModulesSharded() throws Exception {
        this.mRepo.initialize(2, null, this.mTestsDir, ABIS, new ArrayList(), TEST_ARGS, MODULE_ARGS, INCLUDES, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)2, (int)this.mRepo.getTokenModules().size());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)4, (int)this.mRepo.getNonTokenModules().size());
        LinkedList shard1 = this.mRepo.getModules(SERIAL1, 0);
        ModuleRepoTest.assertEquals((int)2, (int)shard1.size());
        ModuleRepoTest.assertEquals((String)"armeabi-v7a FooModuleA", (String)((IModuleDef)shard1.get(0)).getId());
        ModuleRepoTest.assertEquals((String)"arm64-v8a FooModuleA", (String)((IModuleDef)shard1.get(1)).getId());
        LinkedList shard2 = this.mRepo.getModules(SERIAL2, 1);
        ModuleRepoTest.assertEquals((int)4, (int)shard2.size());
        ModuleRepoTest.assertEquals((String)"armeabi-v7a FooModuleB", (String)((IModuleDef)shard2.get(0)).getId());
        ModuleRepoTest.assertEquals((String)"arm64-v8a FooModuleB", (String)((IModuleDef)shard2.get(1)).getId());
    }

    public void testGetModules_onlyTokenModules() throws Exception {
        HashSet<String> includes = new HashSet<String>();
        includes.add(MODULE_NAME_C);
        this.mRepo.initialize(1, null, this.mTestsDir, ABIS, new ArrayList(), TEST_ARGS, MODULE_ARGS, includes, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)2, (int)this.mRepo.getTokenModules().size());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)0, (int)this.mRepo.getNonTokenModules().size());
        LinkedList modules = this.mRepo.getModules(SERIAL1, 0);
        ModuleRepoTest.assertNotNull((Object)modules);
        ModuleRepoTest.assertEquals((int)2, (int)modules.size());
    }

    public void testGetModules_TokenModules_multiDevices() throws Exception {
        this.createConfig(this.mTestsDir, "FooModuleD", "foobar2");
        HashSet<String> includes = new HashSet<String>();
        includes.add(MODULE_NAME_C);
        includes.add("FooModuleD");
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(String.format("%s:%s", SERIAL1, FOOBAR_TOKEN));
        tokens.add(String.format("%s:%s", SERIAL2, "foobar2"));
        this.mRepo.initialize(2, null, this.mTestsDir, ABIS, tokens, TEST_ARGS, MODULE_ARGS, includes, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)4, (int)this.mRepo.getTokenModules().size());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)0, (int)this.mRepo.getNonTokenModules().size());
        LinkedList modules1 = this.mRepo.getModules(SERIAL1, 0);
        ModuleRepoTest.assertNotNull((Object)modules1);
        ModuleRepoTest.assertEquals((int)2, (int)modules1.size());
        ModuleRepoTest.assertTrue((boolean)((IModuleDef)modules1.get(0)).getId().contains(MODULE_NAME_C));
        ModuleRepoTest.assertTrue((boolean)((IModuleDef)modules1.get(1)).getId().contains(MODULE_NAME_C));
        LinkedList modules2 = this.mRepo.getModules(SERIAL2, 1);
        ModuleRepoTest.assertNotNull((Object)modules2);
        ModuleRepoTest.assertEquals((int)2, (int)modules2.size());
        ModuleRepoTest.assertTrue((boolean)((IModuleDef)modules2.get(0)).getId().contains("FooModuleD"));
        ModuleRepoTest.assertTrue((boolean)((IModuleDef)modules2.get(1)).getId().contains("FooModuleD"));
    }

    public void testGetModulesSharded_uneven() throws Exception {
        this.createConfig(this.mTestsDir, "FooModuleD", null);
        this.mRepo.initialize(4, null, this.mTestsDir, ABIS, new ArrayList(), TEST_ARGS, MODULE_ARGS, INCLUDES, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)2, (int)this.mRepo.getTokenModules().size());
        ModuleRepoTest.assertEquals((String)"Wrong number of tokens", (int)6, (int)this.mRepo.getNonTokenModules().size());
        LinkedList shard1 = this.mRepo.getModules(SERIAL1, 0);
        ModuleRepoTest.assertEquals((int)1, (int)shard1.size());
        ModuleRepoTest.assertEquals((String)"armeabi-v7a FooModuleA", (String)((IModuleDef)shard1.get(0)).getId());
        LinkedList shard2 = this.mRepo.getModules(SERIAL2, 1);
        ModuleRepoTest.assertEquals((int)1, (int)shard2.size());
        ModuleRepoTest.assertEquals((String)"arm64-v8a FooModuleA", (String)((IModuleDef)shard2.get(0)).getId());
        LinkedList shard3 = this.mRepo.getModules(SERIAL3, 2);
        ModuleRepoTest.assertEquals((int)2, (int)shard3.size());
        ModuleRepoTest.assertEquals((String)"armeabi-v7a FooModuleB", (String)((IModuleDef)shard3.get(0)).getId());
        ModuleRepoTest.assertEquals((String)"arm64-v8a FooModuleB", (String)((IModuleDef)shard3.get(1)).getId());
        LinkedList shard4 = this.mRepo.getModules(SERIAL2, 3);
        ModuleRepoTest.assertEquals((int)4, (int)shard4.size());
        ModuleRepoTest.assertEquals((String)"armeabi-v7a FooModuleC", (String)((IModuleDef)shard4.get(0)).getId());
        ModuleRepoTest.assertEquals((String)"arm64-v8a FooModuleC", (String)((IModuleDef)shard4.get(1)).getId());
        ModuleRepoTest.assertEquals((String)"armeabi-v7a FooModuleD", (String)((IModuleDef)shard4.get(2)).getId());
        ModuleRepoTest.assertEquals((String)"arm64-v8a FooModuleD", (String)((IModuleDef)shard4.get(3)).getId());
    }

    public void testConfigFilter() throws Exception {
        File[] configFiles = this.mTestsDir.listFiles((FilenameFilter)new ModuleRepo.ConfigFilter());
        ModuleRepoTest.assertEquals((String)"Wrong number of config files found.", (int)3, (int)configFiles.length);
        for (File file : configFiles) {
            ModuleRepoTest.assertTrue((String)String.format("Unrecognised file: %s", file.getAbsolutePath()), (boolean)FILES.contains(file.getName()));
        }
    }

    public void testFiltering() throws Exception {
        HashSet<String> includeFilters = new HashSet<String>();
        includeFilters.add(MODULE_NAME_A);
        HashSet<String> excludeFilters = new HashSet<String>();
        excludeFilters.add(ID_A_32);
        excludeFilters.add(MODULE_NAME_B);
        this.mRepo.initialize(1, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, includeFilters, excludeFilters, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        LinkedList modules = this.mRepo.getModules(SERIAL1, 0);
        ModuleRepoTest.assertEquals((String)"Incorrect number of modules", (int)1, (int)modules.size());
        IModuleDef module = (IModuleDef)modules.get(0);
        ModuleRepoTest.assertEquals((String)"Incorrect ID", (String)ID_A_64, (String)module.getId());
        this.checkArgs(module);
    }

    public void testInitialization_ExcludeModule_SkipLoadingConfig() throws Exception {
        HashSet<String> excludeFilters = new HashSet<String>();
        excludeFilters.add(NON_EXISTS_MODULE_NAME);
        this.mRepo.initialize(1, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, Collections.emptySet(), excludeFilters, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
    }

    public void testFiltering_empty() throws Exception {
        HashSet includeFilters = new HashSet();
        HashSet<String> excludeFilters = new HashSet<String>();
        excludeFilters.add(MODULE_NAME_A);
        excludeFilters.add(MODULE_NAME_B);
        excludeFilters.add(MODULE_NAME_C);
        this.mRepo.initialize(1, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, includeFilters, excludeFilters, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        LinkedList modules = this.mRepo.getModules(SERIAL1, 0);
        ModuleRepoTest.assertEquals((String)"Incorrect number of modules", (int)0, (int)modules.size());
    }

    public void testParsing() throws Exception {
        this.mRepo.initialize(1, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, INCLUDES, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        LinkedList modules = this.mRepo.getModules(SERIAL3, 0);
        HashSet<String> idSet = new HashSet<String>();
        for (IModuleDef module : modules) {
            idSet.add(module.getId());
        }
        ModuleRepoTest.assertEquals((String)"Incorrect number of IDs", (int)6, (int)idSet.size());
        ModuleRepoTest.assertTrue((String)"Missing ID_A_32", (boolean)idSet.contains(ID_A_32));
        ModuleRepoTest.assertTrue((String)"Missing ID_A_64", (boolean)idSet.contains(ID_A_64));
        ModuleRepoTest.assertTrue((String)"Missing ID_B_32", (boolean)idSet.contains(ID_B_32));
        ModuleRepoTest.assertTrue((String)"Missing ID_B_64", (boolean)idSet.contains(ID_B_64));
        ModuleRepoTest.assertTrue((String)"Missing ID_C_32", (boolean)idSet.contains(ID_C_32));
        ModuleRepoTest.assertTrue((String)"Missing ID_C_64", (boolean)idSet.contains(ID_C_64));
        for (IModuleDef module : modules) {
            this.checkArgs(module);
        }
    }

    private void checkArgs(IModuleDef module) {
        IRemoteTest test = module.getTest();
        ModuleRepoTest.assertTrue((String)"Incorrect test type", (boolean)(test instanceof TestStub));
        TestStub stub = (TestStub)test;
        ModuleRepoTest.assertEquals((String)"Incorrect test arg", (String)"bar", (String)stub.mFoo);
        ModuleRepoTest.assertEquals((String)"Incorrect module arg", (String)FOOBAR_TOKEN, (String)stub.mBlah);
    }

    public void testGetModuleIds() {
        this.mRepo.initialize(3, null, this.mTestsDir, ABIS, DEVICE_TOKENS, TEST_ARGS, MODULE_ARGS, INCLUDES, EXCLUDES, METADATA_INCLUDES, METADATA_EXCLUDES, this.mMockBuildInfo);
        ModuleRepoTest.assertTrue((String)"Should be initialized", (boolean)this.mRepo.isInitialized());
        this.assertArrayEquals(EXPECTED_MODULE_IDS, this.mRepo.getModuleIds());
    }

    private void assertArrayEquals(Object[] expected, Object[] actual) {
        ModuleRepoTest.assertEquals(Arrays.asList(expected), Arrays.asList(actual));
    }

    public void testGetshard_allSameRuntime() throws Exception {
        ArrayList<ModuleDef> testList = new ArrayList<ModuleDef>();
        TestRuntime test1 = new TestRuntime();
        test1.runtimeHint = 100L;
        ModuleDef mod1 = new ModuleDef("test1", (IAbi)new Abi("arm", "32"), (IRemoteTest)test1, new ArrayList(), new ConfigurationDescriptor());
        testList.add(mod1);
        TestRuntime test2 = new TestRuntime();
        test2.runtimeHint = 100L;
        ModuleDef mod2 = new ModuleDef("test2", (IAbi)new Abi("arm", "32"), (IRemoteTest)test2, new ArrayList(), new ConfigurationDescriptor());
        testList.add(mod2);
        TestRuntime test3 = new TestRuntime();
        test3.runtimeHint = 100L;
        ModuleDef mod3 = new ModuleDef("test3", (IAbi)new Abi("arm", "32"), (IRemoteTest)test3, new ArrayList(), new ConfigurationDescriptor());
        testList.add(mod3);
        TestRuntime test4 = new TestRuntime();
        test4.runtimeHint = 100L;
        ModuleDef mod4 = new ModuleDef("test4", (IAbi)new Abi("arm", "32"), (IRemoteTest)test4, new ArrayList(), new ConfigurationDescriptor());
        testList.add(mod4);
        List res = this.mRepo.getShard(testList, 0, 1);
        ModuleRepoTest.assertEquals((int)4, (int)res.size());
        res = this.mRepo.getShard(testList, 0, 2);
        ModuleRepoTest.assertEquals((int)2, (int)res.size());
        ModuleRepoTest.assertEquals((Object)mod1, res.get(0));
        ModuleRepoTest.assertEquals((Object)mod2, res.get(1));
        res = this.mRepo.getShard(testList, 1, 2);
        ModuleRepoTest.assertEquals((int)2, (int)res.size());
        ModuleRepoTest.assertEquals((Object)mod3, res.get(0));
        ModuleRepoTest.assertEquals((Object)mod4, res.get(1));
    }

    public void testGetShard_cannotSplitMore() {
        ArrayList<ModuleDef> testList = new ArrayList<ModuleDef>();
        TestRuntime test1 = new TestRuntime();
        test1.runtimeHint = 100L;
        ModuleDef mod1 = new ModuleDef("test1", (IAbi)new Abi("arm", "32"), (IRemoteTest)test1, new ArrayList(), new ConfigurationDescriptor());
        testList.add(mod1);
        List res = this.mRepo.getShard(testList, 1, 2);
        ModuleRepoTest.assertNull((Object)res);
    }

    public void testMetadataFilter_emptyFilters() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ModuleRepoTest.assertTrue((String)"config not included when metadata filters are empty", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_matchInclude() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"foo");
        ModuleRepoTest.assertTrue((String)"config not included with matching inclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_noMatchInclude_mismatchValue() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"bar");
        ModuleRepoTest.assertFalse((String)"config not excluded with mismatching inclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_noMatchInclude_mismatchKey() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"group", (Object)"bar");
        ModuleRepoTest.assertFalse((String)"config not excluded with mismatching inclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_matchExclude() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"component", (Object)"foo");
        ModuleRepoTest.assertFalse((String)"config not excluded with matching exclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, excludeFilter));
    }

    public void testMetadataFilter_noMatchExclude_mismatchKey() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"component", (Object)"bar");
        ModuleRepoTest.assertTrue((String)"config not included with mismatching exclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, excludeFilter));
    }

    public void testMetadataFilter_noMatchExclude_mismatchValue() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"group", (Object)"bar");
        ModuleRepoTest.assertTrue((String)"config not included with mismatching exclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, excludeFilter));
    }

    public void testMetadataFilter_matchInclude_multipleMetadataField() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        metadata.put((Object)"component", (Object)"bar");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"foo");
        ModuleRepoTest.assertTrue((String)"config not included with matching inclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_matchExclude_multipleMetadataField() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        metadata.put((Object)"component", (Object)"bar");
        desc.setMetaData(metadata);
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"component", (Object)"foo");
        ModuleRepoTest.assertFalse((String)"config not excluded with matching exclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, excludeFilter));
    }

    public void testMetadataFilter_matchInclude_multipleFilters() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"foo");
        includeFilter.put((Object)"component", (Object)"bar");
        ModuleRepoTest.assertTrue((String)"config not included with matching inclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_matchExclude_multipleFilters() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        desc.setMetaData(metadata);
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"component", (Object)"foo");
        excludeFilter.put((Object)"component", (Object)"bar");
        ModuleRepoTest.assertFalse((String)"config not excluded with matching exclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, excludeFilter));
    }

    public void testMetadataFilter_matchInclude_multipleMetadataAndFilters() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo1");
        metadata.put((Object)"group", (Object)"bar1");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"foo1");
        includeFilter.put((Object)"group", (Object)"bar2");
        ModuleRepoTest.assertTrue((String)"config not included with matching inclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, METADATA_EXCLUDES));
    }

    public void testMetadataFilter_matchExclude_multipleMetadataAndFilters() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo1");
        metadata.put((Object)"group", (Object)"bar1");
        desc.setMetaData(metadata);
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"component", (Object)"foo1");
        excludeFilter.put((Object)"group", (Object)"bar2");
        ModuleRepoTest.assertFalse((String)"config not excluded with matching exclusion filter", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, METADATA_INCLUDES, excludeFilter));
    }

    public void testMetadataFilter_includeAndExclude() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        metadata.put((Object)"group", (Object)"bar1");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"foo");
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"group", (Object)"bar2");
        ModuleRepoTest.assertTrue((String)"config not included with matching inclusion and mismatching exclusion filters", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, excludeFilter));
    }

    public void testMetadataFilter_includeThenExclude() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        ConfigurationDescriptor desc = config.getConfigurationDescription();
        MultiMap metadata = new MultiMap();
        metadata.put((Object)"component", (Object)"foo");
        metadata.put((Object)"group", (Object)"bar");
        desc.setMetaData(metadata);
        MultiMap includeFilter = new MultiMap();
        includeFilter.put((Object)"component", (Object)"foo");
        MultiMap excludeFilter = new MultiMap();
        excludeFilter.put((Object)"group", (Object)"bar");
        ModuleRepoTest.assertFalse((String)"config not excluded with matching inclusion and exclusion filters", (boolean)this.mRepo.filterByConfigMetadata((IConfiguration)config, includeFilter, excludeFilter));
    }

    public void testInjectConfig() throws Exception {
        Configuration config = new Configuration("foo", "bar");
        TestInject checker = new TestInject();
        config.setTest((IRemoteTest)checker);
        HashMap optionMap = new HashMap();
        ArrayList<String> option1 = new ArrayList<String>();
        option1.add("value1");
        optionMap.put("simple-string", option1);
        ArrayList<String> option2 = new ArrayList<String>();
        option2.add("value2");
        option2.add("value3");
        option2.add("set-option:moreoption");
        optionMap.put("list-string", option2);
        ArrayList<String> option3 = new ArrayList<String>();
        option3.add("set-option:=moreoption");
        optionMap.put("map-string", option3);
        this.mRepo.injectOptionsToConfig(optionMap, (IConfiguration)config);
        ModuleRepoTest.assertEquals((String)"value1", (String)checker.test);
        ModuleRepoTest.assertEquals(option2, checker.testList);
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("set-option", "moreoption");
        ModuleRepoTest.assertEquals(resMap, checker.testMap);
    }

    static {
        SERIALS.add(SERIAL1);
        SERIALS.add(SERIAL2);
        SERIALS.add(SERIAL3);
        ABIS.add((IAbi)new Abi(ABI_32, "32"));
        ABIS.add((IAbi)new Abi(ABI_64, "64"));
        DEVICE_TOKENS.add(String.format("%s:%s", SERIAL3, FOOBAR_TOKEN));
        TEST_ARGS.add(TEST_ARG);
        MODULE_ARGS.add(String.format(MODULE_ARG, MODULE_NAME_A));
        MODULE_ARGS.add(String.format(MODULE_ARG, MODULE_NAME_B));
        MODULE_ARGS.add(String.format(MODULE_ARG, MODULE_NAME_C));
        FILES.add(String.format(FILENAME, MODULE_NAME_A));
        FILES.add(String.format(FILENAME, MODULE_NAME_B));
        FILES.add(String.format(FILENAME, MODULE_NAME_C));
    }

    public static class TestInject
    implements IRemoteTest {
        @Option(name="simple-string")
        public String test = null;
        @Option(name="list-string")
        public List<String> testList = new ArrayList<String>();
        @Option(name="map-string")
        public Map<String, String> testMap = new HashMap<String, String>();

        public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        }
    }

    private class TestRuntime
    implements IRemoteTest,
    IRuntimeHintProvider,
    IAbiReceiver,
    ITestCollector,
    ITestFilterReceiver {
        public long runtimeHint = 0L;

        private TestRuntime() {
        }

        public long getRuntimeHint() {
            return this.runtimeHint;
        }

        public void run(ITestInvocationListener arg0) throws DeviceNotAvailableException {
        }

        public void addAllExcludeFilters(Set<String> arg0) {
        }

        public void addAllIncludeFilters(Set<String> arg0) {
        }

        public void addExcludeFilter(String arg0) {
        }

        public void addIncludeFilter(String arg0) {
        }

        public void setCollectTestsOnly(boolean arg0) {
        }

        public void setAbi(IAbi arg0) {
        }

        public IAbi getAbi() {
            return null;
        }

        public Set<String> getIncludeFilters() {
            return null;
        }

        public Set<String> getExcludeFilters() {
            return null;
        }

        public void clearIncludeFilters() {
        }

        public void clearExcludeFilters() {
        }
    }
}

