/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.testtype.CompatibilityTest;
import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import com.android.compatibility.common.tradefed.testtype.IModuleRepo;
import com.android.compatibility.common.tradefed.testtype.ModuleRepo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.util.AbiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class CompatibilityTestTest
extends TestCase {
    private static final String FAKE_HOST_ARCH = "arm";
    private CompatibilityTest mTest;
    private ITestDevice mMockDevice;
    private ITestLogger mMockLogger;
    private ITestInvocationListener mMockListener;

    public void setUp() throws Exception {
        this.mTest = new CompatibilityTest(){

            protected Set<String> getAbisForBuildTargetArch() {
                return AbiUtils.getAbisForArch((String)CompatibilityTestTest.FAKE_HOST_ARCH);
            }
        };
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mTest.setDevice(this.mMockDevice);
        this.mMockLogger = (ITestLogger)EasyMock.createMock(ITestLogger.class);
        this.mMockListener = (ITestInvocationListener)EasyMock.createMock(ITestInvocationListener.class);
    }

    public void testGetAbis() throws DeviceNotAvailableException {
        EasyMock.expect((Object)this.mMockDevice.getProperty((String)EasyMock.eq((Object)"ro.product.cpu.abilist"))).andReturn((Object)"arm64-v8a,armeabi-v7a,armeabi");
        HashSet<String> expectedAbis = new HashSet<String>();
        expectedAbis.add("arm64-v8a");
        expectedAbis.add("armeabi-v7a");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Set res = this.mTest.getAbis();
        CompatibilityTestTest.assertEquals((int)2, (int)res.size());
        for (IAbi abi : res) {
            CompatibilityTestTest.assertTrue((boolean)expectedAbis.contains(abi.getName()));
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    public void testGetAbis_notSupported() throws DeviceNotAvailableException {
        EasyMock.expect((Object)this.mMockDevice.getProperty((String)EasyMock.eq((Object)"ro.product.cpu.abilist"))).andReturn((Object)"armeabi");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mTest.getAbis();
            CompatibilityTestTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            CompatibilityTestTest.assertEquals((String)"None of the abi supported by this CTS build ('[armeabi-v7a, arm64-v8a]') are supported by the device ('[armeabi]').", (String)e.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    public void testGetAbis_primaryAbiOnly() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("primary-abi-only", "true");
        EasyMock.expect((Object)this.mMockDevice.getProperty((String)EasyMock.eq((Object)"ro.product.cpu.abi"))).andReturn((Object)"arm64-v8a");
        HashSet<String> expectedAbis = new HashSet<String>();
        expectedAbis.add("arm64-v8a");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Set res = this.mTest.getAbis();
        CompatibilityTestTest.assertEquals((int)1, (int)res.size());
        for (IAbi abi : res) {
            CompatibilityTestTest.assertTrue((boolean)expectedAbis.contains(abi.getName()));
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    public void testGetAbis_primaryAbiOnly_NotSupported() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("primary-abi-only", "true");
        EasyMock.expect((Object)this.mMockDevice.getProperty((String)EasyMock.eq((Object)"ro.product.cpu.abi"))).andReturn((Object)"armeabi");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mTest.getAbis();
            CompatibilityTestTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            CompatibilityTestTest.assertEquals((String)"Your CTS hasn't been built with abi 'armeabi' support, this CTS currently supports '[armeabi-v7a, arm64-v8a]'.", (String)e.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    public void testGetAbis_skipCtsArchCheck() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("skip-host-arch-check", "true");
        EasyMock.expect((Object)this.mMockDevice.getProperty((String)EasyMock.eq((Object)"ro.product.cpu.abilist"))).andReturn((Object)"x86_64,x86,armeabi");
        HashSet<String> expectedAbis = new HashSet<String>();
        expectedAbis.add("x86_64");
        expectedAbis.add("x86");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Set res = this.mTest.getAbis();
        CompatibilityTestTest.assertEquals((int)2, (int)res.size());
        for (IAbi abi : res) {
            CompatibilityTestTest.assertTrue((boolean)expectedAbis.contains(abi.getName()));
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    public void testGetAbis_skipCtsArchCheck_abiSpecified() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("skip-host-arch-check", "true");
        setter.setOptionValue("abi", "x86");
        HashSet<String> expectedAbis = new HashSet<String>();
        expectedAbis.add("x86");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Set res = this.mTest.getAbis();
        CompatibilityTestTest.assertEquals((int)1, (int)res.size());
        for (IAbi abi : res) {
            CompatibilityTestTest.assertTrue((boolean)expectedAbis.contains(abi.getName()));
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    public void testSplit() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("shards", "4");
        CompatibilityTestTest.assertEquals((int)4, (int)this.mTest.split().size());
    }

    public void testSplit_notShardable() throws Exception {
        CompatibilityTestTest.assertNull((Object)this.mTest.split());
    }

    public void testRunPreModuleCheck() throws Exception {
        ArrayList<Object> systemCheckers = new ArrayList<Object>();
        systemCheckers.add(new ISystemStatusChecker(){});
        systemCheckers.add(new ISystemStatusChecker(){});
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
        this.mTest.runPreModuleCheck("FAKE_MODULE", systemCheckers, this.mMockDevice, this.mMockLogger);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
    }

    public void testRunPreModuleCheck_failure() throws Exception {
        ArrayList<Object> systemCheckers = new ArrayList<Object>();
        systemCheckers.add(new ISystemStatusChecker(){});
        systemCheckers.add(new ISystemStatusChecker(){

            public StatusCheckerResult preExecutionCheck(ITestDevice device) {
                return new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            }
        });
        ByteArrayInputStreamSource res = new ByteArrayInputStreamSource("fake bugreport".getBytes());
        EasyMock.expect((Object)this.mMockDevice.getBugreport()).andReturn((Object)res);
        this.mMockLogger.testLog((String)EasyMock.eq((Object)"bugreport-checker-pre-module-FAKE_MODULE"), (LogDataType)EasyMock.eq((Object)LogDataType.BUGREPORT), (InputStreamSource)EasyMock.same((Object)res));
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
        this.mTest.runPreModuleCheck("FAKE_MODULE", systemCheckers, this.mMockDevice, this.mMockLogger);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
    }

    public void testRunPostModuleCheck() throws Exception {
        ArrayList<Object> systemCheckers = new ArrayList<Object>();
        systemCheckers.add(new ISystemStatusChecker(){});
        systemCheckers.add(new ISystemStatusChecker(){});
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
        this.mTest.runPostModuleCheck("FAKE_MODULE", systemCheckers, this.mMockDevice, this.mMockLogger);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
    }

    public void testRunPostModuleCheck_failure() throws Exception {
        ArrayList<Object> systemCheckers = new ArrayList<Object>();
        systemCheckers.add(new ISystemStatusChecker(){});
        systemCheckers.add(new ISystemStatusChecker(){

            public StatusCheckerResult postExecutionCheck(ITestDevice device) {
                return new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            }
        });
        ByteArrayInputStreamSource res = new ByteArrayInputStreamSource("fake bugreport".getBytes());
        EasyMock.expect((Object)this.mMockDevice.getBugreport()).andReturn((Object)res);
        this.mMockLogger.testLog((String)EasyMock.eq((Object)"bugreport-checker-post-module-FAKE_MODULE"), (LogDataType)EasyMock.eq((Object)LogDataType.BUGREPORT), (InputStreamSource)EasyMock.same((Object)res));
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
        this.mTest.runPostModuleCheck("FAKE_MODULE", systemCheckers, this.mMockDevice, this.mMockLogger);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockLogger});
    }

    public void testRun_noModules() throws Exception {
        this.mTest = new CompatibilityTest(1, (IModuleRepo)new ModuleRepo(){

            public boolean isInitialized() {
                return true;
            }

            public LinkedList<IModuleDef> getModules(String serial, int shardIndex) {
                return new LinkedList<IModuleDef>();
            }
        }, Integer.valueOf(0));
        this.mTest.setDevice(this.mMockDevice);
        EasyMock.expect((Object)this.mMockDevice.getSerialNumber()).andReturn((Object)"FAKE_SERIAL").times(2);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockListener});
        this.mTest.run(this.mMockListener);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockListener});
    }

    public void testCheckSystemStatus_throw() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("system-status-check-whitelist", "com.does.not.exit");
        try {
            this.mTest.checkSystemStatusBlackAndWhiteList();
            CompatibilityTestTest.fail((String)"should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testCheckSystemStatus_pass() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("skip-system-status-check", "com.android.tradefed.suite.checker.KeyguardStatusChecker");
        this.mTest.checkSystemStatusBlackAndWhiteList();
    }
}

