/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.BusinessLogicPreparer;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BusinessLogicPreparerTest {
    private ITestDevice mMockDevice;
    private IBuildInfo mMockBuildInfo;
    private BusinessLogicPreparer mPreparer;
    private Set<String> mPackages;
    private File mTmpDir;
    private static final String MEMORY_DEVICE_INFO_JSON = "{\n    \"low_ram_device\": false,\n    \"memory_class\": 192,\n    \"large_memory_class\": 512,\n    \"total_memory\": 1902936064\n}\n";
    private static final String MANUFACTURER_PROPERTY = "ro.product.manufacturer";
    private static final String CONFIG_VERSION = "DYNAMIC_CONFIG_FILE:";
    private static final String CONFIG_FILE_CONTENT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<dynamicConfig>\n    <entry key=\"remote_config_required\">\n        <value>false</value>\n    </entry>\n    <entry key=\"business_logic_device_features\">\n        <value>android.hardware.type.automotive</value>\n        <value>android.hardware.type.television</value>\n        <value>android.hardware.type.watch</value>\n        <value>android.hardware.type.embedded</value>\n        <value>android.hardware.type.pc</value>\n        <value>android.software.leanback</value>\n    </entry>\n    <entry key=\"business_logic_device_properties\">\n        <value>ro.product.brand</value>\n        <value>ro.product.first_api_level</value>\n        <value>ro.product.manufacturer</value>\n        <value>ro.product.model</value>\n        <value>ro.product.name</value>\n    </entry>\n    <entry key=\"business_logic_device_packages\">\n        <value>com.google.android.gms</value>\n        <value>com.android.vending</value>\n    </entry>\n    <entry key=\"business_logic_extended_device_info\">\n        <value>MemoryDeviceInfo:total_memory</value>\n        <value>MemoryDeviceInfo:low_ram_device</value>\n    </entry>\n</dynamicConfig>\n";
    private static final String LIST_FEATURE_QUERY = "pm list features";
    private static final String FEATURE_WATCH = "android.hardware.type.watch";
    private static final String FEATURE_LEANBACK = "android.software.leanback";
    private static final String FEATURES = "feature:android.hardware.type.watch\nfeature:android.hardware.audio.low_latency\nfeature:android.hardware.camera\nfeature:android.hardware.microphone\nfeature:android.hardware.nfc\nfeature:android.hardware.telephony\nfeature:android.hardware.wifi\nfeature:android.software.leanback\n";
    private static final String GOOGLE_SETTINGS_QUERY = "content query --uri content://com.google.settings/partner";
    private static final String PARTNER_CONTENT = "Row: 0 _id=35, name=use_location_for_services, value=1\nRow: 1 _id=57, name=network_location_opt_in, value=1\nRow: 2 _id=162, name=data_store_version, value=3\nRow: 3 _id=163, name=client_id, value=android-google\nRow: 4 _id=164, name=search_client_id, value=ms-android-google\n";
    private static final String RO_BRAND = "ro.product.brand";
    private static final String RO_FIRST_API_LEVEL = "ro.product.first_api_level";
    private static final String RO_MANIFACTURER = "ro.product.manufacturer";
    private static final String RO_MODEL = "ro.product.model";
    private static final String RO_NAME = "ro.product.name";
    private static final long MEMORY_SIZE = 1902936064L;
    private String serviceUrl = "https://androidpartner.googleapis.com/v1/dynamicconfig/suites/{suite-name}/modules/{module}/version/{version}?key=123";

    @Before
    public void setUp() throws Exception {
        this.mTmpDir = FileUtil.createTempDir((String)"business-logic-unit-tests");
        this.mMockDevice = (ITestDevice)Mockito.mock(ITestDevice.class);
        this.mMockBuildInfo = new BuildInfo();
        this.mPreparer = new BusinessLogicPreparer(){

            String getSuiteName() {
                return "cts";
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("business-logic-url", this.serviceUrl);
        setter.setOptionValue("business-logic-api-key", "fakeApiKey");
        setter.setOptionValue("version", "fakeVersion");
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.recursiveDelete((File)this.mTmpDir);
    }

    @Test
    public void testBuildRequestString_success() throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        File jsonPath = this.createTestDeviceInfoJSONFile("MemoryDeviceInfo", MEMORY_DEVICE_INFO_JSON);
        this.mMockBuildInfo.setFile("device_info_dir", jsonPath, "v1");
        this.mMockBuildInfo.addBuildAttribute("SUITE_VERSION", "v1");
        this.testBuildRequestString(16, attributes);
    }

    @Test
    public void testBuildRequestString_deviceDirDoesntExists() throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("SUITE_VERSION", "v1");
        this.testBuildRequestString(14, attributes);
    }

    @Test
    public void testBuildRequestString_noDeviceInfoJSONFileExists() throws Exception {
        HashMap<String, String> attributes = new HashMap<String, String>();
        File jsonPath = this.createTestDeviceInfoTextFile("MemoryDeviceInfo");
        this.mMockBuildInfo.setFile("device_info_dir", jsonPath, "v1");
        this.mMockBuildInfo.addBuildAttribute("SUITE_VERSION", "v1");
        this.testBuildRequestString(14, attributes);
    }

    private void testBuildRequestString(int expectedParams, Map<String, String> attributes) throws Exception {
        for (String key : attributes.keySet()) {
            this.mMockBuildInfo.addBuildAttribute(key, attributes.get(key));
        }
        Mockito.when((Object)this.mMockDevice.getProperty("ro.product.manufacturer")).thenReturn((Object)"MANUFACTURER_NAME");
        File configFile = this.createFileFromStr(CONFIG_FILE_CONTENT);
        this.mMockBuildInfo.setFile("DYNAMIC_CONFIG_FILE:tests", configFile, "DYNAMIC_CONFIG_FILE:tests");
        this.mMockBuildInfo.setFile("DYNAMIC_CONFIG_FILE:gts", configFile, "DYNAMIC_CONFIG_FILE:gts");
        this.mMockBuildInfo.setFile("DYNAMIC_CONFIG_FILE:cts", configFile, "DYNAMIC_CONFIG_FILE:cts");
        this.mMockBuildInfo.setFile("DYNAMIC_CONFIG_FILE:ats", configFile, "DYNAMIC_CONFIG_FILE:ats");
        Mockito.when((Object)this.mMockDevice.executeShellCommand(LIST_FEATURE_QUERY)).thenReturn((Object)FEATURES);
        Mockito.when((Object)this.mMockDevice.executeShellCommand(GOOGLE_SETTINGS_QUERY)).thenReturn((Object)PARTNER_CONTENT);
        Mockito.when((Object)this.mMockDevice.getProperty(RO_BRAND)).thenReturn((Object)"BRAND_NAME");
        Mockito.when((Object)this.mMockDevice.getProperty(RO_FIRST_API_LEVEL)).thenReturn((Object)"26");
        Mockito.when((Object)this.mMockDevice.getProperty("ro.product.manufacturer")).thenReturn((Object)"MANUFACTURER_NAME");
        Mockito.when((Object)this.mMockDevice.getProperty(RO_MODEL)).thenReturn((Object)"fake_model");
        Mockito.when((Object)this.mMockDevice.getProperty(RO_NAME)).thenReturn((Object)"fake_name");
        List<String> pkgNameList = Arrays.asList("com.android.vending", "com.google.android.gms", "com.google.android.youtube", "com.google.android.apps.photos");
        this.mPackages = new HashSet<String>(pkgNameList);
        Mockito.when((Object)this.mMockDevice.getInstalledPackageNames()).thenReturn(this.mPackages);
        Mockito.when((Object)this.mMockDevice.getTotalMemory()).thenReturn((Object)1902936064L);
        ArrayList<String> expectFeatures = new ArrayList<String>(Arrays.asList(FEATURE_WATCH, FEATURE_LEANBACK));
        ArrayList<String> expectProperties = new ArrayList<String>(Arrays.asList("search_client_id", "client_id", RO_BRAND, RO_FIRST_API_LEVEL, "ro.product.manufacturer", RO_MODEL, RO_NAME));
        ArrayList<String> expectPropertyValues = new ArrayList<String>(Arrays.asList("ms-android-google", "android-google", "BRAND_NAME", "26", "MANUFACTURER_NAME", "fake_model", "fake_name"));
        ArrayList<String> expectPackages = new ArrayList<String>(pkgNameList);
        ArrayList<String> expectDeviceInfos = new ArrayList<String>(Arrays.asList("MemoryDeviceInfo%3Atotal_memory%3A1902936064", "MemoryDeviceInfo%3Alow_ram_device%3Afalse"));
        String[] params = this.mPreparer.buildRequestParams(this.mMockDevice, this.mMockBuildInfo).split("&");
        Assert.assertEquals((long)expectedParams, (long)params.length);
        for (String param : params) {
            String[] keyVal = param.split("=");
            if (keyVal[0].startsWith("features")) {
                if (expectFeatures.contains(keyVal[1])) {
                    expectFeatures.remove(keyVal[1]);
                } else {
                    Assert.fail((String)"Found unknown Feature string");
                }
            }
            if (keyVal[0].startsWith("properties")) {
                String[] property = keyVal[1].split("%3A");
                if (expectProperties.contains(property[0])) {
                    Assert.assertEquals((Object)expectPropertyValues.get(expectProperties.indexOf(property[0])), (Object)property[1]);
                    expectProperties.remove(property[0]);
                    expectPropertyValues.remove(property[1]);
                } else {
                    Assert.fail((String)"Found unknown Property string");
                }
            }
            if (keyVal[0].startsWith("package")) {
                if (expectPackages.contains(keyVal[1])) {
                    expectPackages.remove(keyVal[1]);
                } else {
                    Assert.fail((String)"Found unknown Package string");
                }
            }
            if (!keyVal[0].startsWith("device_info")) continue;
            if (expectDeviceInfos.contains(keyVal[1])) {
                expectDeviceInfos.remove(keyVal[1]);
                continue;
            }
            Assert.fail((String)"Found unknown Feature string");
        }
        Assert.assertEquals((long)expectFeatures.size(), (long)0L);
        Assert.assertEquals((long)expectProperties.size(), (long)0L);
        Assert.assertEquals((long)expectPackages.size(), (long)2L);
    }

    private File createTestDeviceInfoJSONFile(String DeviceInfoClassName, String jsonStr) throws IOException {
        File file = new File(this.mTmpDir, DeviceInfoClassName + ".deviceinfo.json");
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(jsonStr.getBytes());
        stream.flush();
        stream.close();
        return this.mTmpDir;
    }

    private File createTestDeviceInfoTextFile(String DeviceInfoClassName) throws IOException {
        new File(this.mTmpDir, DeviceInfoClassName + ".deviceinfo.text");
        return this.mTmpDir;
    }

    private File createFileFromStr(String configStr) throws IOException {
        File file = File.createTempFile("test", "dynamic");
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(configStr.getBytes());
        stream.flush();
        stream.close();
        return file;
    }
}

