/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.SubPlanHelper;
import com.android.compatibility.common.tradefed.testtype.ISubPlan;
import com.android.compatibility.common.tradefed.testtype.SubPlan;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.InvocationResult;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.TestFilter;
import com.android.compatibility.common.util.TestStatus;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Set;
import junit.framework.TestCase;

public class SubPlanHelperTest
extends TestCase {
    private static final String SUITE_NAME = "CTS";
    private static final String SUITE_VERSION = "5.0";
    private static final String SUITE_PLAN = "cts";
    private static final String SUITE_BUILD = "12345";
    private static final String NAME_A = "ModuleA";
    private static final String NAME_B = "ModuleB";
    private static final String ABI = "mips64";
    private static final String ID_A = AbiUtils.createId((String)"mips64", (String)"ModuleA");
    private static final String ID_B = AbiUtils.createId((String)"mips64", (String)"ModuleB");
    private static final String BUILD_ID = "build_id";
    private static final String BUILD_PRODUCT = "build_product";
    private static final String EXAMPLE_BUILD_ID = "XYZ";
    private static final String EXAMPLE_BUILD_PRODUCT = "wolverine";
    private static final String DEVICE_A = "device123";
    private static final String DEVICE_B = "device456";
    private static final String CLASS_A = "android.test.Foor";
    private static final String CLASS_B = "android.test.Bar";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String METHOD_4 = "testBlah4";
    private static final long START_MS = 1431586801000L;
    private static final long END_MS = 1431673199000L;
    private static final String REFERENCE_URL = "http://android.com";
    private static final String LOG_URL = "file:///path/to/logs";
    private static final String COMMAND_LINE_ARGS = "cts -m CtsMyModuleTestCases";
    private static final String SP_NAME = "testsubplan";
    private static final String SP_SESSION = "0";
    private static final String SP_RESULT_TYPE_FAILED = "failed";
    private static final String SP_RESULT_TYPE_NOT_EXECUTED = "not_executed";
    private static final String PARAM_SUFFIX = "[0]";
    private CompatibilityBuildHelper mBuildHelper;
    private SubPlanHelper mSubPlanHelper;
    private File mResultsDir = null;
    private File mResultDir = null;
    private File mSubPlansDir = null;

    public void setUp() throws Exception {
        this.mResultsDir = FileUtil.createTempDir((String)"results");
        this.mResultDir = FileUtil.createTempDir((String)SUITE_BUILD, (File)this.mResultsDir);
        this.mSubPlansDir = FileUtil.createTempDir((String)"subplans");
        this.mBuildHelper = new SpctMockCompatibilityBuildHelper((IBuildInfo)new BuildInfo(SP_SESSION, ""));
        this.populateResults();
        this.mSubPlanHelper = new SubPlanHelper();
        ArgsOptionParser optionParser = new ArgsOptionParser(new Object[]{this.mSubPlanHelper});
        optionParser.parse(Arrays.asList("-n", SP_NAME, "--session", SP_SESSION, "--result-type", SP_RESULT_TYPE_FAILED, "--result-type", SP_RESULT_TYPE_NOT_EXECUTED));
    }

    public void tearDown() throws Exception {
        if (this.mResultsDir != null) {
            FileUtil.recursiveDelete((File)this.mResultsDir);
        }
        if (this.mSubPlansDir != null) {
            FileUtil.recursiveDelete((File)this.mSubPlansDir);
        }
    }

    public void testCreateSubPlan() throws Exception {
        ISubPlan plan = this.mSubPlanHelper.createSubPlan(this.mBuildHelper);
        Set planIncludes = plan.getIncludeFilters();
        Set planExcludes = plan.getExcludeFilters();
        TestFilter mf1 = new TestFilter(ABI, NAME_A, null);
        TestFilter tf1 = new TestFilter(ABI, NAME_A, String.format("%s#%s", CLASS_A, METHOD_1));
        TestFilter tf3 = new TestFilter(ABI, NAME_B, String.format("%s#%s", CLASS_B, METHOD_3));
        SubPlanHelperTest.assertTrue((boolean)planIncludes.contains("CtsMyModuleTestCases"));
        SubPlanHelperTest.assertTrue((boolean)planIncludes.contains(mf1.toString()));
        SubPlanHelperTest.assertTrue((boolean)planExcludes.contains(tf1.toString()));
        SubPlanHelperTest.assertTrue((boolean)planIncludes.contains(tf3.toString()));
    }

    public void testAddInclude() throws Exception {
        SubPlan subPlan = new SubPlan();
        TestFilter tf = new TestFilter(ABI, NAME_A, String.format("%s#%s", CLASS_A, METHOD_1));
        SubPlanHelper.addIncludeToSubPlan((ISubPlan)subPlan, (TestFilter)tf);
        Set includes = subPlan.getIncludeFilters();
        SubPlanHelperTest.assertTrue((boolean)includes.contains(tf.toString()));
    }

    public void testAddExclude() throws Exception {
        SubPlan subPlan = new SubPlan();
        TestFilter tf = new TestFilter(ABI, NAME_A, String.format("%s#%s", CLASS_A, METHOD_1));
        SubPlanHelper.addExcludeToSubPlan((ISubPlan)subPlan, (TestFilter)tf);
        Set excludes = subPlan.getExcludeFilters();
        SubPlanHelperTest.assertTrue((boolean)excludes.contains(tf.toString()));
    }

    public void testAddParameterizedInclude() throws Exception {
        SubPlan subPlan = new SubPlan();
        TestFilter filterWithSuffix = new TestFilter(ABI, NAME_A, String.format("%s#%s%s", CLASS_A, METHOD_1, PARAM_SUFFIX));
        TestFilter filterWithoutSuffix = new TestFilter(ABI, NAME_A, String.format("%s#%s", CLASS_A, METHOD_1));
        SubPlanHelper.addIncludeToSubPlan((ISubPlan)subPlan, (TestFilter)filterWithSuffix);
        Set includes = subPlan.getIncludeFilters();
        SubPlanHelperTest.assertTrue((boolean)includes.contains(filterWithoutSuffix.toString()));
    }

    public void testAddParameterizedExclude() throws Exception {
        SubPlan subPlan = new SubPlan();
        TestFilter filterWithSuffix = new TestFilter(ABI, NAME_A, String.format("%s#%s%s", CLASS_A, METHOD_1, PARAM_SUFFIX));
        SubPlanHelper.addExcludeToSubPlan((ISubPlan)subPlan, (TestFilter)filterWithSuffix);
        Set excludes = subPlan.getExcludeFilters();
        SubPlanHelperTest.assertTrue((boolean)excludes.isEmpty());
    }

    private void populateResults() throws Exception {
        InvocationResult result = new InvocationResult();
        result.setStartTime(1431586801000L);
        result.setTestPlan(SUITE_PLAN);
        result.addDeviceSerial(DEVICE_A);
        result.addDeviceSerial(DEVICE_B);
        result.addInvocationInfo(BUILD_ID, EXAMPLE_BUILD_ID);
        result.addInvocationInfo(BUILD_PRODUCT, EXAMPLE_BUILD_PRODUCT);
        IModuleResult moduleA = result.getOrCreateModule(ID_A);
        moduleA.setDone(false);
        ICaseResult moduleACase = moduleA.getOrCreateResult(CLASS_A);
        ITestResult moduleATest1 = moduleACase.getOrCreateResult(METHOD_1);
        moduleATest1.setResultStatus(TestStatus.PASS);
        ITestResult moduleATest2 = moduleACase.getOrCreateResult(METHOD_2);
        moduleATest2.setResultStatus(null);
        IModuleResult moduleB = result.getOrCreateModule(ID_B);
        moduleB.setDone(true);
        ICaseResult moduleBCase = moduleB.getOrCreateResult(CLASS_B);
        ITestResult moduleBTest3 = moduleBCase.getOrCreateResult(METHOD_3);
        moduleBTest3.setResultStatus(TestStatus.FAIL);
        ITestResult moduleBTest4 = moduleBCase.getOrCreateResult(METHOD_4);
        moduleBTest4.setResultStatus(TestStatus.PASS);
        ResultHandler.writeResults((String)SUITE_NAME, (String)SUITE_VERSION, (String)SUITE_PLAN, (String)SUITE_BUILD, (IInvocationResult)result, (File)this.mResultDir, (long)1431586801000L, (long)1431673199000L, (String)REFERENCE_URL, (String)LOG_URL, (String)COMMAND_LINE_ARGS, null);
    }

    private class SpctMockCompatibilityBuildHelper
    extends CompatibilityBuildHelper {
        public SpctMockCompatibilityBuildHelper(IBuildInfo buildInfo) {
            super(buildInfo);
        }

        public File getResultsDir() throws FileNotFoundException {
            return SubPlanHelperTest.this.mResultsDir;
        }

        public File getSubPlansDir() throws FileNotFoundException {
            return SubPlanHelperTest.this.mSubPlansDir;
        }
    }
}

