/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.result.ConsoleReporter;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.AbiUtils;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConsoleReporterTest {
    private static final String NAME = "ModuleName";
    private static final String NAME2 = "ModuleName2";
    private static final String ABI = "mips64";
    private static final String ID = AbiUtils.createId((String)"mips64", (String)"ModuleName");
    private static final String ID2 = AbiUtils.createId((String)"mips64", (String)"ModuleName2");
    private static final String CLASS = "android.test.FoorBar";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String STACK_TRACE = "Something small is not alright\n at four.big.insects.Marley.sing(Marley.java:10)";
    private ConsoleReporter mReporter;
    private IInvocationContext mContext;

    @Before
    public void setUp() throws Exception {
        this.mReporter = new ConsoleReporter();
        OptionSetter setter = new OptionSetter(new Object[]{this.mReporter});
        setter.setOptionValue("quiet-output", "true");
    }

    @After
    public void tearDown() throws Exception {
        this.mReporter = null;
    }

    @Test
    public void testResultReporting_singleModule() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 4);
        this.runTests();
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        Assert.assertEquals((Object)ID, (Object)this.mReporter.getModuleId());
        Assert.assertEquals((long)2L, (long)this.mReporter.getFailedTests());
        Assert.assertEquals((long)1L, (long)this.mReporter.getPassedTests());
        Assert.assertEquals((long)4L, (long)this.mReporter.getCurrentTestNum());
        Assert.assertEquals((long)4L, (long)this.mReporter.getTotalTestsInModule());
    }

    @Test
    public void testResultReporting_multipleModules() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 4);
        this.runTests();
        Assert.assertEquals((Object)ID, (Object)this.mReporter.getModuleId());
        Assert.assertEquals((long)2L, (long)this.mReporter.getFailedTests());
        Assert.assertEquals((long)1L, (long)this.mReporter.getPassedTests());
        Assert.assertEquals((long)4L, (long)this.mReporter.getCurrentTestNum());
        Assert.assertEquals((long)4L, (long)this.mReporter.getTotalTestsInModule());
        this.mReporter.testRunStarted(ID2, 4);
        Assert.assertEquals((Object)ID2, (Object)this.mReporter.getModuleId());
        Assert.assertEquals((long)0L, (long)this.mReporter.getFailedTests());
        Assert.assertEquals((long)0L, (long)this.mReporter.getPassedTests());
        Assert.assertEquals((long)0L, (long)this.mReporter.getCurrentTestNum());
        Assert.assertEquals((long)4L, (long)this.mReporter.getTotalTestsInModule());
    }

    private void runTests() {
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        this.mReporter.testStarted(test1);
        this.mReporter.testEnded(test1, new HashMap());
        Assert.assertFalse((boolean)this.mReporter.getTestFailed());
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        Assert.assertFalse((boolean)this.mReporter.getTestFailed());
        this.mReporter.testFailed(test2, STACK_TRACE);
        Assert.assertTrue((boolean)this.mReporter.getTestFailed());
        TestDescription test3 = new TestDescription(CLASS, METHOD_3);
        this.mReporter.testStarted(test3);
        Assert.assertFalse((boolean)this.mReporter.getTestFailed());
        this.mReporter.testFailed(test3, STACK_TRACE);
        Assert.assertTrue((boolean)this.mReporter.getTestFailed());
        TestDescription test4 = new TestDescription(CLASS, METHOD_3);
        this.mReporter.testStarted(test4);
        Assert.assertFalse((boolean)this.mReporter.getTestFailed());
        this.mReporter.testIgnored(test4);
        Assert.assertFalse((boolean)this.mReporter.getTestFailed());
    }
}

