/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.build;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CompatibilityBuildProviderTest {
    private CompatibilityBuildProvider mProvider;
    private ITestDevice mMockDevice;
    private File mRootDir;

    @Before
    public void setUp() throws Exception {
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mRootDir = FileUtil.createTempDir((String)"cts-root-dir");
        this.mProvider = new CompatibilityBuildProvider(){

            String getRootDirPath() {
                return CompatibilityBuildProviderTest.this.mRootDir.getAbsolutePath();
            }

            protected String getSuiteInfoName() {
                return "CTS";
            }

            ExecutionFiles getInvocationFiles() {
                return null;
            }
        };
    }

    @After
    public void tearDown() {
        FileUtil.recursiveDelete((File)this.mRootDir);
    }

    @Test
    public void testBaseGetBuild() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        IBuildInfo info = this.mProvider.getBuild(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertTrue((boolean)(info instanceof IDeviceBuildInfo));
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
    }

    @Test
    public void testBaseGetBuild_withDevice() throws Exception {
        new File(this.mRootDir, "android-cts/testcases").mkdirs();
        OptionSetter setter = new OptionSetter(new Object[]{this.mProvider});
        setter.setOptionValue("use-device-build-info", "true");
        setter.setOptionValue("branch", "build_branch");
        EasyMock.expect((Object)this.mMockDevice.getBuildId()).andReturn((Object)"8888");
        EasyMock.expect((Object)this.mMockDevice.getBuildFlavor()).andReturn((Object)"flavor");
        EasyMock.expect((Object)this.mMockDevice.getBuildAlias()).andReturn((Object)"alias");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.name")).andReturn((Object)"product");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.build.type")).andReturn((Object)"userdebug");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        IBuildInfo info = this.mProvider.getBuild(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertTrue((boolean)(info instanceof IDeviceBuildInfo));
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
        this.mProvider.cleanUp(info);
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
    }

    @Test
    public void testBaseGetBuild_withDeviceAndBuildFlavorPrefix() throws Exception {
        new File(this.mRootDir, "android-cts/testcases").mkdirs();
        OptionSetter setter = new OptionSetter(new Object[]{this.mProvider});
        setter.setOptionValue("use-device-build-info", "true");
        setter.setOptionValue("branch", "build_branch");
        setter.setOptionValue("build-flavor-prefix", "prefix-");
        EasyMock.expect((Object)this.mMockDevice.getBuildId()).andReturn((Object)"8888");
        EasyMock.expect((Object)this.mMockDevice.getBuildFlavor()).andReturn((Object)"flavor");
        EasyMock.expect((Object)this.mMockDevice.getBuildAlias()).andReturn((Object)"alias");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.name")).andReturn((Object)"product");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.build.type")).andReturn((Object)"userdebug");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        IBuildInfo info = this.mProvider.getBuild(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertTrue((boolean)(info instanceof IDeviceBuildInfo));
        Assert.assertEquals((Object)"prefix-flavor", (Object)((IDeviceBuildInfo)info).getBuildFlavor());
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
        this.mProvider.cleanUp(info);
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
    }

    @Test
    public void testBaseGetBuild_withBuildFlavorAndPrefixOverride() throws Exception {
        new File(this.mRootDir, "android-cts/testcases").mkdirs();
        OptionSetter setter = new OptionSetter(new Object[]{this.mProvider});
        setter.setOptionValue("use-device-build-info", "true");
        setter.setOptionValue("branch", "build_branch");
        setter.setOptionValue("build-flavor", "artificial-flavor");
        setter.setOptionValue("build-flavor-prefix", "prefix-");
        EasyMock.expect((Object)this.mMockDevice.getBuildId()).andReturn((Object)"8888");
        EasyMock.expect((Object)this.mMockDevice.getBuildFlavor()).andReturn((Object)"flavor").anyTimes();
        EasyMock.expect((Object)this.mMockDevice.getBuildAlias()).andReturn((Object)"alias");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.name")).andReturn((Object)"product");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.build.type")).andReturn((Object)"userdebug");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        IBuildInfo info = this.mProvider.getBuild(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertTrue((boolean)(info instanceof IDeviceBuildInfo));
        Assert.assertEquals((Object)"prefix-artificial-flavor", (Object)((IDeviceBuildInfo)info).getBuildFlavor());
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
        this.mProvider.cleanUp(info);
        Assert.assertNotNull((Object)((IDeviceBuildInfo)info).getTestsDir());
    }

    @Test
    public void testDynamicUrlOverride() throws Exception {
        String uniquePattern = "UNIQUE_SUITE_NAME_PATTERN";
        OptionSetter setter = new OptionSetter(new Object[]{this.mProvider});
        setter.setOptionValue("url-suite-name-override", "UNIQUE_SUITE_NAME_PATTERN");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        IBuildInfo info = this.mProvider.getBuild(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        String url = (String)info.getBuildAttributes().get("DYNAMIC_CONFIG_OVERRIDE_URL");
        Assert.assertTrue((String)String.format("URL was %s and should have contained %s", url, "UNIQUE_SUITE_NAME_PATTERN"), (boolean)url.contains("UNIQUE_SUITE_NAME_PATTERN"));
    }

    @Test
    public void testGetRootDirPath() throws Exception {
        CompatibilityBuildProvider provider = new CompatibilityBuildProvider(){

            protected String getSuiteInfoName() {
                return "VTS-CORE";
            }
        };
        String path = "test/path";
        System.setProperty("VTS_CORE_ROOT", "test/path");
        Assert.assertEquals((Object)"test/path", (Object)provider.getRootDirPath());
    }
}

