/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.truth.AtomicLongMapSubject;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListMultimapSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SetMultimapSubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.SortedMapSubject;
import com.google.common.truth.SortedSetSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.TableSubject;
import com.google.common.truth.ThrowableSubject;
import com.google.common.util.concurrent.AtomicLongMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class StandardSubjectBuilder {
    private final FailureMetadata metadataDoNotReferenceDirectly;

    public static StandardSubjectBuilder forCustomFailureStrategy(FailureStrategy failureStrategy) {
        return new StandardSubjectBuilder(FailureMetadata.forFailureStrategy(failureStrategy));
    }

    StandardSubjectBuilder(FailureMetadata metadata) {
        this.metadataDoNotReferenceDirectly = Preconditions.checkNotNull(metadata);
    }

    public final <ComparableT extends Comparable<?>> ComparableSubject<?, ComparableT> that(@NullableDecl ComparableT actual) {
        return new ComparableSubject(this.metadata(), actual){};
    }

    public final BigDecimalSubject that(@NullableDecl BigDecimal actual) {
        return new BigDecimalSubject(this.metadata(), actual);
    }

    public final Subject<DefaultSubject, Object> that(@NullableDecl Object actual) {
        return new DefaultSubject(this.metadata(), actual);
    }

    @GwtIncompatible(value="ClassSubject.java")
    public final ClassSubject that(@NullableDecl Class<?> actual) {
        return new ClassSubject(this.metadata(), actual);
    }

    public final ThrowableSubject that(@NullableDecl Throwable actual) {
        return new ThrowableSubject(this.metadata(), actual, "throwable");
    }

    public final LongSubject that(@NullableDecl Long actual) {
        return new LongSubject(this.metadata(), actual);
    }

    public final DoubleSubject that(@NullableDecl Double actual) {
        return new DoubleSubject(this.metadata(), actual);
    }

    public final FloatSubject that(@NullableDecl Float actual) {
        return new FloatSubject(this.metadata(), actual);
    }

    public final IntegerSubject that(@NullableDecl Integer actual) {
        return new IntegerSubject(this.metadata(), actual);
    }

    public final BooleanSubject that(@NullableDecl Boolean actual) {
        return new BooleanSubject(this.metadata(), actual);
    }

    public final StringSubject that(@NullableDecl String actual) {
        return new StringSubject(this.metadata(), actual);
    }

    public final IterableSubject that(@NullableDecl Iterable<?> actual) {
        return new IterableSubject(this.metadata(), actual);
    }

    public final SortedSetSubject that(@NullableDecl SortedSet<?> actual) {
        return new SortedSetSubject(this.metadata(), actual);
    }

    public final <T> ObjectArraySubject<T> that(@NullableDecl T[] actual) {
        return new ObjectArraySubject<T>(this.metadata(), actual, "array");
    }

    public final PrimitiveBooleanArraySubject that(@NullableDecl boolean[] actual) {
        return new PrimitiveBooleanArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveShortArraySubject that(@NullableDecl short[] actual) {
        return new PrimitiveShortArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveIntArraySubject that(@NullableDecl int[] actual) {
        return new PrimitiveIntArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveLongArraySubject that(@NullableDecl long[] actual) {
        return new PrimitiveLongArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveCharArraySubject that(@NullableDecl char[] actual) {
        return new PrimitiveCharArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveByteArraySubject that(@NullableDecl byte[] actual) {
        return new PrimitiveByteArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveFloatArraySubject that(@NullableDecl float[] actual) {
        return new PrimitiveFloatArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveDoubleArraySubject that(@NullableDecl double[] actual) {
        return new PrimitiveDoubleArraySubject(this.metadata(), actual, "array");
    }

    public final GuavaOptionalSubject that(@NullableDecl Optional<?> actual) {
        return new GuavaOptionalSubject(this.metadata(), actual, "optional");
    }

    public final MapSubject that(@NullableDecl Map<?, ?> actual) {
        return new MapSubject(this.metadata(), actual);
    }

    public final SortedMapSubject that(@NullableDecl SortedMap<?, ?> actual) {
        return new SortedMapSubject(this.metadata(), actual);
    }

    public final MultimapSubject that(@NullableDecl Multimap<?, ?> actual) {
        return new MultimapSubject(this.metadata(), actual, "multimap");
    }

    public final ListMultimapSubject that(@NullableDecl ListMultimap<?, ?> actual) {
        return new ListMultimapSubject(this.metadata(), actual, "multimap");
    }

    public final SetMultimapSubject that(@NullableDecl SetMultimap<?, ?> actual) {
        return new SetMultimapSubject(this.metadata(), actual, "multimap");
    }

    public final MultisetSubject that(@NullableDecl Multiset<?> actual) {
        return new MultisetSubject(this.metadata(), actual);
    }

    public final TableSubject that(@NullableDecl Table<?, ?, ?> actual) {
        return new TableSubject(this.metadata(), actual);
    }

    public final AtomicLongMapSubject that(@NullableDecl AtomicLongMap<?> actual) {
        return new AtomicLongMapSubject(this.metadata(), actual);
    }

    public final StandardSubjectBuilder withMessage(@NullableDecl String messageToPrepend) {
        return this.withMessage("%s", messageToPrepend);
    }

    public final StandardSubjectBuilder withMessage(@NullableDecl String format, Object ... args) {
        return new StandardSubjectBuilder(this.metadata().withMessage(format, args));
    }

    public final <S extends Subject<S, A>, A> SimpleSubjectBuilder<S, A> about(Subject.Factory<S, A> factory) {
        return new SimpleSubjectBuilder<S, A>(this.metadata(), factory);
    }

    public final <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT about(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return factory.createSubjectBuilder(this.metadata());
    }

    public final void fail() {
        this.metadata().fail("");
    }

    public final void fail(@NullableDecl String format, Object ... args) {
        this.metadata().fail(Strings.lenientFormat(format, args));
    }

    private FailureMetadata metadata() {
        this.checkStatePreconditions();
        return this.metadataDoNotReferenceDirectly;
    }

    void checkStatePreconditions() {
    }
}

