/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Floats;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class PrimitiveFloatArraySubject
extends AbstractArraySubject<PrimitiveFloatArraySubject, float[]> {
    private static final Correspondence<Float, Number> EXACT_EQUALITY_CORRESPONDENCE = new Correspondence<Float, Number>(){

        @Override
        public boolean compare(Float actual, Number expected) {
            return Float.floatToIntBits(actual.floatValue()) == Float.floatToIntBits(PrimitiveFloatArraySubject.checkedToFloat(expected));
        }

        @Override
        public String toString() {
            return "is exactly equal to";
        }
    };

    PrimitiveFloatArraySubject(FailureMetadata metadata, @NullableDecl float[] o, @NullableDecl String typeDescription) {
        super(metadata, o, typeDescription);
    }

    @Override
    public void isEqualTo(Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isNotEqualTo(Object expected) {
        super.isNotEqualTo(expected);
    }

    @Deprecated
    public TolerantPrimitiveFloatArrayComparison hasValuesWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.actual());
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && !MathUtil.equalWithinTolerance(actual[expectedCount], number.floatValue(), tolerance)) {
                        mismatches.add(expectedCount);
                    }
                    ++expectedCount;
                }
                if (actual.length != expectedCount) {
                    PrimitiveFloatArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveFloatArraySubject.this.actualAsString(), Float.valueOf(tolerance), Iterables.toString(expected), expectedCount, actual.length);
                    return;
                }
                if (!mismatches.isEmpty()) {
                    PrimitiveFloatArraySubject.this.failWithBadResults("has values within " + tolerance + " of", Iterables.toString(expected), "differs at indexes", mismatches);
                    return;
                }
            }
        };
    }

    @Deprecated
    public TolerantPrimitiveFloatArrayComparison hasValuesNotWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.actual());
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && MathUtil.notEqualWithinTolerance(actual[expectedCount], number.floatValue(), tolerance)) {
                        return;
                    }
                    ++expectedCount;
                }
                if (actual.length == expectedCount) {
                    PrimitiveFloatArraySubject.this.fail("has values not within " + tolerance + " of", (Object)Iterables.toString(expected));
                }
            }
        };
    }

    public FloatArrayAsIterable usingTolerance(double tolerance) {
        return new FloatArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static float checkedToFloat(Number expected) {
        Preconditions.checkNotNull(expected);
        Preconditions.checkArgument(!(expected instanceof Double), "Expected value in assertion using exact float equality was a double, which is not supported as a double may not have an exact float representation");
        Preconditions.checkArgument(expected instanceof Float || expected instanceof Integer || expected instanceof Long, "Expected value in assertion using exact float equality was of unsupported type %s (it may not have an exact float representation)", expected.getClass());
        if (expected instanceof Integer) {
            Preconditions.checkArgument(Math.abs((Integer)expected) <= 0x1000000, "Expected value %s in assertion using exact float equality was an int with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        if (expected instanceof Long) {
            Preconditions.checkArgument(Math.abs((Long)expected) <= 0x1000000L, "Expected value %s in assertion using exact float equality was a long with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        return expected.floatValue();
    }

    public FloatArrayAsIterable usingExactEquality() {
        return new FloatArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.checkNoNeedToDisplayBothValues("asList()", new Object[0]).about(this.iterablesWithCustomFloatToString()).that(Floats.asList((float[])this.actual()));
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterablesWithCustomFloatToString() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata, Iterable<?> actual) {
                return new IterableSubjectWithInheritedToString(metadata, actual);
            }
        };
    }

    private final class IterableSubjectWithInheritedToString
    extends IterableSubject {
        IterableSubjectWithInheritedToString(FailureMetadata metadata, Iterable<?> actual) {
            super(metadata, actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return PrimitiveFloatArraySubject.this.actualCustomStringRepresentationForPackageMembersToCall();
        }
    }

    public static final class FloatArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Float, Number> {
        FloatArrayAsIterable(Correspondence<? super Float, Number> correspondence, IterableSubject subject) {
            super(subject, correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAllOf(float[] expected) {
            return this.containsAllIn(Floats.asList(expected));
        }

        public void containsAnyOf(float[] expected) {
            this.containsAnyIn(Floats.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(float[] expected) {
            return this.containsExactlyElementsIn(Floats.asList(expected));
        }

        public void containsNoneOf(float[] excluded) {
            this.containsNoneIn(Floats.asList(excluded));
        }
    }

    public static abstract class TolerantPrimitiveFloatArrayComparison {
        private TolerantPrimitiveFloatArrayComparison() {
        }

        public void of(float ... expected) {
            this.ofElementsIn(Floats.asList(expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@NullableDecl Object o) {
            throw new UnsupportedOperationException("If you meant to compare float arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

