/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class MultisetSubject
extends IterableSubject {
    MultisetSubject(FailureMetadata metadata, @NullableDecl Multiset<?> multiset) {
        super(metadata, (Iterable<?>)multiset);
    }

    @Override
    public MultisetSubject named(String format, Object ... args) {
        super.named(format, args);
        return this;
    }

    public final void hasCount(@NullableDecl Object element, int expectedCount) {
        Preconditions.checkArgument(expectedCount >= 0, "expectedCount(%s) must be >= 0", expectedCount);
        int actualCount = ((Multiset)this.actual()).count(element);
        this.check("count(%s)", element).that(actualCount).isEqualTo(expectedCount);
    }
}

