/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Platform;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class FloatSubject
extends ComparableSubject<FloatSubject, Float> {
    private static final int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);

    FloatSubject(FailureMetadata metadata, @NullableDecl Float actual) {
        super(metadata, actual);
    }

    public TolerantFloatComparison isWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = (Float)FloatSubject.this.actual();
                Preconditions.checkNotNull(actual, "actual value cannot be null. tolerance=%s expected=%s", (Object)Float.valueOf(tolerance), (Object)Float.valueOf(expected));
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithoutActual(Fact.fact("expected", Platform.floatToString(expected)), FloatSubject.this.butWas(), Fact.fact("outside tolerance", Platform.floatToString(tolerance)));
                }
            }
        };
    }

    public TolerantFloatComparison isNotWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = (Float)FloatSubject.this.actual();
                Preconditions.checkNotNull(actual, "actual value cannot be null. tolerance=%s expected=%s", (Object)Float.valueOf(tolerance), (Object)Float.valueOf(expected));
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.notEqualWithinTolerance(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithoutActual(Fact.fact("expected not to be", Platform.floatToString(expected)), FloatSubject.this.butWas(), Fact.fact("within tolerance", Platform.floatToString(tolerance)));
                }
            }
        };
    }

    public final void isEqualTo(@NullableDecl Float other) {
        super.isEqualTo(other);
    }

    public final void isNotEqualTo(@NullableDecl Float other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(Float other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(float tolerance) {
        Preconditions.checkArgument(!Float.isNaN(tolerance), "tolerance cannot be NaN");
        Preconditions.checkArgument(tolerance >= 0.0f, "tolerance (%s) cannot be negative", (Object)Float.valueOf(tolerance));
        Preconditions.checkArgument(Float.floatToIntBits(tolerance) != NEG_ZERO_BITS, "tolerance (%s) cannot be negative", (Object)Float.valueOf(tolerance));
        Preconditions.checkArgument(tolerance != Float.POSITIVE_INFINITY, "tolerance cannot be POSITIVE_INFINITY");
    }

    public final void isZero() {
        if (this.actual() == null || ((Float)this.actual()).floatValue() != 0.0f) {
            this.failWithActual(Fact.simpleFact("expected zero"), new Fact[0]);
        }
    }

    public final void isNonZero() {
        if (this.actual() == null) {
            this.failWithActual(Fact.simpleFact("expected a float other than zero"), new Fact[0]);
        } else if (((Float)this.actual()).floatValue() == 0.0f) {
            this.failWithActual(Fact.simpleFact("expected not to be zero"), new Fact[0]);
        }
    }

    public final void isPositiveInfinity() {
        this.isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public final void isNegativeInfinity() {
        this.isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    public final void isNaN() {
        this.isEqualTo(Float.valueOf(Float.NaN));
    }

    public final void isFinite() {
        if (this.actual() == null || ((Float)this.actual()).isNaN() || ((Float)this.actual()).isInfinite()) {
            this.failWithActual(Fact.simpleFact("expected to be finite"), new Fact[0]);
        }
    }

    public final void isNotNaN() {
        if (this.actual() == null) {
            this.failWithActual(Fact.simpleFact("expected a float other than NaN"), new Fact[0]);
        } else {
            this.isNotEqualTo(Float.valueOf(Float.NaN));
        }
    }

    public static abstract class TolerantFloatComparison {
        private TolerantFloatComparison() {
        }

        public abstract void of(float var1);

        @Deprecated
        public boolean equals(@NullableDecl Object o) {
            throw new UnsupportedOperationException("If you meant to compare floats, use .of(float) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

