/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.AssertionErrorWithFacts;
import com.google.common.truth.ComparisonFailureWithFacts;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.JUnitComparisonFailure;
import com.google.common.truth.LazyMessage;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.common.truth.Truth;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class FailureMetadata {
    private final FailureStrategy strategy;
    private final ImmutableList<LazyMessage> messages;
    private final ImmutableList<Step> steps;

    static FailureMetadata forFailureStrategy(FailureStrategy failureStrategy) {
        return new FailureMetadata(failureStrategy, ImmutableList.of(), ImmutableList.of());
    }

    FailureMetadata(FailureStrategy strategy, ImmutableList<LazyMessage> messages, ImmutableList<Step> steps) {
        this.strategy = Preconditions.checkNotNull(strategy);
        this.messages = Preconditions.checkNotNull(messages);
        this.steps = Preconditions.checkNotNull(steps);
    }

    FailureMetadata updateForSubject(Subject<?, ?> subject) {
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.subjectCreation(subject));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall() {
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(null, null));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall(OldAndNewValuesAreSimilar valuesAreSimilar, Function<String, String> descriptionUpdate) {
        Preconditions.checkNotNull(descriptionUpdate);
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(valuesAreSimilar, descriptionUpdate));
        return this.derive(this.messages, steps);
    }

    FailureMetadata withMessage(String format, Object[] args) {
        ImmutableList<LazyMessage> messages = SubjectUtils.append(this.messages, new LazyMessage(format, args));
        return this.derive(messages, this.steps);
    }

    void failEqualityCheck(ImmutableList<Fact> headFacts, ImmutableList<Fact> tailFacts, String expected, String actual) {
        this.doFail((AssertionError)((Object)ComparisonFailureWithFacts.create(LazyMessage.evaluateAll(this.messages), SubjectUtils.concat(this.descriptionAsFacts(), headFacts), SubjectUtils.concat(tailFacts, this.rootUnlessThrowableAsFacts()), expected, actual, this.rootCause().orNull())));
    }

    void fail(ImmutableList<Fact> facts) {
        this.doFail(AssertionErrorWithFacts.create(LazyMessage.evaluateAll(this.messages), SubjectUtils.concat(this.descriptionAsFacts(), facts, this.rootUnlessThrowableAsFacts()), this.rootCause().orNull()));
    }

    void fail(String message) {
        this.doFail(Truth.SimpleAssertionError.create(this.addToMessage(message), this.rootUnlessThrowableAsString(), this.rootCause().orNull()));
    }

    void fail(String message, Throwable cause) {
        this.doFail(Truth.SimpleAssertionError.create(this.addToMessage(message), this.rootUnlessThrowableAsString(), cause));
    }

    void failComparing(String message, CharSequence expected, CharSequence actual) {
        this.doFail((AssertionError)((Object)new JUnitComparisonFailure(this.addToMessage(message), expected.toString(), actual.toString(), this.rootUnlessThrowableAsString(), this.rootCause().orNull())));
    }

    void failComparing(String message, CharSequence expected, CharSequence actual, Throwable cause) {
        this.doFail((AssertionError)((Object)new JUnitComparisonFailure(this.addToMessage(message), expected.toString(), actual.toString(), this.rootUnlessThrowableAsString(), cause)));
    }

    private void doFail(AssertionError failure) {
        Platform.cleanStackTrace((Throwable)((Object)failure));
        this.strategy.fail(failure);
    }

    private String addToMessage(String body) {
        ImmutableList<?> messages = this.allPrefixMessages();
        StringBuilder result = new StringBuilder(body.length());
        Joiner.on("\n").appendTo(result, (Iterable<?>)messages);
        if (!messages.isEmpty()) {
            result.append("\n");
        }
        result.append(body);
        return result.toString();
    }

    private ImmutableList<?> allPrefixMessages() {
        return SubjectUtils.concat(this.messages, this.descriptionAsStrings());
    }

    private FailureMetadata derive(ImmutableList<LazyMessage> messages, ImmutableList<Step> steps) {
        return new FailureMetadata(this.strategy, messages, steps);
    }

    private Optional<Fact> description() {
        String description = null;
        boolean descriptionWasDerived = false;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                Preconditions.checkState(description != null);
                if (step.descriptionUpdate == null) {
                    description = null;
                    descriptionWasDerived = false;
                    continue;
                }
                description = Verify.verifyNotNull(step.descriptionUpdate.apply(description));
                descriptionWasDerived = true;
                continue;
            }
            if (description != null) continue;
            description = MoreObjects.firstNonNull(step.subject.internalCustomName(), step.subject.typeDescription());
        }
        return descriptionWasDerived ? Optional.of(Fact.fact("value of", description)) : Optional.absent();
    }

    private ImmutableList<Fact> descriptionAsFacts() {
        return ImmutableList.copyOf(this.description().asSet());
    }

    private Set<String> descriptionAsStrings() {
        return this.description().transform(Functions.toStringFunction()).asSet();
    }

    private Optional<Fact> rootUnlessThrowable() {
        Step rootSubject = null;
        boolean seenDerivation = false;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                seenDerivation |= step.descriptionUpdate != null && step.valuesAreSimilar == OldAndNewValuesAreSimilar.DIFFERENT;
                continue;
            }
            if (rootSubject != null) continue;
            if (step.subject.actual() instanceof Throwable) {
                return Optional.absent();
            }
            rootSubject = step;
        }
        return seenDerivation ? Optional.of(Fact.fact(rootSubject.subject.typeDescription() + " was", rootSubject.subject.actualAsStringNoBrackets())) : Optional.absent();
    }

    private ImmutableList<Fact> rootUnlessThrowableAsFacts() {
        return ImmutableList.copyOf(this.rootUnlessThrowable().asSet());
    }

    @NullableDecl
    private String rootUnlessThrowableAsString() {
        return this.rootUnlessThrowable().transform(Functions.toStringFunction()).orNull();
    }

    private Optional<Throwable> rootCause() {
        for (Step step : this.steps) {
            if (step.isCheckCall() || !(step.subject.actual() instanceof Throwable)) continue;
            return Optional.of((Throwable)step.subject.actual());
        }
        return Optional.absent();
    }

    static enum OldAndNewValuesAreSimilar {
        SIMILAR,
        DIFFERENT;

    }

    private static final class Step {
        @NullableDecl
        final Subject<?, ?> subject;
        @NullableDecl
        final Function<String, String> descriptionUpdate;
        @NullableDecl
        final OldAndNewValuesAreSimilar valuesAreSimilar;

        static Step subjectCreation(Subject<?, ?> subject) {
            return new Step(Preconditions.checkNotNull(subject), null, null);
        }

        static Step checkCall(OldAndNewValuesAreSimilar valuesAreSimilar, @NullableDecl Function<String, String> descriptionUpdate) {
            return new Step(null, descriptionUpdate, valuesAreSimilar);
        }

        private Step(@NullableDecl Subject<?, ?> subject, @NullableDecl Function<String, String> descriptionUpdate, @NullableDecl OldAndNewValuesAreSimilar valuesAreSimilar) {
            this.subject = subject;
            this.descriptionUpdate = descriptionUpdate;
            this.valuesAreSimilar = valuesAreSimilar;
        }

        boolean isCheckCall() {
            return this.subject == null;
        }
    }
}

