/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.MathUtil;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Correspondence<A, E> {
    public static Correspondence<Number, Number> tolerance(double tolerance) {
        return new TolerantNumericEquality(tolerance);
    }

    public abstract boolean compare(@NullableDecl A var1, @NullableDecl E var2);

    @NullableDecl
    public String formatDiff(@NullableDecl A actual, @NullableDecl E expected) {
        return null;
    }

    public abstract String toString();

    @Deprecated
    public final boolean equals(@NullableDecl Object o) {
        throw new UnsupportedOperationException("Correspondence.equals(object) is not supported. If you meant to compare objects, use .compare(actual, expected) instead.");
    }

    @Deprecated
    public final int hashCode() {
        throw new UnsupportedOperationException("Correspondence.hashCode() is not supported.");
    }

    private static final class TolerantNumericEquality
    extends Correspondence<Number, Number> {
        private final double tolerance;

        private TolerantNumericEquality(double tolerance) {
            this.tolerance = tolerance;
        }

        @Override
        public boolean compare(Number actual, Number expected) {
            DoubleSubject.checkTolerance(this.tolerance);
            double actualDouble = Preconditions.checkNotNull(actual).doubleValue();
            double expectedDouble = Preconditions.checkNotNull(expected).doubleValue();
            return MathUtil.equalWithinTolerance(actualDouble, expectedDouble, this.tolerance);
        }

        @Override
        public String toString() {
            return "is a finite number within " + this.tolerance + " of";
        }
    }
}

