/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.ErrorWithFacts;
import com.google.common.truth.Fact;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class AssertionErrorWithFacts
extends AssertionError
implements ErrorWithFacts {
    final ImmutableList<Fact> facts;
    @NullableDecl
    private final Throwable cause;

    static AssertionErrorWithFacts create(ImmutableList<String> messages, ImmutableList<Fact> facts, @NullableDecl Throwable cause) {
        return new AssertionErrorWithFacts(messages, facts, cause);
    }

    private AssertionErrorWithFacts(ImmutableList<String> messages, ImmutableList<Fact> facts, @NullableDecl Throwable cause) {
        super((Object)Fact.makeMessage(messages, facts));
        this.facts = Preconditions.checkNotNull(facts);
        this.cause = cause;
        try {
            this.initCause(cause);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        return this.getLocalizedMessage();
    }

    @Override
    public ImmutableList<Fact> facts() {
        return this.facts;
    }
}

