/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.statsd;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.os.StatsLog;
import com.android.tradefed.device.CollectingByteOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MetricUtil {
    @VisibleForTesting
    static final String DUMP_REPORT_CMD_TEMPLATE = "cmd stats dump-report %s %s --proto";
    @VisibleForTesting
    static final String DUMP_REPORT_INCLUDE_CURRENT_BUCKET = "--include_current_bucket";
    @VisibleForTesting
    static final String DUMP_STATSD_METADATA_CMD = "dumpsys stats --metadata --proto";
    @VisibleForTesting
    static final int SDK_VERSION_Q = 29;

    public static List<StatsLog.EventMetricData> getEventMetricData(ITestDevice device, long configId) throws DeviceNotAvailableException {
        StatsLog.ConfigMetricsReportList reports = MetricUtil.getReportList(device, configId);
        if (reports.getReportsList().isEmpty()) {
            LogUtil.CLog.d((String)"No stats report collected.");
            return new ArrayList<StatsLog.EventMetricData>();
        }
        ArrayList<StatsLog.EventMetricData> data = new ArrayList<StatsLog.EventMetricData>();
        for (StatsLog.ConfigMetricsReport report : reports.getReportsList()) {
            for (StatsLog.StatsLogReport metric : report.getMetricsList()) {
                data.addAll(metric.getEventMetrics().getDataList());
            }
        }
        data.sort(Comparator.comparing(StatsLog.EventMetricData::getElapsedTimestampNanos));
        LogUtil.CLog.d((String)"Received EventMetricDataList as following:\n");
        for (StatsLog.EventMetricData d : data) {
            LogUtil.CLog.d((String)"Atom at %d:\n%s", (Object[])new Object[]{d.getElapsedTimestampNanos(), d.getAtom().toString()});
        }
        return data;
    }

    public static InputStreamSource getReportByteStream(ITestDevice device, long configId) throws DeviceNotAvailableException {
        return new ByteArrayInputStreamSource(MetricUtil.getReportByteArray(device, configId));
    }

    public static StatsLog.StatsdStatsReport getStatsdMetadata(ITestDevice device) throws DeviceNotAvailableException, InvalidProtocolBufferException {
        CollectingByteOutputReceiver receiver = new CollectingByteOutputReceiver();
        device.executeShellCommand(DUMP_STATSD_METADATA_CMD, (IShellOutputReceiver)receiver);
        return (StatsLog.StatsdStatsReport)StatsLog.StatsdStatsReport.parser().parseFrom(receiver.getOutput());
    }

    private static StatsLog.ConfigMetricsReportList getReportList(ITestDevice device, long configId) throws DeviceNotAvailableException {
        try {
            byte[] output = MetricUtil.getReportByteArray(device, configId);
            return (StatsLog.ConfigMetricsReportList)StatsLog.ConfigMetricsReportList.parser().parseFrom(output);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getReportByteArray(ITestDevice device, long configId) throws DeviceNotAvailableException {
        CollectingByteOutputReceiver receiver = new CollectingByteOutputReceiver();
        String dumpCommand = String.format(DUMP_REPORT_CMD_TEMPLATE, String.valueOf(configId), device.checkApiLevelAgainstNextRelease(29) ? DUMP_REPORT_INCLUDE_CURRENT_BUCKET : "");
        LogUtil.CLog.d((String)("Dumping stats report with command: " + dumpCommand));
        device.executeShellCommand(dumpCommand, (IShellOutputReceiver)receiver);
        return receiver.getOutput();
    }
}

