/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.clockwork;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.util.List;
import java.util.Map;

public class ClockworkUtils {
    public ITestDevice setUpMultiDevice(Map<ITestDevice, IBuildInfo> deviceInfos, List<ITestDevice> deviceList) {
        ITestDevice companion = null;
        if (deviceInfos.size() < 2) {
            throw new RuntimeException("there should be at least two devices for clockwork multiple device test");
        }
        for (Map.Entry<ITestDevice, IBuildInfo> entry : deviceInfos.entrySet()) {
            try {
                String deviceBuildPropertyString = entry.getKey().getProperty("ro.build.characteristics");
                if (deviceBuildPropertyString.contains("watch")) {
                    deviceList.add(entry.getKey());
                    continue;
                }
                if (companion != null) {
                    throw new RuntimeException("there should be only one companion in the test");
                }
                companion = entry.getKey();
            }
            catch (DeviceNotAvailableException e) {
                throw new RuntimeException("device not available, cannot get device build property to determine companion/watch device");
            }
        }
        if (companion == null) {
            throw new RuntimeException("no companion device found in the test");
        }
        return companion;
    }
}

