/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RustTestResultParser
extends MultiLineReceiver {
    private String mCurrentTestFile;
    private String mCurrentTestName;
    private String mCurrentTestStatus;
    private Matcher mCurrentMatcher;
    private Collection<ITestInvocationListener> mListeners = new ArrayList<ITestInvocationListener>();
    private Map<TestDescription, String> mTestResultCache;
    static final String SKIPPED_ENTRY = "Skipped";
    static final String FAILED_ENTRY = "FailedNoStack";
    static final Pattern COMPLETE_PATTERN = Pattern.compile("test result: (.*) (\\d+) passed; (\\d+) failed; (\\d+) ignored;.*");
    static final Pattern RUST_ONE_LINE_RESULT = Pattern.compile("test (\\S*) \\.\\.\\. (\\S*)");

    public RustTestResultParser(ITestInvocationListener listener, String runName) {
        this(Arrays.asList(listener), runName);
    }

    public RustTestResultParser(Collection<ITestInvocationListener> listeners, String runName) {
        this.mListeners.addAll(listeners);
        this.mCurrentTestFile = runName;
        this.mTestResultCache = new HashMap<TestDescription, String>();
    }

    public void processNewLines(String[] lines) {
        try {
            boolean hasContent = false;
            for (String line : lines) {
                hasContent |= line.length() > 0;
                if (this.lineMatchesPattern(line, COMPLETE_PATTERN)) {
                    this.reportToListeners(line);
                    return;
                }
                if (!this.lineMatchesPattern(line, RUST_ONE_LINE_RESULT)) continue;
                this.mCurrentTestName = this.mCurrentMatcher.group(1);
                this.mCurrentTestStatus = this.mCurrentMatcher.group(2);
                this.reportTestResult();
            }
            if (hasContent) {
                throw new Exception(String.format("Missing summary line:\n%s\n", String.join((CharSequence)"\n", lines)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse Rust test result\n" + e);
        }
    }

    int processRunSummary(String line) {
        try {
            if (!this.lineMatchesPattern(line, COMPLETE_PATTERN)) {
                throw new RuntimeException("Failed to parse summary line: " + line);
            }
            int passed = Integer.parseInt(this.mCurrentMatcher.group(2));
            int failed = Integer.parseInt(this.mCurrentMatcher.group(3));
            int ignored = Integer.parseInt(this.mCurrentMatcher.group(4));
            return passed + failed + ignored;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse number in " + line);
        }
    }

    private boolean lineMatchesPattern(String line, Pattern p) {
        this.mCurrentMatcher = p.matcher(line);
        return this.mCurrentMatcher.matches();
    }

    private void reportToListeners(String line) {
        for (ITestInvocationListener listener : this.mListeners) {
            for (Map.Entry<TestDescription, String> test : this.mTestResultCache.entrySet()) {
                listener.testStarted(test.getKey());
                if (SKIPPED_ENTRY.equals(test.getValue())) {
                    listener.testIgnored(test.getKey());
                } else if (FAILED_ENTRY.equals(test.getValue())) {
                    listener.testFailed(test.getKey(), "");
                } else if (test.getValue() != null) {
                    listener.testFailed(test.getKey(), test.getValue());
                }
                listener.testEnded(test.getKey(), new HashMap());
            }
        }
    }

    private void reportTestResult() {
        TestDescription testId = new TestDescription(this.mCurrentTestFile, this.mCurrentTestName);
        if (this.mCurrentTestStatus.equals("ok")) {
            this.mTestResultCache.put(testId, null);
        } else if (this.mCurrentTestStatus.equals("ignored")) {
            this.mTestResultCache.put(testId, SKIPPED_ENTRY);
        } else if (this.mCurrentTestStatus.equals("FAILED")) {
            this.mTestResultCache.put(testId, FAILED_ENTRY);
        } else {
            this.mTestResultCache.put(testId, this.mCurrentTestStatus);
        }
    }

    public boolean isCancelled() {
        return false;
    }
}

