/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.mobly.IMoblyYamlResultHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultControllerInfoHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import com.android.tradefed.testtype.mobly.MoblyYamlResultRecordHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultSummaryHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultUserDataHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class MoblyYamlResultParser {
    private static final String TYPE = "Type";
    private ImmutableList.Builder<ITestInvocationListener> mListenersBuilder = new ImmutableList.Builder();
    private final String mRunName;
    private ImmutableList.Builder<IMoblyYamlResultHandler.ITestResult> mResultCacheBuilder = new ImmutableList.Builder();
    private int mTestCount;
    private long mRunStartTime;
    private long mRunEndTime;

    public MoblyYamlResultParser(ITestInvocationListener listener, String runName) {
        this.mListenersBuilder.add((Object)listener);
        this.mRunName = runName;
    }

    public void parse(InputStream inputStream) throws MoblyYamlResultHandlerFactory.InvalidResultTypeException, IllegalAccessException, InstantiationException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        for (Object doc : yaml.loadAll(inputStream)) {
            Map docMap = (Map)doc;
            this.mResultCacheBuilder.add((Object)this.parseDocumentMap(docMap));
        }
        this.reportToListeners((List<ITestInvocationListener>)((Object)this.mListenersBuilder.build()), (List<IMoblyYamlResultHandler.ITestResult>)((Object)this.mResultCacheBuilder.build()));
    }

    @VisibleForTesting
    protected IMoblyYamlResultHandler.ITestResult parseDocumentMap(Map<String, Object> docMap) throws MoblyYamlResultHandlerFactory.InvalidResultTypeException, IllegalAccessException, InstantiationException {
        LogUtil.CLog.i((String)"Parsed object: %s", (Object[])new Object[]{docMap.toString()});
        String docType = String.valueOf(docMap.get(TYPE));
        LogUtil.CLog.d((String)"Parsing result type: %s", (Object[])new Object[]{docType});
        IMoblyYamlResultHandler resultHandler = new MoblyYamlResultHandlerFactory().getHandler(docType);
        IMoblyYamlResultHandler.ITestResult testResult = resultHandler.handle(docMap);
        if ("Summary".equals(docType)) {
            this.mTestCount = ((MoblyYamlResultSummaryHandler.Summary)testResult).getExecuted();
        }
        return testResult;
    }

    @VisibleForTesting
    protected void reportToListeners(List<ITestInvocationListener> listeners, List<IMoblyYamlResultHandler.ITestResult> resultCache) {
        for (ITestInvocationListener listener : listeners) {
            listener.testRunStarted(this.mRunName, this.mTestCount);
        }
        block7: for (IMoblyYamlResultHandler.ITestResult result : resultCache) {
            switch (result.getType()) {
                case RECORD: {
                    MoblyYamlResultRecordHandler.Record record = (MoblyYamlResultRecordHandler.Record)result;
                    TestDescription testDescription = new TestDescription(record.getTestClass(), record.getTestName());
                    FailureDescription failureDescription = FailureDescription.create((String)record.getStackTrace(), (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
                    this.mRunStartTime = this.mRunStartTime == 0L ? record.getBeginTime() : Math.min(this.mRunStartTime, record.getBeginTime());
                    this.mRunEndTime = Math.max(this.mRunEndTime, record.getEndTime());
                    for (ITestInvocationListener listener : listeners) {
                        listener.testStarted(testDescription, record.getBeginTime());
                        if (record.getResult() != MoblyYamlResultRecordHandler.RecordResult.PASS) {
                            listener.testFailed(testDescription, failureDescription);
                        }
                        listener.testEnded(testDescription, record.getEndTime(), new HashMap());
                    }
                    continue block7;
                }
                case USER_DATA: {
                    long timestamp = ((MoblyYamlResultUserDataHandler.UserData)result).getTimeStamp();
                    this.mRunStartTime = this.mRunStartTime == 0L ? timestamp : Math.min(this.mRunStartTime, timestamp);
                    break;
                }
                case CONTROLLER_INFO: {
                    this.mRunEndTime = Math.max(this.mRunEndTime, ((MoblyYamlResultControllerInfoHandler.ControllerInfo)result).getTimeStamp());
                    break;
                }
                case TEST_NAME_LIST: {
                    break;
                }
            }
        }
        for (ITestInvocationListener listener : listeners) {
            listener.testRunEnded(this.mRunEndTime - this.mRunStartTime, new HashMap());
        }
    }
}

