/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.testtype.mobly.IMoblyYamlResultHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultControllerInfoHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultRecordHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultSummaryHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultTestNameListHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultUserDataHandler;

public class MoblyYamlResultHandlerFactory {
    public IMoblyYamlResultHandler getHandler(String resultType) throws InvalidResultTypeException, IllegalAccessException, InstantiationException {
        IMoblyYamlResultHandler resultHandler;
        switch (resultType) {
            case "Record": {
                resultHandler = (IMoblyYamlResultHandler)Type.RECORD.getHandlerInstance();
                break;
            }
            case "UserData": {
                resultHandler = (IMoblyYamlResultHandler)Type.USER_DATA.getHandlerInstance();
                break;
            }
            case "TestNameList": {
                resultHandler = (IMoblyYamlResultHandler)Type.TEST_NAME_LIST.getHandlerInstance();
                break;
            }
            case "ControllerInfo": {
                resultHandler = (IMoblyYamlResultHandler)Type.CONTROLLER_INFO.getHandlerInstance();
                break;
            }
            case "Summary": {
                resultHandler = (IMoblyYamlResultHandler)Type.SUMMARY.getHandlerInstance();
                break;
            }
            default: {
                throw new InvalidResultTypeException("Invalid mobly test result type: " + resultType);
            }
        }
        return resultHandler;
    }

    public static enum Type {
        RECORD("Record", MoblyYamlResultRecordHandler.class),
        USER_DATA("UserData", MoblyYamlResultUserDataHandler.class),
        TEST_NAME_LIST("TestNameList", MoblyYamlResultTestNameListHandler.class),
        CONTROLLER_INFO("ControllerInfo", MoblyYamlResultControllerInfoHandler.class),
        SUMMARY("Summary", MoblyYamlResultSummaryHandler.class);

        private String tag;
        private Class handlerClass;

        private Type(String tag, Class handlerClass) {
            this.tag = tag;
            this.handlerClass = handlerClass;
        }

        public String getTag() {
            return this.tag;
        }

        public <T> T getHandlerInstance() throws IllegalAccessException, InstantiationException {
            return this.handlerClass.newInstance();
        }
    }

    public class InvalidResultTypeException
    extends Exception {
        public InvalidResultTypeException(String errorMsg) {
            super(errorMsg);
        }
    }
}

