/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import com.android.tradefed.testtype.mobly.MoblyYamlResultParser;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

@OptionClass(alias="mobly-host")
public class MoblyBinaryHostTest
implements IRemoteTest,
IDeviceTest,
IBuildReceiver,
IInvocationContextReceiver {
    private static final String ANDROID_SERIAL_VAR = "ANDROID_SERIAL";
    private static final String PATH_VAR = "PATH";
    private static final long PATH_TIMEOUT_MS = 60000L;
    private static final String MOBLY_TEST_SUMMARY = "test_summary.yaml";
    private static final String MOBLY_TEST_SUMMARY_XML = "converted_test_summary.xml";
    @Option(name="par-file-name", description="The binary names inside the build info to run.")
    private Set<String> mBinaryNames = new HashSet<String>();
    @Option(name="python-binaries", description="The full path to a runnable python binary. Can be repeated.")
    private Set<File> mBinaries = new HashSet<File>();
    @Option(name="test-timeout", description="Timeout for a single par file to terminate.", isTimeVal=true)
    private long mTestTimeout = 20000L;
    @Option(name="inject-android-serial", description="Whether or not to pass a ANDROID_SERIAL variable to the process.")
    private boolean mInjectAndroidSerialVar = true;
    @Option(name="python-options", description="Option string to be passed to the binary when running")
    private List<String> mTestOptions = new ArrayList<String>();
    @Option(name="mobly-config-file", description="Mobly config file absolute path.If set, will append '--config=<config file path>' to the command for running binary.")
    private File mConfigFile;
    @Option(name="test-bed", description="Name of the test bed to run the tests.If set, will append '--test_bed=<test bed name>' to the command for running binary.")
    private String mTestBed;
    private ITestDevice mDevice;
    private IBuildInfo mBuildInfo;
    private IInvocationContext mContext;
    private File mLogDir;
    private IRunUtil mRunUtil;

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mContext = invocationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(ITestInvocationListener listener) {
        List<File> parFilesList = this.findParFiles();
        for (File parFile : parFilesList) {
            if (!parFile.exists()) {
                LogUtil.CLog.d((String)"ignoring %s which doesn't look like a test file.", (Object[])new Object[]{parFile.getAbsolutePath()});
                continue;
            }
            parFile.setExecutable(true);
            try {
                this.runSingleParFile(listener, parFile.getAbsolutePath());
                this.processTestResults(listener, parFile.getName());
            }
            finally {
                this.reportLogs(this.getLogDir(), listener);
            }
        }
    }

    private List<File> findParFiles() {
        File testsDir = null;
        if (this.mBuildInfo instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)this.mBuildInfo).getTestsDir();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String binaryName : this.mBinaryNames) {
            File res = null;
            if (testsDir != null) {
                res = FileUtil.findFile((File)testsDir, (String)binaryName);
            }
            if (res == null) {
                throw new RuntimeException(String.format("Couldn't find a par file %s", binaryName));
            }
            files.add(res);
        }
        files.addAll(this.mBinaries);
        return files;
    }

    private void runSingleParFile(ITestInvocationListener listener, String parFilePath) {
        CommandResult result;
        if (this.mInjectAndroidSerialVar) {
            this.getRunUtil().setEnvVariable(ANDROID_SERIAL_VAR, this.getDevice().getSerialNumber());
        }
        this.updateAdb();
        if (this.mConfigFile != null) {
            this.updateConfigFile();
        }
        if (!CommandStatus.SUCCESS.equals((Object)(result = this.getRunUtil().runTimedCmd(this.getTestTimeout(), this.buildCommandLineArray(parFilePath))).getStatus())) {
            LogUtil.CLog.e((String)"Something went wrong when running the python binary:\nstdout: %s\nstderr:%s\nStatus:%s", (Object[])new Object[]{result.getStdout(), result.getStderr(), result.getStatus()});
        }
    }

    private void updateAdb() {
        String adbPath;
        File updatedAdb = this.mBuildInfo.getFile("adb_path");
        if (updatedAdb == null && !(adbPath = this.getAdbPath()).equals("adb") && !(updatedAdb = new File(adbPath)).exists()) {
            updatedAdb = null;
        }
        if (updatedAdb != null) {
            LogUtil.CLog.d((String)"Testing with adb binary at: %s", (Object[])new Object[]{updatedAdb});
            CommandResult pathResult = this.getRunUtil().runTimedCmd(60000L, new String[]{"/bin/bash", "-c", "echo $PATH"});
            if (!CommandStatus.SUCCESS.equals((Object)pathResult.getStatus())) {
                throw new RuntimeException(String.format("Failed to get the $PATH. status: %s, stdout: %s, stderr: %s", pathResult.getStatus(), pathResult.getStdout(), pathResult.getStderr()));
            }
            String path = String.format("%s:%s", updatedAdb.getParentFile().getAbsolutePath(), pathResult.getStdout().trim());
            LogUtil.CLog.d((String)"Using $PATH with updated adb: %s", (Object[])new Object[]{path});
            this.getRunUtil().setEnvVariable(PATH_VAR, path);
            CommandResult versionRes = this.getRunUtil().runTimedCmd(60000L, new String[]{"adb", "version"});
            LogUtil.CLog.d((String)"%s", (Object[])new Object[]{versionRes.getStdout()});
            LogUtil.CLog.d((String)"%s", (Object[])new Object[]{versionRes.getStderr()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTestResults(ITestInvocationListener listener, String runName) {
        File yamlSummaryFile = FileUtil.findFile((File)this.getLogDir(), (String)MOBLY_TEST_SUMMARY);
        if (yamlSummaryFile == null) {
            throw new RuntimeException(String.format("Fail to find test summary file %s under directory %s", MOBLY_TEST_SUMMARY, this.getLogDir()));
        }
        MoblyYamlResultParser parser = new MoblyYamlResultParser(listener, runName);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(yamlSummaryFile);
            this.processYamlTestResults(inputStream, parser);
        }
        catch (FileNotFoundException ex) {
            try {
                LogUtil.CLog.e((String)"Fail processing test results: ", (Object[])new Object[]{ex});
            }
            catch (Throwable throwable) {
                StreamUtil.close(inputStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)inputStream);
        }
        StreamUtil.close((Closeable)inputStream);
    }

    protected void processYamlTestResults(InputStream inputStream, MoblyYamlResultParser parser) {
        try {
            parser.parse(inputStream);
        }
        catch (MoblyYamlResultHandlerFactory.InvalidResultTypeException | IllegalAccessException | InstantiationException ex) {
            LogUtil.CLog.e((String)"Failed to parse result file: %s", (Object[])new Object[]{ex});
        }
    }

    private void updateConfigFile() {
        FileInputStream inputStream = null;
        FileWriter fileWriter = null;
        File localConfigFile = new File(this.getLogDir(), "local_config.yaml");
        try {
            inputStream = new FileInputStream(this.mConfigFile);
            fileWriter = new FileWriter(localConfigFile);
            this.updateConfigFile(inputStream, fileWriter, this.getDevice().getSerialNumber());
            this.mConfigFile = localConfigFile;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException("Exception in updating config file: %s", ex);
            }
            catch (Throwable throwable) {
                StreamUtil.close(inputStream);
                StreamUtil.close(fileWriter);
                throw throwable;
            }
        }
        StreamUtil.close((Closeable)inputStream);
        StreamUtil.close((Closeable)fileWriter);
    }

    protected void updateConfigFile(InputStream configInputStream, Writer writer, String serial) {
        Yaml yaml = new Yaml();
        Map configMap = (Map)yaml.load(configInputStream);
        LogUtil.CLog.d((String)"Loaded yaml config: \n%s", (Object[])new Object[]{configMap});
        List testBedList = (List)configMap.get("TestBeds");
        Map targetTb = null;
        if (this.getTestBed() == null) {
            targetTb = (Map)testBedList.get(0);
        } else {
            for (Object tb : testBedList) {
                Map tbMap = (Map)tb;
                String tbName = (String)tbMap.get("Name");
                if (!tbName.equalsIgnoreCase(this.getTestBed())) continue;
                targetTb = tbMap;
                break;
            }
        }
        if (targetTb == null) {
            throw new RuntimeException(String.format("Fail to find specified test bed: %s.", this.getTestBed()));
        }
        Map controllerMap = (Map)targetTb.get("Controllers");
        List androidDeviceList = (List)controllerMap.get("AndroidDevice");
        Map deviceMap = (Map)androidDeviceList.get(0);
        deviceMap.put("serial", serial);
        yaml.dump((Object)configMap, writer);
    }

    private File getLogDir() {
        if (this.mLogDir == null) {
            try {
                this.mLogDir = FileUtil.createTempDir((String)"host_tmp_mobly");
            }
            catch (IOException ex) {
                LogUtil.CLog.e((String)"Failed to create temp dir with prefix host_tmp_mobly: %s", (Object[])new Object[]{ex});
            }
            LogUtil.CLog.d((String)"Mobly log path: %s", (Object[])new Object[]{this.mLogDir.getAbsolutePath()});
        }
        return this.mLogDir;
    }

    String getLogDirAbsolutePath() {
        return this.getLogDir().getAbsolutePath();
    }

    String getTestBed() {
        return this.mTestBed;
    }

    protected String[] buildCommandLineArray(String filePath) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(filePath);
        commandLine.add("--");
        if (this.getConfigPath() != null) {
            commandLine.add("--config=" + this.getConfigPath());
        }
        if (this.getTestBed() != null) {
            commandLine.add("--test_bed=" + this.getTestBed());
        }
        commandLine.add("--device_serial=" + this.getDevice().getSerialNumber());
        commandLine.add("--log_path=" + this.getLogDirAbsolutePath());
        commandLine.addAll(this.getTestOptions());
        return commandLine.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportLogs(File logDir, ITestInvocationListener listener) {
        for (File subFile : logDir.listFiles()) {
            if (subFile.isDirectory()) {
                this.reportLogs(subFile, listener);
                continue;
            }
            FileInputStreamSource dataStream = null;
            try {
                dataStream = new FileInputStreamSource(subFile, true);
                listener.testLog(subFile.getName(), LogDataType.TEXT, (InputStreamSource)dataStream);
            }
            catch (Throwable throwable) {
                StreamUtil.close(dataStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)dataStream);
        }
        FileUtil.deleteFile((File)logDir);
    }

    String getConfigPath() {
        if (this.mConfigFile != null) {
            return this.mConfigFile.getAbsolutePath();
        }
        return null;
    }

    List<String> getTestOptions() {
        return this.mTestOptions;
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    String getAdbPath() {
        return GlobalConfiguration.getDeviceManagerInstance().getAdbPath();
    }

    long getTestTimeout() {
        return this.mTestTimeout;
    }
}

