/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.DeviceJUnit4ClassRunner;
import com.android.tradefed.testtype.MetricTestCase;
import com.android.tradefed.testtype.junit4.CarryDnaeError;
import com.android.tradefed.util.StreamUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.MultipleFailureException;

public class JUnit4ResultForwarder
extends RunListener {
    private ITestInvocationListener mListener;
    private List<Throwable> mTestCaseFailures;

    public JUnit4ResultForwarder(ITestInvocationListener listener) {
        this.mListener = listener;
        this.mTestCaseFailures = new ArrayList<Throwable>();
    }

    public void testFailure(Failure failure) throws Exception {
        Description description = failure.getDescription();
        if (description.getMethodName() == null) {
            String trace = failure.getTrace();
            if (failure.getException() instanceof CarryDnaeError) {
                trace = StreamUtil.getStackTrace((Throwable)((CarryDnaeError)failure.getException()).getDeviceNotAvailableException());
            }
            this.mListener.testRunFailed(String.format("Failed with trace: %s", trace));
            if (failure.getException() instanceof CarryDnaeError) {
                throw ((CarryDnaeError)failure.getException()).getDeviceNotAvailableException();
            }
            return;
        }
        this.mTestCaseFailures.add(failure.getException());
    }

    public void testAssumptionFailure(Failure failure) {
        this.mTestCaseFailures.add(failure.getException());
    }

    public void testStarted(Description description) throws Exception {
        this.mTestCaseFailures.clear();
        TestDescription testid = new TestDescription(description.getClassName(), description.getMethodName(), description.getAnnotations());
        this.mListener.testStarted(testid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        HashMap<String, MetricMeasurement.Metric> metrics;
        TestDescription testid = new TestDescription(description.getClassName(), description.getMethodName(), description.getAnnotations());
        try {
            this.handleFailures(testid);
            metrics = new HashMap<String, MetricMeasurement.Metric>();
        }
        catch (Throwable throwable) {
            HashMap<String, MetricMeasurement.Metric> metrics2 = new HashMap<String, MetricMeasurement.Metric>();
            for (Description child : description.getChildren()) {
                for (Annotation a : child.getAnnotations()) {
                    if (a instanceof DeviceJUnit4ClassRunner.MetricAnnotation) {
                        metrics2.putAll(((DeviceJUnit4ClassRunner.MetricAnnotation)a).mMetrics);
                    }
                    if (!(a instanceof DeviceJUnit4ClassRunner.LogAnnotation)) continue;
                    for (MetricTestCase.LogHolder log : ((DeviceJUnit4ClassRunner.LogAnnotation)a).mLogs) {
                        this.mListener.testLog(log.mDataName, log.mDataType, log.mDataStream);
                        StreamUtil.cancel((InputStreamSource)log.mDataStream);
                    }
                    ((DeviceJUnit4ClassRunner.LogAnnotation)a).mLogs.clear();
                }
            }
            this.mListener.testEnded(testid, metrics2);
            throw throwable;
        }
        for (Description child : description.getChildren()) {
            for (Annotation a : child.getAnnotations()) {
                if (a instanceof DeviceJUnit4ClassRunner.MetricAnnotation) {
                    metrics.putAll(((DeviceJUnit4ClassRunner.MetricAnnotation)a).mMetrics);
                }
                if (!(a instanceof DeviceJUnit4ClassRunner.LogAnnotation)) continue;
                for (MetricTestCase.LogHolder log : ((DeviceJUnit4ClassRunner.LogAnnotation)a).mLogs) {
                    this.mListener.testLog(log.mDataName, log.mDataType, log.mDataStream);
                    StreamUtil.cancel((InputStreamSource)log.mDataStream);
                }
                ((DeviceJUnit4ClassRunner.LogAnnotation)a).mLogs.clear();
            }
        }
        this.mListener.testEnded(testid, metrics);
    }

    public void testIgnored(Description description) throws Exception {
        TestDescription testid = new TestDescription(description.getClassName(), description.getMethodName(), description.getAnnotations());
        this.mListener.testStarted(testid);
        this.mListener.testIgnored(testid);
        this.mListener.testEnded(testid, new HashMap());
    }

    private void handleFailures(TestDescription testid) {
        if (this.mTestCaseFailures.isEmpty()) {
            return;
        }
        if (this.mTestCaseFailures.size() == 1) {
            Throwable t = this.mTestCaseFailures.get(0);
            if (t instanceof AssumptionViolatedException) {
                this.mListener.testAssumptionFailure(testid, StreamUtil.getStackTrace((Throwable)t));
            } else {
                this.mListener.testFailed(testid, StreamUtil.getStackTrace((Throwable)t));
            }
        } else {
            MultipleFailureException multiException = new MultipleFailureException(this.mTestCaseFailures);
            this.mListener.testFailed(testid, this.getMultiFailureStack(multiException));
        }
    }

    private String getMultiFailureStack(MultipleFailureException multiException) {
        StringBuilder sb = new StringBuilder(String.format("MultipleFailureException, There were %d errors:", multiException.getFailures().size()));
        for (Throwable e : multiException.getFailures()) {
            sb.append(String.format("\n  %s", StreamUtil.getStackTrace((Throwable)e)));
        }
        return sb.toString();
    }
}

