/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.ddmlib.DefaultRemoteAndroidTestRunner;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.suite.SuiteApkInstaller;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.testtype.junit4.DeviceTestRunOptions;
import com.android.tradefed.util.ListInstrumentationParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;

public abstract class BaseHostJUnit4Test
implements IAbiReceiver,
ITestInformationReceiver {
    static final long DEFAULT_TEST_TIMEOUT_MS = 600000L;
    private static final long DEFAULT_MAX_TIMEOUT_TO_OUTPUT_MS = 600000L;
    private static final Map<String, String> DEFAULT_INSTRUMENTATION_ARGS = new HashMap<String, String>();
    private IAbi mAbi;
    private TestInformation mTestInfo;
    private Map<SuiteApkInstaller, ITestDevice> mInstallers = new LinkedHashMap<SuiteApkInstaller, ITestDevice>();
    private TestRunResult mLatestInstruRes;

    public final ITestDevice getDevice() {
        return this.mTestInfo.getDevice();
    }

    public final IBuildInfo getBuild() {
        return this.mTestInfo.getBuildInfo();
    }

    public final void setTestInformation(TestInformation testInformation) {
        this.mTestInfo = testInformation;
    }

    public TestInformation getTestInformation() {
        return this.mTestInfo;
    }

    public final void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public final IAbi getAbi() {
        return this.mAbi;
    }

    public final IInvocationContext getInvocationContext() {
        return this.mTestInfo.getContext();
    }

    public final List<ITestDevice> getListDevices() {
        return this.mTestInfo.getContext().getDevices();
    }

    @After
    public final void autoTearDown() throws DeviceNotAvailableException {
        this.mLatestInstruRes = null;
        for (SuiteApkInstaller installer : this.mInstallers.keySet()) {
            installer.tearDown(this.mTestInfo, null);
        }
        this.mInstallers.clear();
    }

    public final void installPackage(String apkFileName, String ... options) throws DeviceNotAvailableException, TargetSetupError {
        this.installPackage(this.getDevice(), apkFileName, options);
    }

    public final void installPackage(ITestDevice device, String apkFileName, String ... options) throws DeviceNotAvailableException, TargetSetupError {
        SuiteApkInstaller installer = this.createSuiteApkInstaller();
        installer.setCleanApk(true);
        this.mInstallers.put(installer, device);
        installer.addTestFileName(apkFileName);
        installer.setAbi(this.getAbi());
        for (String option : options) {
            installer.addInstallArg(option);
        }
        try {
            installer.setUp(this.mTestInfo);
        }
        catch (BuildError e) {
            throw new TargetSetupError(e.getMessage(), (Throwable)e, device.getDeviceDescriptor(), e.getErrorId());
        }
    }

    public final void installPackageAsUser(String apkFileName, boolean grantPermission, int userId, String ... options) throws DeviceNotAvailableException, TargetSetupError {
        this.installPackageAsUser(this.getDevice(), apkFileName, grantPermission, userId, options);
    }

    public final void installPackageAsUser(ITestDevice device, String apkFileName, boolean grantPermission, int userId, String ... options) throws DeviceNotAvailableException, TargetSetupError {
        SuiteApkInstaller installer = this.createSuiteApkInstaller();
        installer.setCleanApk(true);
        this.mInstallers.put(installer, device);
        installer.addTestFileName(apkFileName);
        installer.setUserId(userId);
        installer.setShouldGrantPermission(grantPermission);
        installer.setAbi(this.getAbi());
        for (String option : options) {
            installer.addInstallArg(option);
        }
        try {
            installer.setUp(this.mTestInfo);
        }
        catch (BuildError e) {
            throw new TargetSetupError(e.getMessage(), (Throwable)e, device.getDeviceDescriptor(), e.getErrorId());
        }
    }

    public final boolean runDeviceTests(String pkgName, String testClassName) throws DeviceNotAvailableException {
        return this.runDeviceTests(this.getDevice(), pkgName, testClassName, null);
    }

    public final boolean runDeviceTests(String pkgName, String testClassName, Long testTimeoutMs) throws DeviceNotAvailableException {
        return this.runDeviceTests(this.getDevice(), null, pkgName, testClassName, null, null, testTimeoutMs, 600000L, 0L, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(String pkgName, String testClassName, Integer userId, Long testTimeoutMs) throws DeviceNotAvailableException {
        return this.runDeviceTests(this.getDevice(), null, pkgName, testClassName, null, userId, testTimeoutMs, 600000L, 0L, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(String pkgName, String testClassName, String testMethodName) throws DeviceNotAvailableException {
        return this.runDeviceTests(this.getDevice(), pkgName, testClassName, testMethodName);
    }

    public final boolean runDeviceTests(String runner, String pkgName, String testClassName, String testMethodName) throws DeviceNotAvailableException {
        return this.runDeviceTests(this.getDevice(), runner, pkgName, testClassName, testMethodName, null, 600000L, 600000L, 0L, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(ITestDevice device, String pkgName, String testClassName, String testMethodName) throws DeviceNotAvailableException {
        return this.runDeviceTests(device, null, pkgName, testClassName, testMethodName, null, 600000L, 600000L, 0L, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(ITestDevice device, String pkgName, String testClassName, String testMethodName, Long testTimeoutMs) throws DeviceNotAvailableException {
        return this.runDeviceTests(device, null, pkgName, testClassName, testMethodName, null, testTimeoutMs, 600000L, 0L, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(ITestDevice device, String pkgName, String testClassName, String testMethodName, Integer userId, Long testTimeoutMs) throws DeviceNotAvailableException {
        return this.runDeviceTests(device, null, pkgName, testClassName, testMethodName, userId, testTimeoutMs, 600000L, 0L, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(ITestDevice device, String pkgName, String testClassName, String testMethodName, Long testTimeoutMs, Long maxTimeToOutputMs, Long maxInstrumentationTimeoutMs) throws DeviceNotAvailableException {
        return this.runDeviceTests(device, null, pkgName, testClassName, testMethodName, null, testTimeoutMs, maxTimeToOutputMs, maxInstrumentationTimeoutMs, true, false, DEFAULT_INSTRUMENTATION_ARGS);
    }

    public final boolean runDeviceTests(DeviceTestRunOptions options) throws DeviceNotAvailableException {
        return this.runDeviceTests(options.getDevice() == null ? this.getDevice() : options.getDevice(), options.getRunner(), options.getPackageName(), options.getTestClassName(), options.getTestMethodName(), options.getUserId(), options.getTestTimeoutMs(), options.getMaxTimeToOutputMs(), options.getMaxInstrumentationTimeoutMs(), options.shouldCheckResults(), options.isHiddenApiCheckDisabled(), options.isTestApiCheckDisabled(), options.isIsolatedStorageDisabled(), options.getInstrumentationArgs(), options.getExtraListeners());
    }

    public final boolean runDeviceTests(ITestDevice device, String runner, String pkgName, String testClassName, String testMethodName, Integer userId, Long testTimeoutMs, Long maxTimeToOutputMs, Long maxInstrumentationTimeoutMs, boolean checkResults, boolean isHiddenApiCheckDisabled, Map<String, String> instrumentationArgs) throws DeviceNotAvailableException {
        return this.runDeviceTests(device, runner, pkgName, testClassName, testMethodName, userId, testTimeoutMs, maxTimeToOutputMs, maxInstrumentationTimeoutMs, checkResults, isHiddenApiCheckDisabled, true, false, instrumentationArgs, new ArrayList<ITestLifeCycleReceiver>());
    }

    public final boolean runDeviceTests(ITestDevice device, String runner, String pkgName, String testClassName, String testMethodName, Integer userId, Long testTimeoutMs, Long maxTimeToOutputMs, Long maxInstrumentationTimeoutMs, boolean checkResults, boolean isHiddenApiCheckDisabled, boolean isTestApiCheckDisabled, boolean isIsolatedStorageDisabled, Map<String, String> instrumentationArgs, List<ITestLifeCycleReceiver> extraListeners) throws DeviceNotAvailableException {
        return this.runDeviceTests(device, runner, pkgName, testClassName, testMethodName, userId, testTimeoutMs, maxTimeToOutputMs, maxInstrumentationTimeoutMs, checkResults, isHiddenApiCheckDisabled, isTestApiCheckDisabled, isIsolatedStorageDisabled, false, instrumentationArgs, extraListeners);
    }

    public final boolean runDeviceTests(ITestDevice device, String runner, String pkgName, String testClassName, String testMethodName, Integer userId, Long testTimeoutMs, Long maxTimeToOutputMs, Long maxInstrumentationTimeoutMs, boolean checkResults, boolean isHiddenApiCheckDisabled, boolean isTestApiCheckDisabled, boolean isIsolatedStorageDisabled, boolean isWindowAnimationDisabled, Map<String, String> instrumentationArgs, List<ITestLifeCycleReceiver> extraListeners) throws DeviceNotAvailableException {
        TestRunResult runResult;
        this.mLatestInstruRes = runResult = this.doRunTests(device, runner, pkgName, testClassName, testMethodName, userId, testTimeoutMs, maxTimeToOutputMs, maxInstrumentationTimeoutMs, isHiddenApiCheckDisabled, isTestApiCheckDisabled, isIsolatedStorageDisabled, isWindowAnimationDisabled, instrumentationArgs, extraListeners);
        this.printTestResult(runResult);
        if (checkResults) {
            if (runResult.isRunFailure()) {
                throw new AssertionError((Object)("Failed to successfully run device tests for " + runResult.getName() + ": " + runResult.getRunFailureMessage()));
            }
            if (runResult.getNumTests() == 0) {
                throw new AssertionError((Object)"No tests were run on the device");
            }
            if (runResult.hasFailedTests()) {
                StringBuilder errorBuilder = new StringBuilder("on-device tests failed:\n");
                for (Map.Entry resultEntry : runResult.getTestResults().entrySet()) {
                    if (TestResult.TestStatus.PASSED.equals((Object)((TestResult)resultEntry.getValue()).getStatus())) continue;
                    errorBuilder.append(((TestDescription)resultEntry.getKey()).toString());
                    errorBuilder.append(":\n");
                    errorBuilder.append(((TestResult)resultEntry.getValue()).getStackTrace());
                }
                throw new AssertionError((Object)errorBuilder.toString());
            }
            List assumpFail = runResult.getTestsResultsInState(TestResult.TestStatus.ASSUMPTION_FAILURE);
            List messages = assumpFail.stream().map(r -> r.getStackTrace()).collect(Collectors.toList());
            String errors = String.join((CharSequence)"\n\n", messages);
            Assume.assumeTrue((String)errors, (runResult.getNumTests() != runResult.getNumTestsInState(TestResult.TestStatus.ASSUMPTION_FAILURE) ? 1 : 0) != 0);
        }
        return !runResult.hasFailedTests() && runResult.getNumTests() > 0;
    }

    public final TestRunResult getLastDeviceRunResults() {
        return this.mLatestInstruRes;
    }

    private TestRunResult doRunTests(ITestDevice device, String runner, String pkgName, String testClassName, String testMethodName, Integer userId, Long testTimeoutMs, Long maxTimeToOutputMs, Long maxInstrumentationTimeoutMs, boolean isHiddenApiCheckDisabled, boolean isTestApiCheckDisabled, boolean isIsolatedStorageDisabled, boolean isWindowAnimationDisabled, Map<String, String> instrumentationArgs, List<ITestLifeCycleReceiver> extraListeners) throws DeviceNotAvailableException {
        int apiLevel;
        RemoteAndroidTestRunner testRunner = this.createTestRunner(pkgName, runner, device);
        String runOptions = "";
        int n = apiLevel = isHiddenApiCheckDisabled || isWindowAnimationDisabled ? device.getApiLevel() : 0;
        if (isHiddenApiCheckDisabled && apiLevel >= 28) {
            runOptions = runOptions + "--no-hidden-api-checks ";
        }
        if (!isHiddenApiCheckDisabled && !isTestApiCheckDisabled && device.checkApiLevelAgainstNextRelease(30)) {
            runOptions = runOptions + "--no-test-api-access ";
        }
        if (isIsolatedStorageDisabled && device.checkApiLevelAgainstNextRelease(29)) {
            runOptions = runOptions + "--no-isolated-storage ";
        }
        if (isWindowAnimationDisabled && apiLevel >= 14) {
            runOptions = runOptions + "--no-window-animation ";
        }
        if (this.getAbi() != null) {
            runOptions = runOptions + String.format("--abi %s", this.getAbi().getName());
        }
        if (!runOptions.isEmpty()) {
            testRunner.setRunOptions(runOptions);
        }
        if (testClassName != null && testMethodName != null) {
            testRunner.setMethodName(testClassName, testMethodName);
        } else if (testClassName != null) {
            testRunner.setClassName(testClassName);
        }
        if (testTimeoutMs != null) {
            testRunner.addInstrumentationArg("timeout_msec", Long.toString(testTimeoutMs));
        } else {
            testRunner.addInstrumentationArg("timeout_msec", Long.toString(600000L));
        }
        if (maxTimeToOutputMs != null) {
            testRunner.setMaxTimeToOutputResponse(maxTimeToOutputMs.longValue(), TimeUnit.MILLISECONDS);
        }
        if (maxInstrumentationTimeoutMs != null) {
            testRunner.setMaxTimeout(maxInstrumentationTimeoutMs.longValue(), TimeUnit.MILLISECONDS);
        }
        for (String key : instrumentationArgs.keySet()) {
            testRunner.addInstrumentationArg(key, instrumentationArgs.get(key));
        }
        CollectingTestListener listener = this.createListener();
        ArrayList<Object> allReceiver = new ArrayList<Object>();
        allReceiver.add(listener);
        allReceiver.addAll(extraListeners);
        if (userId == null) {
            Assert.assertTrue((boolean)device.runInstrumentationTests((IRemoteAndroidTestRunner)testRunner, allReceiver));
        } else {
            Assert.assertTrue((boolean)device.runInstrumentationTestsAsUser((IRemoteAndroidTestRunner)testRunner, userId.intValue(), allReceiver));
        }
        return listener.getCurrentRunResults();
    }

    RemoteAndroidTestRunner createTestRunner(String packageName, String runnerName, ITestDevice device) throws DeviceNotAvailableException {
        if (runnerName == null) {
            ListInstrumentationParser parser = this.getListInstrumentationParser();
            device.executeShellCommand("pm list instrumentation", (IShellOutputReceiver)parser);
            for (ListInstrumentationParser.InstrumentationTarget target : parser.getInstrumentationTargets()) {
                if (!packageName.equals(target.packageName)) continue;
                runnerName = target.runnerName;
            }
        }
        if (runnerName == null) {
            throw new RuntimeException("No runner was defined and couldn't dynamically find one.");
        }
        return new DefaultRemoteAndroidTestRunner(packageName, runnerName, (IShellEnabledDevice)device.getIDevice());
    }

    ListInstrumentationParser getListInstrumentationParser() {
        return new ListInstrumentationParser();
    }

    CollectingTestListener createListener() {
        return new CollectingTestListener();
    }

    private void printTestResult(TestRunResult runResult) {
        for (Map.Entry testEntry : runResult.getTestResults().entrySet()) {
            TestResult testResult = (TestResult)testEntry.getValue();
            TestResult.TestStatus testStatus = testResult.getStatus();
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)("Test " + testEntry.getKey() + ": " + testStatus));
            if (TestResult.TestStatus.PASSED.equals((Object)testStatus) || TestResult.TestStatus.ASSUMPTION_FAILURE.equals((Object)testStatus)) continue;
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)testResult.getStackTrace());
        }
    }

    public final String uninstallPackage(String pkgName) throws DeviceNotAvailableException {
        return this.getDevice().uninstallPackage(pkgName);
    }

    public final String uninstallPackage(ITestDevice device, String pkgName) throws DeviceNotAvailableException {
        return device.uninstallPackage(pkgName);
    }

    public final boolean isPackageInstalled(String pkg) throws DeviceNotAvailableException {
        return this.isPackageInstalled(this.getDevice(), pkg);
    }

    public final boolean isPackageInstalled(ITestDevice device, String pkg) throws DeviceNotAvailableException {
        for (String installedPackage : device.getInstalledPackageNames()) {
            if (!pkg.equals(installedPackage)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeviceFeature(String feature) throws DeviceNotAvailableException {
        return this.getDevice().hasFeature("feature:" + feature);
    }

    SuiteApkInstaller createSuiteApkInstaller() {
        return new SuiteApkInstaller();
    }
}

