/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.PythonUnitTestResultParser;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TimeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
@OptionClass(alias="python-unit")
public class PythonUnitTestRunner
implements IRemoteTest,
IBuildReceiver {
    @Option(name="pythonpath", description="directories to add to the PYTHONPATH")
    private List<File> mPathDirs = new ArrayList<File>();
    @Option(name="pytest", description="names of python modules containing the test cases")
    private List<String> mTests = new ArrayList<String>();
    @Option(name="python-unittest-options", description="option string to be passed to the unittest module")
    private String mUnitTestOpts;
    @Option(name="min-python-version", description="minimum required python version")
    private String mMinPyVersion = "2.7.0";
    @Option(name="python-binary", description="python binary to use (optional)")
    private String mPythonBin;
    @Option(name="test-timeout", description="maximum amount of time tests are allowed to run", isTimeVal=true)
    private long mTestTimeout = 300000L;
    private String mPythonPath;
    private IBuildInfo mBuildInfo;
    private IRunUtil mRunUtil;
    private static final String PYTHONPATH = "PYTHONPATH";
    private static final String VERSION_REGEX = "(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)$";

    protected IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.setPythonPath();
        if (this.mPythonBin == null) {
            this.mPythonBin = this.getPythonBinary();
        }
        IRunUtil runUtil = this.getRunUtil();
        runUtil.setEnvVariable(PYTHONPATH, this.mPythonPath);
        for (String module : this.mTests) {
            this.doRunTest(listener, runUtil, module);
        }
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    protected IBuildInfo getBuild() {
        return this.mBuildInfo;
    }

    String getMinPythonVersion() {
        return this.mMinPyVersion;
    }

    void setMinPythonVersion(String version) {
        this.mMinPyVersion = version;
    }

    private String getPythonBinary() {
        IRunUtil runUtil = RunUtil.getDefault();
        CommandResult c = runUtil.runTimedCmd(1000L, new String[]{"which", "python"});
        String pythonBin = c.getStdout().trim();
        if (pythonBin.length() == 0) {
            throw new RuntimeException("Could not find python binary on host machine");
        }
        c = runUtil.runTimedCmd(1000L, new String[]{pythonBin, "--version"});
        LogUtil.CLog.i((String)"Found python version: %s", (Object[])new Object[]{c.getStderr()});
        this.checkPythonVersion(c);
        return pythonBin;
    }

    private void setPythonPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getenv(PYTHONPATH));
        for (File pathdir : this.mPathDirs) {
            if (!pathdir.isDirectory()) {
                LogUtil.CLog.w((String)"Not adding file %s to PYTHONPATH: expecting directory", (Object[])new Object[]{pathdir.getAbsolutePath()});
            }
            sb.append(":");
            sb.append(pathdir.getAbsolutePath());
        }
        if (this.getBuild().getFile(PYTHONPATH) != null) {
            sb.append(":");
            sb.append(this.getBuild().getFile(PYTHONPATH).getAbsolutePath());
        }
        this.mPythonPath = sb.toString();
    }

    protected void checkPythonVersion(CommandResult c) {
        Matcher minVersionParts = Pattern.compile(VERSION_REGEX).matcher(this.mMinPyVersion);
        Matcher versionParts = Pattern.compile(VERSION_REGEX).matcher(c.getStderr());
        if (!minVersionParts.find()) {
            throw new RuntimeException(String.format("Could not parse the min version: '%s'", this.mMinPyVersion));
        }
        int major = Integer.parseInt(minVersionParts.group(1));
        int minor = Integer.parseInt(minVersionParts.group(2));
        int revision = Integer.parseInt(minVersionParts.group(3));
        if (!versionParts.find()) {
            throw new RuntimeException(String.format("Could not parse the current version: '%s'", c.getStderr()));
        }
        int foundMajor = Integer.parseInt(versionParts.group(1));
        int foundMinor = Integer.parseInt(versionParts.group(2));
        int foundRevision = Integer.parseInt(versionParts.group(3));
        boolean check = false;
        if (foundMajor > major) {
            check = true;
        } else if (foundMajor == major) {
            if (foundMinor > minor) {
                check = true;
            } else if (foundMinor == minor && foundRevision >= revision) {
                check = true;
            }
        }
        if (!check) {
            throw new RuntimeException(String.format("Current version '%s' does not meet min version: '%s'", c.getStderr(), this.mMinPyVersion));
        }
    }

    void doRunTest(ITestInvocationListener listener, IRunUtil runUtil, String pyModule) {
        String[] baseOpts = new String[]{this.mPythonBin, "-m", "unittest", "-v"};
        String[] testModule = new String[]{pyModule};
        String[] cmd = this.mUnitTestOpts != null ? ArrayUtil.buildArray((String[][])new String[][]{baseOpts, this.mUnitTestOpts.split(" "), testModule}) : ArrayUtil.buildArray((String[][])new String[][]{baseOpts, testModule});
        CommandResult c = runUtil.runTimedCmd(this.mTestTimeout, cmd);
        if (c.getStatus() == CommandStatus.TIMED_OUT) {
            LogUtil.CLog.e((String)"Python process timed out");
            LogUtil.CLog.e((String)"Stderr: %s", (Object[])new Object[]{c.getStderr()});
            LogUtil.CLog.e((String)"Stdout: %s", (Object[])new Object[]{c.getStdout()});
            throw new RuntimeException(String.format("Python unit test timed out after %s", TimeUtil.formatElapsedTime((long)this.mTestTimeout)));
        }
        LogUtil.CLog.i((String)"Parsing test result: %s", (Object[])new Object[]{c.getStderr()});
        PythonUnitTestResultParser parser = new PythonUnitTestResultParser(ArrayUtil.list((Object[])new ITestInvocationListener[]{listener}), pyModule);
        parser.processNewLines(c.getStderr().split("\n"));
    }
}

