/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeStressTestParser
extends MultiLineReceiver {
    private static final String LOG_TAG = "NativeStressTestParser";
    private static final Pattern ITERATION_COMPLETE_PATTERN = Pattern.compile("^====\\s*Completed\\s*pass:\\s*(\\d+)");
    private final String mTestRunName;
    private boolean mIsCanceled = false;
    private int mTotalIterations = 0;

    public NativeStressTestParser(String runName) {
        this.mTestRunName = runName;
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.parseLine(line);
        }
    }

    private void parseLine(String line) {
        Matcher matcher = ITERATION_COMPLETE_PATTERN.matcher(line);
        if (matcher.find()) {
            this.parseIterationValue(line, matcher.group(1));
        }
    }

    private void parseIterationValue(String line, String iterationString) {
        try {
            int currentIteration = Integer.parseInt(iterationString);
            Log.i((String)LOG_TAG, (String)String.format("%s: pass %d", this.mTestRunName, currentIteration));
            ++this.mTotalIterations;
        }
        catch (NumberFormatException e) {
            Log.e((String)LOG_TAG, (String)String.format("Unexpected iteration content %s", line));
        }
    }

    public boolean isCancelled() {
        return this.mIsCanceled;
    }

    public String getRunName() {
        return this.mTestRunName;
    }

    public int getIterationsCompleted() {
        return this.mTotalIterations;
    }
}

