/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public final class NativeCodeCoverageListener
extends ResultForwarder {
    private static final String NATIVE_COVERAGE_DEVICE_PATH = "/data/misc/trace";
    private static final String COVERAGE_TAR_PATH = String.format("%s/coverage.tar", "/data/misc/trace");
    private static final String ZIP_COVERAGE_FILES_COMMAND = String.format("find %s -name '*.gcda' | tar -cvf %s -T -", "/data/misc/trace", COVERAGE_TAR_PATH);
    private static final String DELETE_COVERAGE_FILES_COMMAND = String.format("find %s -name '*.gcda' -delete", "/data/misc/trace");
    private final boolean mFlushCoverage;
    private final ITestDevice mDevice;
    private final NativeCodeCoverageFlusher mFlusher;
    private boolean mCollectCoverageOnTestEnd = true;
    private String mCurrentRunName;

    public NativeCodeCoverageListener(ITestDevice device, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mDevice = device;
        this.mFlushCoverage = false;
        this.mFlusher = new NativeCodeCoverageFlusher(this.mDevice, ImmutableList.of());
    }

    public NativeCodeCoverageListener(ITestDevice device, CoverageOptions coverageOptions, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mDevice = device;
        this.mFlushCoverage = coverageOptions.isCoverageFlushEnabled();
        this.mFlusher = new NativeCodeCoverageFlusher(this.mDevice, coverageOptions.getCoverageProcesses());
    }

    public void setCollectOnTestEnd(boolean collect) {
        this.mCollectCoverageOnTestEnd = collect;
    }

    public void testRunStarted(String runName, int testCount) {
        super.testRunStarted(runName, testCount);
        this.mCurrentRunName = runName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        try {
            if (this.mCollectCoverageOnTestEnd) {
                this.logCoverageMeasurements(this.mCurrentRunName);
            }
        }
        finally {
            super.testRunEnded(elapsedTime, runMetrics);
        }
    }

    public void logCoverageMeasurements(String runName) {
        File coverageTar = null;
        File coverageZip = null;
        try {
            Verify.verify(this.mDevice.enableAdbRoot(), "Failed to enable adb root.", new Object[0]);
            if (this.mFlushCoverage) {
                this.mFlusher.forceCoverageFlush();
            }
            this.mDevice.executeShellCommand(ZIP_COVERAGE_FILES_COMMAND);
            coverageTar = this.mDevice.pullFile(COVERAGE_TAR_PATH);
            Verify.verifyNotNull(coverageTar, "Failed to pull the native code coverage file %s", COVERAGE_TAR_PATH);
            this.mDevice.deleteFile(COVERAGE_TAR_PATH);
            coverageZip = this.convertTarToZip(coverageTar);
            try (FileInputStreamSource source = new FileInputStreamSource(coverageZip, true);){
                this.testLog(runName + "_native_runtime_coverage", LogDataType.NATIVE_COVERAGE, (InputStreamSource)source);
            }
            this.mDevice.executeShellCommand(DELETE_COVERAGE_FILES_COMMAND);
        }
        catch (DeviceNotAvailableException | IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile(coverageTar);
                FileUtil.deleteFile(coverageZip);
                throw throwable;
            }
        }
        FileUtil.deleteFile((File)coverageTar);
        FileUtil.deleteFile((File)coverageZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File convertTarToZip(File tar) throws IOException {
        File untarDir = null;
        try {
            untarDir = FileUtil.createTempDir((String)"gcov_coverage");
            TarUtil.unTar((File)tar, (File)untarDir);
            File file = ZipUtil.createZip(Arrays.asList(untarDir.listFiles()), (String)"native_coverage");
            return file;
        }
        finally {
            FileUtil.recursiveDelete((File)untarDir);
        }
    }
}

