/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.JUnitToInvocationResultForwarder;
import com.android.tradefed.testtype.DeviceTestResult;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class JUnitRunUtil {
    public static boolean runTest(ITestInvocationListener listener, Test junitTest) throws DeviceNotAvailableException {
        return JUnitRunUtil.runTest(listener, junitTest, junitTest.getClass().getName());
    }

    public static boolean runTest(ITestInvocationListener listener, Test junitTest, String runName) throws DeviceNotAvailableException {
        if (junitTest.countTestCases() == 0) {
            return false;
        }
        listener.testRunStarted(runName, junitTest.countTestCases());
        long startTime = System.currentTimeMillis();
        JUnitToInvocationResultForwarder resultForwarder = new JUnitToInvocationResultForwarder(listener);
        DeviceTestResult result = new DeviceTestResult();
        result.addListener((TestListener)resultForwarder);
        try {
            junitTest.run((TestResult)result);
        }
        catch (DeviceTestResult.RuntimeDeviceNotAvailableException e) {
            listener.testRunFailed(e.getDeviceException().getMessage());
            throw e.getDeviceException();
        }
        finally {
            listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap());
        }
        return true;
    }
}

