/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.isolation.FilterSpec;
import com.android.tradefed.isolation.JUnitEvent;
import com.android.tradefed.isolation.RunnerMessage;
import com.android.tradefed.isolation.RunnerOp;
import com.android.tradefed.isolation.RunnerReply;
import com.android.tradefed.isolation.TestParameters;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@OptionClass(alias="isolated-host-test")
public class IsolatedHostTest
implements IRemoteTest,
IBuildReceiver,
ITestAnnotationFilterReceiver,
ITestFilterReceiver,
ITestCollector {
    @Option(name="class", description="The JUnit test classes to run, in the format <package>.<class>. eg. \"com.android.foo.Bar\". This field can be repeated.", importance=Option.Importance.IF_UNSET)
    private Set<String> mClasses = new LinkedHashSet<String>();
    @Option(name="method", description="The name of the method in the JUnit TestCase to run. eg. \"testFooBar\"", importance=Option.Importance.IF_UNSET)
    private String mMethodName;
    @Option(name="jar", description="The jars containing the JUnit test class to run.", importance=Option.Importance.IF_UNSET)
    private Set<String> mJars = new HashSet<String>();
    @Option(name="socket-timeout", description="The longest allowable time between messages from the subprocess before assuming that it has malfunctioned or died.", importance=Option.Importance.IF_UNSET)
    private int mSocketTimeout = 60000;
    @Option(name="include-annotation", description="The set of annotations a test must have to be run.")
    private Set<String> mIncludeAnnotations = new HashSet<String>();
    @Option(name="exclude-annotation", description="The set of annotations to exclude tests from running. A test must have none of the annotations in this list to run.")
    private Set<String> mExcludeAnnotations = new HashSet<String>();
    @Option(name="java-flags", description="The set of flags to pass to the Java subprocess for complicated test needs.")
    private List<String> mJavaFlags = new ArrayList<String>();
    @Option(name="exclude-paths", description="The (prefix) paths to exclude from searching in the jars.")
    private Set<String> mExcludePaths = new HashSet<String>();
    private IBuildInfo mBuildInfo;
    private Set<String> mIncludeFilters = new HashSet<String>();
    private Set<String> mExcludeFilters = new HashSet<String>();
    private boolean mCollectTestsOnly = false;
    private static final String ROOT_DIR = "ROOT_DIR";
    private static final List<String> ISOLATION_JARS = new ArrayList<String>(Arrays.asList("tradefed-isolation.jar"));
    private ServerSocket mServer = null;

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            this.mServer = new ServerSocket(0);
            this.mServer.setSoTimeout(this.mSocketTimeout);
            ArrayList<String> cmdArgs = new ArrayList<String>(List.of(SystemUtil.getRunningJavaBinaryPath().getAbsolutePath(), "-cp", this.compileClassPath()));
            cmdArgs.addAll(this.mJavaFlags);
            cmdArgs.addAll(List.of("com.android.tradefed.isolation.IsolationRunner", "-", "--port", Integer.toString(this.mServer.getLocalPort()), "--address", this.mServer.getInetAddress().getHostAddress(), "--timeout", Integer.toString(this.mSocketTimeout)));
            LogUtil.CLog.v((String)String.join((CharSequence)" ", cmdArgs));
            RunUtil runner = new RunUtil();
            Process isolationRunner = runner.runCmdInBackground(ProcessBuilder.Redirect.INHERIT, cmdArgs);
            LogUtil.CLog.v((String)"Started subprocess.");
            Socket socket = this.mServer.accept();
            socket.setSoTimeout(this.mSocketTimeout);
            LogUtil.CLog.v((String)"Connected to subprocess.");
            List<String> testJarAbsPaths = this.getJarPaths(this.mJars);
            TestParameters.Builder paramsBuilder = TestParameters.newBuilder().addAllTestClasses(this.mClasses).addAllTestJarAbsPaths(testJarAbsPaths).addAllExcludePaths(this.mExcludePaths).setDryRun(this.mCollectTestsOnly);
            if (!(this.mIncludeFilters.isEmpty() && this.mExcludeFilters.isEmpty() && this.mIncludeAnnotations.isEmpty() && this.mExcludeAnnotations.isEmpty())) {
                paramsBuilder.setFilter(FilterSpec.newBuilder().addAllIncludeFilters(this.mIncludeFilters).addAllExcludeFilters(this.mExcludeFilters).addAllIncludeAnnotations(this.mIncludeAnnotations).addAllExcludeAnnotations(this.mExcludeAnnotations));
            }
            this.executeTests(socket, listener, paramsBuilder.build());
            RunnerMessage.newBuilder().setCommand(RunnerOp.RUNNER_OP_STOP).build().writeDelimitedTo(socket.getOutputStream());
        }
        catch (IOException e) {
            listener.testRunFailed(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            listener.testRunFailed(e.getMessage());
        }
    }

    private String compileClassPath() throws ClassNotFoundException {
        ArrayList<String> paths = new ArrayList<String>();
        IDeviceBuildInfo build = (IDeviceBuildInfo)this.mBuildInfo;
        File testDir = build.getTestsDir();
        try {
            URI tradefedJarPath = IsolatedHostTest.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            String isolationJarPath = new File(tradefedJarPath).getParentFile().getAbsolutePath() + "/tradefed-isolation.jar";
            paths.add(isolationJarPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        for (String jar : this.mJars) {
            File f = FileUtil.findFile((File)testDir, (String)jar);
            if (f == null || !f.exists()) continue;
            paths.add(f.getAbsolutePath());
            paths.add(f.getParentFile().getAbsolutePath() + "/*");
        }
        String jarClasspath = String.join((CharSequence)File.pathSeparator, paths);
        return jarClasspath;
    }

    private void executeTests(Socket socket, ITestInvocationListener listener, TestParameters params) throws IOException {
        RunnerMessage.newBuilder().setCommand(RunnerOp.RUNNER_OP_RUN_TEST).setParams(params).build().writeDelimitedTo(socket.getOutputStream());
        block16: while (true) {
            try {
                while (true) {
                    RunnerReply reply = RunnerReply.parseDelimitedFrom((InputStream)socket.getInputStream());
                    block1 : switch (reply.getRunnerStatus()) {
                        case RUNNER_STATUS_FINISHED_OK: {
                            LogUtil.CLog.v((String)"Received message that runner finished successfully");
                            break block16;
                        }
                        case RUNNER_STATUS_FINISHED_ERROR: {
                            LogUtil.CLog.e((String)"Received message that runner errored");
                            LogUtil.CLog.e((String)("From Runner: " + reply.getMessage()));
                            listener.testRunFailed(reply.getMessage());
                            break block16;
                        }
                        case RUNNER_STATUS_STARTING: {
                            LogUtil.CLog.v((String)"Received message that runner is starting");
                            break;
                        }
                        default: {
                            if (!reply.hasTestEvent()) continue block16;
                            JUnitEvent event = reply.getTestEvent();
                            switch (event.getTopic()) {
                                case TOPIC_FAILURE: {
                                    TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                                    listener.testFailed(desc, event.getMessage());
                                    listener.testEnded(desc, new HashMap());
                                    break block1;
                                }
                                case TOPIC_ASSUMPTION_FAILURE: {
                                    TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                                    listener.testAssumptionFailure(desc, reply.getMessage());
                                    break block1;
                                }
                                case TOPIC_STARTED: {
                                    TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                                    listener.testStarted(desc);
                                    break block1;
                                }
                                case TOPIC_FINISHED: {
                                    TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                                    listener.testEnded(desc, new HashMap());
                                    break block1;
                                }
                                case TOPIC_IGNORED: {
                                    TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                                    listener.testIgnored(desc);
                                    break block1;
                                }
                                case TOPIC_RUN_STARTED: {
                                    listener.testRunStarted(event.getClassName(), event.getTestCount());
                                    break block1;
                                }
                                case TOPIC_RUN_FINISHED: {
                                    listener.testRunEnded(event.getElapsedTime(), new HashMap());
                                    break block1;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            catch (SocketTimeoutException e) {
                listener.testRunFailed(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<String> getJarPaths(Set<String> jars) throws FileNotFoundException {
        HashSet<String> output = new HashSet<String>();
        for (String jar : jars) {
            File jarFile = this.getJarFile(jar, this.mBuildInfo);
            output.add(jarFile.getAbsolutePath());
        }
        return output.stream().collect(Collectors.toList());
    }

    private File getJarFile(String jarName, IBuildInfo buildInfo) throws FileNotFoundException {
        File jarFile = null;
        if (buildInfo instanceof IDeviceBuildInfo) {
            IDeviceBuildInfo deviceBuildInfo = (IDeviceBuildInfo)buildInfo;
            File testDir = deviceBuildInfo.getTestsDir();
            jarFile = this.searchJarFile(testDir, jarName);
        }
        if (jarFile != null) {
            return jarFile;
        }
        if (buildInfo.getBuildAttributes().get(ROOT_DIR) != null) {
            jarFile = this.searchJarFile(new File((String)buildInfo.getBuildAttributes().get(ROOT_DIR)), jarName);
        }
        if (jarFile != null) {
            return jarFile;
        }
        throw new FileNotFoundException(String.format("Could not find jar: %s", jarName));
    }

    private File searchJarFile(File baseSearchFile, String jarName) {
        File jarFile;
        if (baseSearchFile != null && baseSearchFile.isDirectory() && (jarFile = FileUtil.findFile((File)baseSearchFile, (String)jarName)) != null && jarFile.isFile()) {
            return jarFile;
        }
        return null;
    }

    public void setBuild(IBuildInfo build) {
        this.mBuildInfo = build;
    }

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    public void addIncludeAnnotation(String annotation) {
        this.mIncludeAnnotations.add(annotation);
    }

    public void addExcludeAnnotation(String notAnnotation) {
        this.mExcludeAnnotations.add(notAnnotation);
    }

    public void addAllIncludeAnnotation(Set<String> annotations) {
        this.mIncludeAnnotations.addAll(annotations);
    }

    public void addAllExcludeAnnotation(Set<String> notAnnotations) {
        this.mExcludeAnnotations.addAll(notAnnotations);
    }

    public Set<String> getIncludeAnnotations() {
        return this.mIncludeAnnotations;
    }

    public Set<String> getExcludeAnnotations() {
        return this.mExcludeAnnotations;
    }

    public void clearIncludeAnnotations() {
        this.mIncludeAnnotations.clear();
    }

    public void clearExcludeAnnotations() {
        this.mExcludeAnnotations.clear();
    }

    private class LogStreamHelper
    implements Runnable {
        private InputStream mStream = null;
        private boolean mIsErrorStream = false;

        public LogStreamHelper(InputStream stream, boolean isErrorStream) {
            this.mStream = stream;
        }

        @Override
        public void run() {
            if (this.mIsErrorStream) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.mStream));){
                    reader.lines().forEach(line -> LogUtil.CLog.e((String)"E/IsolationRunner: %s", (Object[])new Object[]{line}));
                }
                catch (Exception e) {
                    LogUtil.CLog.e((Throwable)e);
                }
            } else {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.mStream));){
                    reader.lines().forEach(line -> LogUtil.CLog.v((String)"V/IsolationRunner: %s", (Object[])new Object[]{line}));
                }
                catch (Exception e) {
                    LogUtil.CLog.e((Throwable)e);
                }
            }
        }
    }
}

