/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.BugreportCollector;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.ddmlib.DefaultRemoteAndroidTestRunner;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.retry.RetryStrategy;
import com.android.tradefed.testtype.ClangCodeCoverageListener;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.InstrumentationFileTest;
import com.android.tradefed.testtype.InstrumentationListener;
import com.android.tradefed.testtype.InstrumentationSerialTest;
import com.android.tradefed.testtype.JavaCodeCoverageListener;
import com.android.tradefed.testtype.NativeCodeCoverageListener;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.AbiFormatter;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.JavaCodeCoverageFlusher;
import com.android.tradefed.util.ListInstrumentationParser;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.android.tradefed.util.StringEscapeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="instrumentation")
public class InstrumentationTest
implements IDeviceTest,
IRemoteTest,
ITestCollector,
IAbiReceiver,
IConfigurationReceiver,
IMetricCollectorReceiver {
    private static final String LOG_TAG = "InstrumentationTest";
    private static final int COLLECT_TESTS_ATTEMPTS = 3;
    private static final String TEST_FILE_INST_ARGS_KEY = "testFile";
    static final String TEST_TIMEOUT_INST_ARGS_KEY = "timeout_msec";
    static final long TEST_COLLECTION_TIMEOUT_MS = 120000L;
    static final String MERGE_COVERAGE_MEASUREMENTS_TEST_NAME = "mergeCoverageMeasurements";
    @Option(name="package", shortName=112, description="The manifest package name of the Android test application to run.", importance=Option.Importance.IF_UNSET)
    private String mPackageName = null;
    @Option(name="runner", description="The instrumentation test runner class name to use. Will try to determine automatically if it is not specified.")
    private String mRunnerName = null;
    @Option(name="class", shortName=99, description="The test class name to run.")
    private String mTestClassName = null;
    @Option(name="method", shortName=109, description="The test method name to run.")
    private String mTestMethodName = null;
    @Option(name="test-package", description="Only run tests within this specific java package. Will be ignored if --class is set.")
    private String mTestPackageName = null;
    @Deprecated
    @Option(name="timeout", description="Deprecated - Use \"shell-timeout\" or \"test-timeout\" instead.")
    private Integer mTimeout = null;
    @Option(name="shell-timeout", description="The defined timeout (in milliseconds) is used as a maximum waiting time when expecting the command output from the device. At any time, if the shell command does not output anything for a period longer than defined timeout the TF run terminates. For no timeout, set to 0.", isTimeVal=true)
    private long mShellTimeout = 600000L;
    @Option(name="test-timeout", description="Sets timeout (in milliseconds) that will be applied to each test. In the event of a test timeout, it will log the results and proceed with executing the next test. For no timeout, set to 0.", isTimeVal=true)
    private long mTestTimeout = 300000L;
    @Option(name="max-timeout", description="Sets the max timeout for the instrumentation to terminate. For no timeout, set to 0.", isTimeVal=true)
    private long mMaxTimeout = 0L;
    @Option(name="size", description="Restrict test to a specific test size.")
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete.")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable.")
    private boolean mIsResumeMode = false;
    @Option(name="install-file", description="Optional file path to apk file that contains the tests.")
    private File mInstallFile = null;
    @Option(name="run-name", description="Optional custom test run name to pass to listener. If unspecified, will use package name.")
    private String mRunName = null;
    @Option(name="instrumentation-arg", description="Additional instrumentation arguments to provide.", requiredForRerun=true)
    private final Map<String, String> mInstrArgMap = new HashMap<String, String>();
    @Option(name="bugreport-on-failure", description="Sets which failed testcase events cause a bugreport to be collected. a bugreport after failed testcases.  Note that there is _no feedback mechanism_ between the test runner and the bugreport collector, so use the EACH setting with due caution.")
    private BugreportCollector.Freq mBugreportFrequency = null;
    @Option(name="rerun-from-file", description="Use test file instead of separate adb commands for each test when re-running instrumentations for tests that failed to run in previous attempts. ")
    private boolean mReRunUsingTestFile = true;
    @Option(name="rerun-from-file-attempts", description="Max attempts to rerun tests from file. -1 means rerun from file infinitely.")
    private int mReRunUsingTestFileAttempts = 3;
    @Option(name="fallback-to-serial-rerun", description="Rerun tests serially after rerun from file failed.")
    private boolean mFallbackToSerialRerun = false;
    @Option(name="reboot-before-rerun", description="Reboot a device before re-running instrumentations.")
    private boolean mRebootBeforeReRun = false;
    @Option(name="force-abi", description="The abi to use, can be either 32 or 64.", importance=Option.Importance.IF_UNSET)
    private String mForceAbi = null;
    @Option(name="collect-tests-only", description="Only invoke the instrumentation to collect list of applicable test cases. All test run callbacks will be triggered, but test execution will not be actually carried out.")
    private boolean mCollectTestsOnly = false;
    @Option(name="collect-tests-timeout", description="Timeout for the tests collection operation.", isTimeVal=true)
    private long mCollectTestTimeout = 120000L;
    @Option(name="debug", description="Wait for debugger before instrumentation starts. Note that this should only be used for local debugging, not suitable for automated runs.")
    protected boolean mDebug = false;
    @Deprecated
    @Option(name="coverage", description="Collect code coverage for this test run. Note that the build under test must be a coverage build or else this will fail.")
    private boolean mCoverage = false;
    @Option(name="merge-coverage-measurements", description="Merge coverage measurements from all test runs into a single measurement before logging.")
    private boolean mMergeCoverageMeasurements = false;
    @Deprecated
    @Option(name="enforce-ajur-format", description="Whether or not enforcing the AJUR instrumentation output format")
    private boolean mShouldEnforceFormat = false;
    @Option(name="hidden-api-checks", description="If set to false, the '--no-hidden-api-checks' flag will be passed to the am instrument command. Only works for P or later.")
    private boolean mHiddenApiChecks = true;
    @Option(name="test-api-access", description="If set to false and hidden API checks are enabled, the '--no-test-api-access' flag will be passed to the am instrument command. Only works for R or later.")
    private boolean mTestApiAccess = true;
    @Option(name="isolated-storage", description="If set to false, the '--no-isolated-storage' flag will be passed to the am instrument command. Only works for Q or later.")
    private boolean mIsolatedStorage = true;
    @Option(name="window-animation", description="If set to false, the '--no-window-animation' flag will be passed to the am instrument command. Only works for ICS or later.")
    private boolean mWindowAnimation = true;
    @Option(name="disable-duplicate-test-check", description="If set to true, it will not check that a method is only run once by a given instrumentation.")
    private boolean mDisableDuplicateCheck = false;
    @Option(name="enable-soft-restart-check", description="Whether or not to enable checking whether instrumentation crash is due to a system_server restart.")
    private boolean mEnableSoftRestartCheck = false;
    @Option(name="report-unexecuted-tests", description="Whether or not to enable reporting all unexecuted tests from instrumentation.")
    private boolean mReportUnexecuted = true;
    private IAbi mAbi = null;
    private Collection<String> mInstallArgs = new ArrayList<String>();
    private ITestDevice mDevice = null;
    private IRemoteAndroidTestRunner mRunner;
    private Collection<TestDescription> mTestsToRun = null;
    private String mCoverageTarget = null;
    private String mTestFilePathOnDevice = null;
    private ListInstrumentationParser mListInstrumentationParser = null;
    private NativeCodeCoverageListener mNativeCoverageListener = null;
    private List<String> mExtraDeviceListener = new ArrayList<String>();
    private boolean mIsRerun = false;
    private IConfiguration mConfiguration = null;
    private List<IMetricCollector> mCollectors = new ArrayList<IMetricCollector>();

    public void setConfiguration(IConfiguration config) {
        this.mConfiguration = config;
    }

    public IConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setRunnerName(String runnerName) {
        this.mRunnerName = runnerName;
    }

    public String getRunnerName() {
        return this.mRunnerName;
    }

    public void setClassName(String testClassName) {
        this.mTestClassName = testClassName;
    }

    public void setMethodName(String testMethodName) {
        this.mTestMethodName = StringEscapeUtils.escapeShell((String)testMethodName);
    }

    public void setTestFilePathOnDevice(String testFilePathOnDevice) {
        this.mTestFilePathOnDevice = testFilePathOnDevice;
    }

    public void setTestSize(String size) {
        this.mTestSize = size;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getRunName() {
        return this.mRunName;
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    public void setTestsToRun(Collection<TestDescription> tests) {
        this.mTestsToRun = tests;
    }

    protected String getClassName() {
        return this.mTestClassName;
    }

    protected String getMethodName() {
        return this.mTestMethodName;
    }

    String getTestFilePathOnDevice() {
        return this.mTestFilePathOnDevice;
    }

    protected String getTestPackageName() {
        return this.mTestPackageName;
    }

    public void setTestPackageName(String testPackageName) {
        this.mTestPackageName = testPackageName;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    public void setShellTimeout(long timeout) {
        this.mShellTimeout = timeout;
    }

    public void setTestTimeout(long timeout) {
        this.mTestTimeout = timeout;
    }

    public void setCoverageTarget(String coverageTarget) {
        this.mCoverageTarget = coverageTarget;
    }

    public String getCoverageTarget() {
        return this.mCoverageTarget;
    }

    boolean isRerunMode() {
        return this.mIsRerunMode;
    }

    void setIsRerun(boolean isRerun) {
        this.mIsRerun = isRerun;
    }

    public void setRerunMode(boolean rerun) {
        this.mIsRerunMode = rerun;
    }

    public void setResumeMode(boolean resume) {
        this.mIsResumeMode = resume;
    }

    long getShellTimeout() {
        return this.mShellTimeout;
    }

    long getTestTimeout() {
        return this.mTestTimeout;
    }

    public long getMaxTimeout() {
        return this.mMaxTimeout;
    }

    public void setInstallFile(File installFile) {
        this.mInstallFile = installFile;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Deprecated
    public void setCollectsTestsShellTimeout(int timeout) {
    }

    public void setBugreportFrequency(BugreportCollector.Freq freq) {
        this.mBugreportFrequency = freq;
    }

    public void addInstrumentationArg(String key, String value) {
        this.mInstrArgMap.put(key, value);
    }

    void removeFromInstrumentationArg(String key) {
        this.mInstrArgMap.remove(key);
    }

    String getInstrumentationArg(String key) {
        if (this.mInstrArgMap.containsKey(key)) {
            return this.mInstrArgMap.get(key);
        }
        return null;
    }

    public void setForceAbi(String abi) {
        this.mForceAbi = abi;
    }

    public String getForceAbi() {
        return this.mForceAbi;
    }

    @VisibleForTesting
    void setMergeCoverageMeasurements(boolean merge) {
        this.mMergeCoverageMeasurements = merge;
    }

    public void setReRunUsingTestFile(boolean reRunUsingTestFile) {
        this.mReRunUsingTestFile = reRunUsingTestFile;
    }

    public void setFallbackToSerialRerun(boolean reRunSerially) {
        this.mFallbackToSerialRerun = reRunSerially;
    }

    public void setRebootBeforeReRun(boolean rebootBeforeReRun) {
        this.mRebootBeforeReRun = rebootBeforeReRun;
    }

    public void addDeviceListeners(List<String> extraListeners) {
        this.mExtraDeviceListener.addAll(extraListeners);
    }

    IRemoteAndroidTestRunner createRemoteAndroidTestRunner(String packageName, String runnerName, IDevice device) throws DeviceNotAvailableException {
        int apiLevel;
        DefaultRemoteAndroidTestRunner runner = new DefaultRemoteAndroidTestRunner(packageName, runnerName, (IShellEnabledDevice)device);
        String abiName = this.resolveAbiName();
        String runOptions = "";
        int n = apiLevel = !this.mHiddenApiChecks || !this.mWindowAnimation ? this.getDevice().getApiLevel() : 0;
        if (!this.mHiddenApiChecks && apiLevel >= 28) {
            runOptions = runOptions + "--no-hidden-api-checks ";
        }
        if (this.mHiddenApiChecks && !this.mTestApiAccess && this.getDevice().checkApiLevelAgainstNextRelease(30)) {
            runOptions = runOptions + "--no-test-api-access ";
        }
        if (!this.mIsolatedStorage && this.getDevice().checkApiLevelAgainstNextRelease(29)) {
            runOptions = runOptions + "--no-isolated-storage ";
        }
        if (!this.mWindowAnimation && apiLevel >= 14) {
            runOptions = runOptions + "--no-window-animation ";
        }
        if (abiName != null && this.getDevice().getApiLevel() > 20) {
            this.mInstallArgs.add(String.format("--abi %s", abiName));
            runOptions = runOptions + String.format("--abi %s", abiName);
        }
        if (!runOptions.isEmpty()) {
            runner.setRunOptions(runOptions);
        }
        return runner;
    }

    private String resolveAbiName() throws DeviceNotAvailableException {
        if (this.mAbi != null && this.mForceAbi != null) {
            throw new IllegalArgumentException("cannot specify both abi flags");
        }
        String abiName = null;
        if (this.mAbi != null) {
            abiName = this.mAbi.getName();
        } else if (this.mForceAbi != null && !this.mForceAbi.isEmpty() && (abiName = AbiFormatter.getDefaultAbi((ITestDevice)this.mDevice, (String)this.mForceAbi)) == null) {
            throw new RuntimeException(String.format("Cannot find abi for force-abi %s", this.mForceAbi));
        }
        return abiName;
    }

    @VisibleForTesting
    void setListInstrumentationParser(ListInstrumentationParser listInstrumentationParser) {
        this.mListInstrumentationParser = listInstrumentationParser;
    }

    protected ListInstrumentationParser getListInstrumentationParser() {
        if (this.mListInstrumentationParser == null) {
            this.mListInstrumentationParser = new ListInstrumentationParser();
        }
        return this.mListInstrumentationParser;
    }

    protected String queryRunnerName() throws DeviceNotAvailableException {
        ListInstrumentationParser parser = this.getListInstrumentationParser();
        this.getDevice().executeShellCommand("pm list instrumentation", (IShellOutputReceiver)parser);
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        for (ListInstrumentationParser.InstrumentationTarget target : parser.getInstrumentationTargets()) {
            if (!this.mPackageName.equals(target.packageName)) continue;
            candidates.add(target.runnerName);
        }
        if (candidates.isEmpty()) {
            LogUtil.CLog.w((String)"Unable to determine runner name for package: %s", (Object[])new Object[]{this.mPackageName});
            return null;
        }
        Sets.SetView intersection = Sets.intersection(candidates, ListInstrumentationParser.SHARDABLE_RUNNERS);
        if (intersection.isEmpty()) {
            return (String)candidates.iterator().next();
        }
        return (String)intersection.iterator().next();
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        String installOutput;
        Preconditions.checkArgument(this.mDevice != null, "Device has not been set.");
        Preconditions.checkArgument(this.mPackageName != null, "Package name has not been set.");
        if (this.mInstallFile != null && (installOutput = this.mDevice.installPackage(this.mInstallFile, true, this.mInstallArgs.toArray(new String[0]))) != null) {
            throw new RuntimeException(String.format("Error while installing '%s': %s", this.mInstallFile.getName(), installOutput));
        }
        if (this.mRunnerName == null) {
            this.setRunnerName(this.queryRunnerName());
            Preconditions.checkArgument(this.mRunnerName != null, "Runner name has not been set and no matching instrumentations were found.");
            LogUtil.CLog.i((String)"No runner name specified. Using: %s.", (Object[])new Object[]{this.mRunnerName});
        }
        this.mRunner = this.createRemoteAndroidTestRunner(this.mPackageName, this.mRunnerName, this.mDevice.getIDevice());
        this.setRunnerArgs(this.mRunner);
        this.doTestRun(testInfo, listener);
        if (this.mInstallFile != null) {
            this.mDevice.uninstallPackage(this.mPackageName);
        }
    }

    protected void setRunnerArgs(IRemoteAndroidTestRunner runner) {
        if (this.mTestClassName != null) {
            if (this.mTestMethodName != null) {
                runner.setMethodName(this.mTestClassName, this.mTestMethodName);
            } else {
                runner.setClassName(this.mTestClassName);
            }
        } else if (this.mTestPackageName != null) {
            runner.setTestPackageName(this.mTestPackageName);
        }
        if (this.mTestFilePathOnDevice != null) {
            this.addInstrumentationArg(TEST_FILE_INST_ARGS_KEY, this.mTestFilePathOnDevice);
        }
        if (this.mTestSize != null) {
            runner.setTestSize(IRemoteAndroidTestRunner.TestSize.getTestSize((String)this.mTestSize));
        }
        this.addTimeoutsToRunner(runner);
        if (this.mRunName != null) {
            runner.setRunName(this.mRunName);
        }
        for (Map.Entry<String, String> argEntry : this.mInstrArgMap.entrySet()) {
            runner.addInstrumentationArg(argEntry.getKey(), argEntry.getValue());
        }
    }

    private void addTimeoutsToRunner(IRemoteAndroidTestRunner runner) {
        if (this.mTimeout != null) {
            LogUtil.CLog.w((String)"\"timeout\" argument is deprecated and should not be used! \"shell-timeout\" argument value is overwritten with %d ms", (Object[])new Object[]{this.mTimeout});
            this.setShellTimeout(this.mTimeout.intValue());
        }
        if (this.mTestTimeout < 0L) {
            throw new IllegalArgumentException(String.format("test-timeout %d cannot be negative", this.mTestTimeout));
        }
        if (this.mShellTimeout <= this.mTestTimeout) {
            this.mShellTimeout = this.mTestTimeout + this.mTestTimeout / 10L;
            LogUtil.CLog.w((String)String.format("shell-timeout should be larger than test-timeout %d; NOTE: extending shell-timeout to %d, please consider fixing this!", this.mTestTimeout, this.mShellTimeout));
        }
        runner.setMaxTimeToOutputResponse(this.mShellTimeout, TimeUnit.MILLISECONDS);
        runner.setMaxTimeout(this.mMaxTimeout, TimeUnit.MILLISECONDS);
        this.addInstrumentationArg(TEST_TIMEOUT_INST_ARGS_KEY, Long.toString(this.mTestTimeout));
    }

    private void doTestRun(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mCollectTestsOnly) {
            Preconditions.checkState(this.mTestsToRun == null, "Tests to run should not be set explicitly when --collect-tests-only is set.");
            Collection<TestDescription> collectedTests = this.collectTestsToRun(this.mRunner, listener);
            if (collectedTests == null) {
                LogUtil.CLog.e((String)"Failed to collect tests for %s", (Object[])new Object[]{this.mPackageName});
            } else {
                LogUtil.CLog.i((String)"Collected %d tests for %s", (Object[])new Object[]{collectedTests.size(), this.mPackageName});
            }
            return;
        }
        Collection<TestDescription> testsToRun = this.mTestsToRun;
        if (testsToRun == null) {
            testsToRun = this.collectTestsToRun(this.mRunner, null);
        }
        if (this.mDebug) {
            this.mRunner.setDebug(true);
        }
        if (this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageEnabled()) {
            this.mRunner.addInstrumentationArg("coverage", "true");
        }
        if (!this.mIsRerun) {
            listener = this.addBugreportListenerIfEnabled(listener);
            listener = this.addJavaCoverageListenerIfEnabled(listener);
            listener = this.addGcovCoverageListenerIfEnabled(listener);
            listener = this.addClangCoverageListenerIfEnabled(listener);
            if (this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageFlushEnabled()) {
                NativeCodeCoverageFlusher flusher;
                CoverageOptions options = this.mConfiguration.getCoverageOptions();
                if (options.getCoverageToolchains().contains(CoverageOptions.Toolchain.GCOV) || options.getCoverageToolchains().contains(CoverageOptions.Toolchain.CLANG)) {
                    Verify.verify(this.mDevice.enableAdbRoot(), "Failed to enable adb root.", new Object[0]);
                    flusher = new NativeCodeCoverageFlusher(this.mDevice, options.getCoverageProcesses());
                    flusher.resetCoverage();
                }
                if (options.getCoverageToolchains().contains(CoverageOptions.Toolchain.JACOCO)) {
                    flusher = new JavaCodeCoverageFlusher(this.mDevice, options.getCoverageProcesses());
                    flusher.resetCoverage();
                }
            }
            for (IMetricCollector collector : this.mCollectors) {
                if (collector.isDisabled()) {
                    LogUtil.CLog.d((String)"%s has been disabled. Skipping.", (Object[])new Object[]{collector});
                    continue;
                }
                LogUtil.CLog.d((String)"Initializing %s for instrumentation.", (Object[])new Object[]{collector.getClass().getCanonicalName()});
                listener = collector.init(testInfo.getContext(), listener);
            }
        }
        if (!this.mExtraDeviceListener.isEmpty()) {
            this.mRunner.addInstrumentationArg("listener", ArrayUtil.join((String)",", (Object[])new Object[]{this.mExtraDeviceListener}));
        }
        if (testsToRun == null) {
            this.mDevice.runInstrumentationTests(this.mRunner, new ITestLifeCycleReceiver[]{listener});
        } else if (!testsToRun.isEmpty()) {
            this.runWithRerun(testInfo, listener, testsToRun);
        } else {
            LogUtil.CLog.i((String)"No tests expected for %s, skipping", (Object[])new Object[]{this.mPackageName});
        }
        if (!this.mIsRerun && this.mMergeCoverageMeasurements) {
            listener.testRunStarted(MERGE_COVERAGE_MEASUREMENTS_TEST_NAME, 0);
            listener.testRunEnded(0L, new HashMap());
        }
    }

    ITestInvocationListener addBugreportListenerIfEnabled(ITestInvocationListener listener) {
        if (this.mBugreportFrequency != null) {
            BugreportCollector.Predicate pred = new BugreportCollector.Predicate(BugreportCollector.Relation.AFTER, this.mBugreportFrequency, BugreportCollector.Noun.FAILED_TESTCASE);
            BugreportCollector collector = new BugreportCollector(listener, this.getDevice());
            collector.addPredicate(pred);
            listener = collector;
        }
        return listener;
    }

    ITestInvocationListener addJavaCoverageListenerIfEnabled(ITestInvocationListener listener) {
        if (this.mConfiguration == null) {
            return listener;
        }
        if (this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains(CoverageOptions.Toolchain.JACOCO)) {
            return new JavaCodeCoverageListener(this.getDevice(), this.mConfiguration.getCoverageOptions(), this.mMergeCoverageMeasurements, listener);
        }
        return listener;
    }

    ITestInvocationListener addGcovCoverageListenerIfEnabled(ITestInvocationListener listener) {
        if (this.mConfiguration == null) {
            return listener;
        }
        if (this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains(CoverageOptions.Toolchain.GCOV)) {
            this.mNativeCoverageListener = new NativeCodeCoverageListener(this.getDevice(), this.mConfiguration.getCoverageOptions(), listener);
            return this.mNativeCoverageListener;
        }
        return listener;
    }

    ITestInvocationListener addClangCoverageListenerIfEnabled(ITestInvocationListener listener) {
        if (this.mConfiguration == null) {
            return listener;
        }
        if (this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains(CoverageOptions.Toolchain.CLANG)) {
            ClangCodeCoverageListener clangListener = new ClangCodeCoverageListener(this.getDevice(), listener);
            clangListener.setConfiguration(this.mConfiguration);
            return clangListener;
        }
        return listener;
    }

    private void runWithRerun(TestInformation testInfo, ITestInvocationListener listener, Collection<TestDescription> expectedTests) throws DeviceNotAvailableException {
        CollectingTestListener testTracker = new CollectingTestListener();
        InstrumentationListener instrumentationListener = new InstrumentationListener(this.getDevice(), expectedTests, new ITestInvocationListener[]{listener, testTracker});
        instrumentationListener.setDisableDuplicateCheck(this.mDisableDuplicateCheck);
        if (this.mEnableSoftRestartCheck) {
            instrumentationListener.setOriginalSystemServer(this.getDevice().getProcessByName("system_server"));
        }
        instrumentationListener.setReportUnexecutedTests(this.mReportUnexecuted);
        this.mDevice.runInstrumentationTests(this.mRunner, new ITestLifeCycleReceiver[]{instrumentationListener});
        TestRunResult testRun = testTracker.getCurrentRunResults();
        if (testRun.isRunFailure() || !testRun.getCompletedTests().containsAll(expectedTests)) {
            if (this.mConfiguration != null && !this.mConfiguration.getCoverageOptions().isCoverageEnabled()) {
                expectedTests.removeAll(InstrumentationTest.excludeNonExecuted(testTracker.getCurrentRunResults()));
                IRetryDecision decision = this.mConfiguration.getRetryDecision();
                if (!RetryStrategy.NO_RETRY.equals((Object)decision.getRetryStrategy()) && decision.getMaxRetryCount() > 1) {
                    return;
                }
            }
            this.rerunTests(expectedTests, testInfo, listener);
        }
    }

    protected static Set<TestDescription> excludeNonExecuted(TestRunResult results) {
        Set completedTest = results.getCompletedTests();
        for (Map.Entry entry : results.getTestResults().entrySet()) {
            if (!completedTest.contains(entry.getKey()) || ((TestResult)entry.getValue()).getFailure() == null || !TestRecordProto.FailureStatus.NOT_EXECUTED.equals((Object)((TestResult)entry.getValue()).getFailure().getFailureStatus())) continue;
            completedTest.remove(entry.getKey());
        }
        return completedTest;
    }

    private void rerunTests(Collection<TestDescription> expectedTests, TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (expectedTests.isEmpty()) {
            LogUtil.CLog.d((String)"No tests to re-run, all tests executed at least once.");
            return;
        }
        if (this.mRebootBeforeReRun) {
            this.mDevice.reboot();
        } else {
            this.mDevice.waitForDeviceAvailable();
        }
        IRemoteTest testReRunner = null;
        try {
            testReRunner = this.getTestReRunner(expectedTests);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e((String)"Failed to create test runner: %s", (Object[])new Object[]{e.getMessage()});
            return;
        }
        if (this.mNativeCoverageListener != null) {
            this.mNativeCoverageListener.setCollectOnTestEnd(false);
        }
        testReRunner.run(testInfo, listener);
        if (this.mNativeCoverageListener != null) {
            this.mNativeCoverageListener.setCollectOnTestEnd(true);
            this.mNativeCoverageListener.logCoverageMeasurements("rerun_merged");
        }
    }

    @VisibleForTesting
    IRemoteTest getTestReRunner(Collection<TestDescription> tests) throws ConfigurationException {
        if (this.mReRunUsingTestFile) {
            return new InstrumentationFileTest(this, tests, this.mFallbackToSerialRerun, this.mReRunUsingTestFileAttempts);
        }
        this.mInstrArgMap.remove(TEST_FILE_INST_ARGS_KEY);
        return new InstrumentationSerialTest(this, tests);
    }

    private Collection<TestDescription> collectTestsToRun(IRemoteAndroidTestRunner runner, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.isRerunMode()) {
            Log.d((String)LOG_TAG, (String)String.format("Collecting test info for %s on device %s", this.mPackageName, this.mDevice.getSerialNumber()));
            runner.setTestCollection(true);
            runner.setDebug(false);
            Collection<TestDescription> tests = this.collectTestsAndRetry(runner, listener);
            this.addTimeoutsToRunner(runner);
            runner.setTestCollection(false);
            return tests;
        }
        return null;
    }

    @VisibleForTesting
    Collection<TestDescription> collectTestsAndRetry(IRemoteAndroidTestRunner runner, ITestInvocationListener listener) throws DeviceNotAvailableException {
        boolean communicationFailure = false;
        for (int i = 0; i < 3; ++i) {
            CollectingTestListener collector = new CollectingTestListener();
            boolean instrResult = false;
            runner.setMaxTimeToOutputResponse(this.mCollectTestTimeout, TimeUnit.MILLISECONDS);
            instrResult = listener == null ? this.mDevice.runInstrumentationTests(runner, new ITestLifeCycleReceiver[]{collector}) : this.mDevice.runInstrumentationTests(runner, new ITestLifeCycleReceiver[]{collector, listener});
            TestRunResult runResults = collector.getCurrentRunResults();
            if (instrResult && runResults.isRunComplete()) {
                if (runResults.isRunFailure()) {
                    LogUtil.CLog.w((String)"Run failure %s when collecting tests to run for %s on device %s.", (Object[])new Object[]{runResults.getRunFailureMessage(), this.mPackageName, this.mDevice.getSerialNumber()});
                    return null;
                }
                return runResults.getCompletedTests();
            }
            Log.w((String)LOG_TAG, (String)String.format("No results when collecting tests to run for %s on device %s. Retrying", this.mPackageName, this.mDevice.getSerialNumber()));
            communicationFailure = true;
        }
        if (communicationFailure) {
            LogUtil.CLog.w((String)"Ignoring repeated communication failure when collecting tests %s for device %s", (Object[])new Object[]{this.mPackageName, this.mDevice.getSerialNumber()});
        }
        LogUtil.CLog.e((String)"Failed to collect tests to run for %s on device %s.", (Object[])new Object[]{this.mPackageName, this.mDevice.getSerialNumber()});
        return null;
    }

    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setMetricCollectors(List<IMetricCollector> collectors) {
        this.mCollectors = collectors;
    }

    public void setEnforceFormat(boolean enforce) {
        this.mShouldEnforceFormat = enforce;
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public boolean getDebug() {
        return this.mDebug;
    }

    public void setIsolatedStorage(boolean isolatedStorage) {
        this.mIsolatedStorage = isolatedStorage;
    }
}

