/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogcatCrashResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.ProcessInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

final class InstrumentationListener
extends LogcatCrashResultForwarder {
    private static final String DDMLIB_INSTRU_FAILURE_MSG = "Test run failed to complete";
    private Set<TestDescription> mTests = new HashSet<TestDescription>();
    private Set<TestDescription> mDuplicateTests = new HashSet<TestDescription>();
    private final Collection<TestDescription> mExpectedTests;
    private boolean mDisableDuplicateCheck = false;
    private boolean mReportUnexecutedTests = false;
    private ProcessInfo mSystemServerProcess = null;

    public InstrumentationListener(ITestDevice device, Collection<TestDescription> expectedTests, ITestInvocationListener ... listeners) {
        super(device, listeners);
        this.mExpectedTests = expectedTests;
    }

    public void setDisableDuplicateCheck(boolean disable) {
        this.mDisableDuplicateCheck = disable;
    }

    public void setOriginalSystemServer(ProcessInfo info) {
        this.mSystemServerProcess = info;
    }

    public void setReportUnexecutedTests(boolean enable) {
        this.mReportUnexecutedTests = enable;
    }

    public void testRunStarted(String runName, int testCount) {
        if (testCount == 0 && !this.mExpectedTests.isEmpty()) {
            LogUtil.CLog.e((String)"Run reported 0 tests while we collected %s", (Object[])new Object[]{this.mExpectedTests.size()});
            super.testRunStarted(runName, this.mExpectedTests.size());
        } else {
            super.testRunStarted(runName, testCount);
        }
    }

    public void testStarted(TestDescription test, long startTime) {
        super.testStarted(test, startTime);
        if (!this.mTests.add(test)) {
            this.mDuplicateTests.add(test);
        }
    }

    public void testRunFailed(FailureDescription error) {
        if (error.getErrorMessage().startsWith(DDMLIB_INSTRU_FAILURE_MSG)) {
            LinkedHashSet<TestDescription> expected = new LinkedHashSet<TestDescription>(this.mExpectedTests);
            expected.removeAll(this.mTests);
            String helpMessage = String.format("The following tests didn't run: %s", expected);
            error.setDebugHelpMessage(helpMessage);
            error.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
            if (this.mSystemServerProcess != null) {
                boolean restarted = false;
                try {
                    restarted = this.getDevice().deviceSoftRestarted(this.mSystemServerProcess);
                }
                catch (DeviceNotAvailableException deviceNotAvailableException) {
                    // empty catch block
                }
                if (restarted) {
                    error.setFailureStatus(TestRecordProto.FailureStatus.SYSTEM_UNDER_TEST_CRASHED);
                }
            }
        }
        super.testRunFailed(error);
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (!this.mDuplicateTests.isEmpty() && !this.mDisableDuplicateCheck) {
            FailureDescription error = FailureDescription.create((String)String.format("The following tests ran more than once: %s. Check your run configuration, you might be including the same test class several times.", this.mDuplicateTests));
            error.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
            super.testRunFailed(error);
        } else if (this.mReportUnexecutedTests && this.mExpectedTests.size() > this.mTests.size()) {
            LinkedHashSet<TestDescription> missingTests = new LinkedHashSet<TestDescription>(this.mExpectedTests);
            missingTests.removeAll(this.mTests);
            for (TestDescription miss : missingTests) {
                super.testStarted(miss);
                FailureDescription failure = FailureDescription.create((String)"test did not run due to instrumentation issue.", (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.NOT_EXECUTED);
                super.testFailed(miss, failure);
                super.testEnded(miss, new HashMap());
            }
        }
        super.testRunEnded(elapsedTime, runMetrics);
    }
}

