/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.CollectorHelper;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.BugreportCollector;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.AndroidJUnitTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.testtype.retry.IAutoRetriableTest;
import com.android.tradefed.util.ListInstrumentationParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@OptionClass(alias="installed-instrumentation")
public class InstalledInstrumentationsTest
implements IDeviceTest,
IShardableTest,
IMetricCollectorReceiver,
IAutoRetriableTest,
IConfigurationReceiver {
    private static final String PM_LIST_CMD = "pm list instrumentation";
    private static final String LINE_SEPARATOR = "\\r?\\n";
    private ITestDevice mDevice;
    @Option(name="shell-timeout", description="The defined timeout (in milliseconds) is used as a maximum waiting time when expecting the command output from the device. At any time, if the shell command does not output anything for a period longer than defined timeout the TF run terminates. For no timeout, set to 0.")
    private long mShellTimeout = 600000L;
    @Option(name="test-timeout", description="Sets timeout (in milliseconds) that will be applied to each test. In the event of a test timeout it will log the results and proceed with executing the next test. For no timeout, set to 0.")
    private int mTestTimeout = 300000;
    @Option(name="size", description="Restrict tests to a specific test size. One of 'small', 'medium', 'large'", importance=Option.Importance.IF_UNSET)
    private String mTestSize = null;
    @Option(name="runner", description="Restrict tests executed to a specific instrumentation class runner. Installed instrumentations that do not have this runner will be skipped.")
    private String mRunner = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete.")
    private boolean mIsRerunMode = true;
    @Option(name="resume", description="Schedule unexecuted tests for resumption on another device if first device becomes unavailable.")
    private boolean mIsResumeMode = false;
    @Deprecated
    @Option(name="send-coverage", description="Send coverage target info to test listeners.")
    private boolean mSendCoverage = false;
    @Option(name="bugreport-on-failure", description="Sets which failed testcase events cause a bugreport to be collected. a bugreport after failed testcases.  Note that there is _no feedback mechanism_ between the test runner and the bugreport collector, so use the EACH setting with due caution.")
    private BugreportCollector.Freq mBugreportFrequency = null;
    @Option(name="bugreport-on-run-failure", description="Take a bugreport if the instrumentation finish with a run failure")
    private boolean mBugreportOnRunFailure = false;
    @Option(name="screenshot-on-failure", description="Take a screenshot on every test failure")
    private boolean mScreenshotOnFailure = false;
    @Option(name="logcat-on-failure", description="take a logcat snapshot on every test failure.")
    private boolean mLogcatOnFailures = false;
    @Option(name="logcat-on-failure-size", description="The max number of logcat data in bytes to capture when --logcat-on-failure is on. Should be an amount that can comfortably fit in memory.")
    private int mMaxLogcatBytes = 512000;
    @Option(name="class", description="Only run tests in specified class")
    private String mTestClass = null;
    @Option(name="package", description="Only run tests within this specific java package. Will be ignored if --class is set.")
    private String mTestPackageName = null;
    @Option(name="instrumentation-arg", description="Additional instrumentation arguments to provide.")
    private Map<String, String> mInstrArgMap = new HashMap<String, String>();
    @Option(name="rerun-from-file", description="Use test file instead of separate adb commands for each test when re-running instrumentations for tests that failed to run in previous attempts. ")
    private boolean mReRunUsingTestFile = true;
    @Option(name="rerun-from-file-attempts", description="Max attempts to rerun tests from file. -1 means rerun from file infinitely.")
    private int mReRunUsingTestFileAttempts = -1;
    @Option(name="fallback-to-serial-rerun", description="Rerun tests serially after rerun from file failed.")
    private boolean mFallbackToSerialRerun = false;
    @Option(name="reboot-before-rerun", description="Reboot a device before re-running instrumentations.")
    private boolean mRebootBeforeReRun = false;
    @Option(name="disable", description="Disable the test by setting this flag to true.")
    private boolean mDisable = false;
    @Option(name="coverage", description="Collect code coverage for this test run. Note that the build under test must be a coverage build or else this will fail.")
    private boolean mCoverage = false;
    @Option(name="hidden-api-checks", description="If set to false, the '--no-hidden-api-checks' flag will be passed to the am instrument command. Only works for P or later.")
    private boolean mHiddenApiChecks = true;
    @Option(name="test-api-access", description="If set to false and hidden API checks are enabled, the '--no-test-api-access' flag will be passed to the am instrument command. Only works for R or later.")
    private boolean mTestApiAccess = true;
    @Option(name="isolated-storage", description="If set to false, the '--no-isolated-storage' flag will be passed to the am instrument command. Only works for Q or later.")
    private boolean mIsolatedStorage = true;
    @Option(name="window-animation", description="If set to false, the '--no-window-animation' flag will be passed to the am instrument command. Only works for ICS or later.")
    private boolean mWindowAnimation = true;
    @Option(name="disable-duplicate-test-check", description="If set to true, it will not check that a method is only run once by a given instrumentation.")
    private boolean mDisableDuplicateCheck = false;
    @Option(name="create-instrumentation-tests", description="Create InstrumentationTest type rather than more recent AndroidJUnitTest.")
    private boolean mDowngradeInstrumentation = false;
    private int mTotalShards = 0;
    private int mShardIndex = 0;
    private List<IMetricCollector> mMetricCollectorList = new ArrayList<IMetricCollector>();
    private IConfiguration mConfiguration;
    private List<InstrumentationTest> mTests = null;
    private Map<String, List<TestDescription>> mRunTestsFailureMap = null;
    @Option(name="force-abi", description="The abi to use, can be either 32 or 64.", importance=Option.Importance.IF_UNSET)
    private String mForceAbi = null;

    public boolean shouldRetry(int attemptJustExecuted, List<TestRunResult> previousResults) throws DeviceNotAvailableException {
        boolean retry = false;
        this.mRunTestsFailureMap = new HashMap<String, List<TestDescription>>();
        for (TestRunResult run : previousResults) {
            if (run == null) continue;
            if (run.isRunFailure()) {
                retry = true;
                this.mRunTestsFailureMap.put(run.getName(), null);
                continue;
            }
            if (!run.hasFailedTests()) continue;
            retry = true;
            this.mRunTestsFailureMap.put(run.getName(), new ArrayList(run.getFailedTests()));
        }
        if (!retry) {
            LogUtil.CLog.d((String)"No test run or test case failures. No need to retry.");
            this.mRunTestsFailureMap = null;
        }
        return retry;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    List<InstrumentationTest> getTests() {
        return this.mTests;
    }

    void setTotalShards(int totalShards) {
        this.mTotalShards = totalShards;
    }

    void setShardIndex(int shardIndex) {
        this.mShardIndex = shardIndex;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mDisable) {
            return;
        }
        this.buildTests();
        this.doRun(testInfo, listener);
    }

    private void buildTests() throws DeviceNotAvailableException {
        if (this.mTests == null) {
            ListInstrumentationParser parser = new ListInstrumentationParser();
            String pmListOutput = this.getDevice().executeShellCommand(PM_LIST_CMD);
            String[] pmListLines = pmListOutput.split(LINE_SEPARATOR);
            parser.processNewLines(pmListLines);
            if (parser.getInstrumentationTargets().isEmpty()) {
                throw new IllegalArgumentException(String.format("No instrumentations were found on device %s - <%s>", this.getDevice().getSerialNumber(), pmListOutput));
            }
            int numUnshardedTests = 0;
            this.mTests = new LinkedList<InstrumentationTest>();
            for (ListInstrumentationParser.InstrumentationTarget target : parser.getInstrumentationTargets()) {
                if (this.mRunner != null && !this.mRunner.equals(target.runnerName) || this.mTotalShards > 0 && !target.isShardable() && (++numUnshardedTests - 1) % this.mTotalShards != this.mShardIndex) continue;
                List collectors = CollectorHelper.cloneCollectors(this.mMetricCollectorList);
                InstrumentationTest t = this.createInstrumentationTest();
                try {
                    OptionCopier.copyOptions((Object)this, (Object)t);
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException("failed to copy instrumentation options", e);
                }
                t.setMetricCollectors(collectors);
                String targetPackageName = target.packageName;
                t.setPackageName(targetPackageName);
                if (this.mRunTestsFailureMap != null) {
                    if (!this.mRunTestsFailureMap.containsKey(targetPackageName)) {
                        LogUtil.CLog.d((String)"Skipping %s at retry.", (Object[])new Object[]{targetPackageName});
                        continue;
                    }
                    if (t instanceof AndroidJUnitTest) {
                        List<TestDescription> tests;
                        AndroidJUnitTest filterable = (AndroidJUnitTest)t;
                        if (this.mRunTestsFailureMap.containsKey(targetPackageName) && (tests = this.mRunTestsFailureMap.get(targetPackageName)) != null) {
                            for (TestDescription test : tests) {
                                filterable.addIncludeFilter(String.format("%s#%s", test.getClassName(), test.getTestNameWithoutParams()));
                            }
                        }
                    }
                }
                t.setRunnerName(target.runnerName);
                t.setCoverageTarget(target.targetName);
                if (this.mTotalShards > 0 && target.isShardable()) {
                    t.addInstrumentationArg("shardIndex", Integer.toString(this.mShardIndex));
                    t.addInstrumentationArg("numShards", Integer.toString(this.mTotalShards));
                }
                this.mTests.add(t);
            }
        }
    }

    private void doRun(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        while (!this.mTests.isEmpty()) {
            InstrumentationTest test = this.mTests.get(0);
            LogUtil.CLog.d((String)"Running test %s on %s", (Object[])new Object[]{test.getPackageName(), this.getDevice().getSerialNumber()});
            test.setDevice(this.getDevice());
            test.setConfiguration(this.mConfiguration);
            if (this.mTestClass != null) {
                test.setClassName(this.mTestClass);
                if (this.mTestPackageName != null) {
                    LogUtil.CLog.e((String)"Ignoring --package option with value '%s' since it's incompatible with using --class at the same time.", (Object[])new Object[]{this.mTestPackageName});
                }
            } else if (this.mTestPackageName != null) {
                test.setTestPackageName(this.mTestPackageName);
            }
            test.run(testInfo, listener);
            this.mTests.remove(0);
        }
        this.mTests = null;
    }

    long getShellTimeout() {
        return this.mShellTimeout;
    }

    int getTestTimeout() {
        return this.mTestTimeout;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    InstrumentationTest createInstrumentationTest() {
        InstrumentationTest test = null;
        test = this.mDowngradeInstrumentation ? new InstrumentationTest() : new AndroidJUnitTest();
        test.setEnforceFormat(false);
        return test;
    }

    public void setMetricCollectors(List<IMetricCollector> collectors) {
        this.mMetricCollectorList = collectors;
    }

    public Collection<IRemoteTest> split(int shardCountHint) {
        if (shardCountHint > 1) {
            ArrayList<IRemoteTest> shards = new ArrayList<IRemoteTest>(shardCountHint);
            for (int index = 0; index < shardCountHint; ++index) {
                shards.add(this.getTestShard(shardCountHint, index));
            }
            return shards;
        }
        return null;
    }

    private IRemoteTest getTestShard(int shardCount, int shardIndex) {
        InstalledInstrumentationsTest shard = new InstalledInstrumentationsTest();
        try {
            OptionCopier.copyOptions((Object)this, (Object)shard);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e((String)"failed to copy instrumentation options: %s", (Object[])new Object[]{e.getMessage()});
        }
        shard.mShardIndex = shardIndex;
        shard.mTotalShards = shardCount;
        return shard;
    }
}

