/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.GTestListTestParser;
import com.android.tradefed.testtype.GTestListener;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.GTestXmlResultParser;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class GTestBase
implements IRemoteTest,
IConfigurationReceiver,
ITestFilterReceiver,
IRuntimeHintProvider,
ITestCollector,
IShardableTest,
IAbiReceiver {
    private static final List<String> DEFAULT_FILE_EXCLUDE_FILTERS = new ArrayList<String>();
    @Option(name="run-disable-tests", description="Determine to run disable tests or not.")
    private boolean mRunDisabledTests = false;
    @Option(name="module-name", description="The name of the native test module to run.")
    private String mTestModule = null;
    @Option(name="file-exclusion-filter-regex", description="Regex to exclude certain files from executing. Can be repeated")
    private List<String> mFileExclusionFilterRegex = new ArrayList<String>(DEFAULT_FILE_EXCLUDE_FILTERS);
    @Option(name="positive-testname-filter", description="The GTest-based positive filter of the test name to run.")
    private String mTestNamePositiveFilter = null;
    @Option(name="negative-testname-filter", description="The GTest-based negative filter of the test name to run.")
    private String mTestNameNegativeFilter = null;
    @Option(name="include-filter", description="The GTest-based positive filter of the test names to run.")
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    @Option(name="exclude-filter", description="The GTest-based negative filter of the test names to run.")
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    @Option(name="native-test-timeout", description="The max time for a gtest to run. Test run will be aborted if any test takes longer.", isTimeVal=true)
    private long mMaxTestTimeMs = 60000L;
    @Deprecated
    @Option(name="coverage", description="Collect code coverage for this test run. Note that the build under test must be a coverage build or else this will fail.")
    private boolean mCoverage = false;
    @Option(name="prepend-filename", description="Prepend filename as part of the classname for the tests.")
    private boolean mPrependFileName = false;
    @Option(name="before-test-cmd", description="adb shell command(s) to run before GTest.")
    private List<String> mBeforeTestCmd = new ArrayList<String>();
    @Option(name="after-test-cmd", description="adb shell command(s) to run after GTest.")
    private List<String> mAfterTestCmd = new ArrayList<String>();
    @Option(name="run-test-as", description="User to execute test binary as.")
    private String mRunTestAs = null;
    @Option(name="ld-library-path", description="LD_LIBRARY_PATH value to include in the GTest execution command.")
    private String mLdLibraryPath = null;
    @Option(name="native-test-flag", description="Additional flag values to pass to the native test's shell command. Flags should be complete, including any necessary dashes: \"--flag=value\"")
    private List<String> mGTestFlags = new ArrayList<String>();
    @Option(name="runtime-hint", description="The hint about the test's runtime.", isTimeVal=true)
    private long mRuntimeHint = 60000L;
    @Option(name="xml-output", description="Use gtest xml output for test results, if test binaries crash, no output will be available.")
    private boolean mEnableXmlOutput = false;
    @Option(name="collect-tests-only", description="Only invoke the test binary to collect list of applicable test cases. All test run callbacks will be triggered, but test execution will not be actually carried out. This option ignores sharding parameters, so each shard will end up collecting all tests.")
    private boolean mCollectTestsOnly = false;
    @Option(name="test-filter-key", description="run the gtest with the --gtest_filter populated with the filter from the json filter file associated with the binary, the filter file will have the same name as the binary with the .json extension.")
    private String mTestFilterKey = null;
    @Option(name="disable-duplicate-test-check", description="If set to true, it will not check that a method is only run once.")
    private boolean mDisableDuplicateCheck = false;
    protected static final String GTEST_FLAG_PRINT_TIME = "--gtest_print_time";
    protected static final String GTEST_FLAG_FILTER = "--gtest_filter";
    protected static final String GTEST_FLAG_RUN_DISABLED_TESTS = "--gtest_also_run_disabled_tests";
    protected static final String GTEST_FLAG_LIST_TESTS = "--gtest_list_tests";
    protected static final String GTEST_FLAG_FILE = "--gtest_flagfile";
    protected static final String GTEST_XML_OUTPUT = "--gtest_output=xml:%s";
    @VisibleForTesting
    protected static final String FILTER_EXTENSION = ".filter";
    private int mShardCount = 0;
    private int mShardIndex = 0;
    private boolean mIsSharded = false;
    private IConfiguration mConfiguration = null;
    private IAbi mAbi;

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public void setModuleName(String moduleName) {
        this.mTestModule = moduleName;
    }

    public String getModuleName() {
        return this.mTestModule;
    }

    protected void setRunDisabled(boolean runDisabled) {
        this.mRunDisabledTests = runDisabled;
    }

    public boolean getRunDisabledTests() {
        return this.mRunDisabledTests;
    }

    @VisibleForTesting
    void setMaxTestTimeMs(int timeout) {
        this.mMaxTestTimeMs = timeout;
    }

    @VisibleForTesting
    void addFileExclusionFilterRegex(String regex) {
        this.mFileExclusionFilterRegex.add(regex);
    }

    public void setShardIndex(int shardIndex) {
        this.mShardIndex = shardIndex;
    }

    public int getShardIndex() {
        return this.mShardIndex;
    }

    public void setShardCount(int shardCount) {
        this.mShardCount = shardCount;
    }

    public int getShardCount() {
        return this.mShardCount;
    }

    public long getRuntimeHint() {
        return this.mRuntimeHint;
    }

    public void addIncludeFilter(String filter) {
        if (this.mShardCount > 0) {
            this.mShardCount = 0;
        }
        this.mIncludeFilters.add(this.cleanFilter(filter));
    }

    public void addAllIncludeFilters(Set<String> filters) {
        for (String filter : filters) {
            this.mIncludeFilters.add(this.cleanFilter(filter));
        }
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(this.cleanFilter(filter));
    }

    public void addAllExcludeFilters(Set<String> filters) {
        for (String filter : filters) {
            this.mExcludeFilters.add(this.cleanFilter(filter));
        }
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
        this.mTestFilterKey = null;
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public String getTestModule() {
        return this.mTestModule;
    }

    public List<String> getFileExclusionFilterRegex() {
        return this.mFileExclusionFilterRegex;
    }

    public long getMaxTestTimeMs() {
        return this.mMaxTestTimeMs;
    }

    public List<String> getBeforeTestCmd() {
        return this.mBeforeTestCmd;
    }

    public List<String> getAfterTestCmd() {
        return this.mAfterTestCmd;
    }

    public List<String> getGTestFlags() {
        return this.mGTestFlags;
    }

    public String getTestFilterKey() {
        return this.mTestFilterKey;
    }

    public boolean isEnableXmlOutput() {
        return this.mEnableXmlOutput;
    }

    public boolean isCollectTestsOnly() {
        return this.mCollectTestsOnly;
    }

    public boolean isSharded() {
        return this.mIsSharded;
    }

    protected abstract String loadFilter(String var1) throws DeviceNotAvailableException;

    protected String getGTestFilters(String path) throws DeviceNotAvailableException {
        String tmpFlag;
        String filterFlag;
        String fileFilters;
        StringBuilder filter = new StringBuilder();
        if (this.mTestNamePositiveFilter != null) {
            this.mIncludeFilters.add(this.mTestNamePositiveFilter);
        }
        if (this.mTestNameNegativeFilter != null) {
            this.mExcludeFilters.add(this.mTestNameNegativeFilter);
        }
        if (this.mTestFilterKey != null && (fileFilters = this.loadFilter(path)) != null && !fileFilters.isEmpty()) {
            if (fileFilters.startsWith("-")) {
                for (String filterString : fileFilters.substring(1).split(":")) {
                    this.mExcludeFilters.add(filterString);
                }
            } else {
                String[] filterStrings = fileFilters.split("-");
                for (String filterString : filterStrings[0].split(":")) {
                    this.mIncludeFilters.add(filterString);
                }
                if (filterStrings.length == 2) {
                    for (String filterString : filterStrings[1].split(":")) {
                        this.mExcludeFilters.add(filterString);
                    }
                }
            }
        }
        if (!this.mIncludeFilters.isEmpty() || !this.mExcludeFilters.isEmpty()) {
            filter.append(GTEST_FLAG_FILTER);
            filter.append("=");
            if (!this.mIncludeFilters.isEmpty()) {
                filter.append(ArrayUtil.join((String)":", (Object[])new Object[]{this.mIncludeFilters}));
            }
            if (!this.mExcludeFilters.isEmpty()) {
                filter.append("-");
                filter.append(ArrayUtil.join((String)":", (Object[])new Object[]{this.mExcludeFilters}));
            }
        }
        if ((filterFlag = filter.toString()).length() > 500 && (tmpFlag = this.createFlagFile(filterFlag)) != null) {
            return String.format("%s=%s", GTEST_FLAG_FILE, tmpFlag);
        }
        return filterFlag;
    }

    protected String createFlagFile(String filter) throws DeviceNotAvailableException {
        File tmpFlagFile = null;
        try {
            tmpFlagFile = FileUtil.createTempFile((String)"flagfile", (String)".txt");
            FileUtil.writeToFile((String)filter, (File)tmpFlagFile);
        }
        catch (IOException e) {
            FileUtil.deleteFile((File)tmpFlagFile);
            LogUtil.CLog.e((Throwable)e);
            return null;
        }
        return tmpFlagFile.getAbsolutePath();
    }

    protected String getAllGTestFlags(String path) throws DeviceNotAvailableException {
        String flags = String.format("%s %s", GTEST_FLAG_PRINT_TIME, this.getGTestFilters(path));
        if (this.getRunDisabledTests()) {
            flags = String.format("%s %s", flags, GTEST_FLAG_RUN_DISABLED_TESTS);
        }
        if (this.isCollectTestsOnly()) {
            flags = String.format("%s %s", flags, GTEST_FLAG_LIST_TESTS);
        }
        for (String gTestFlag : this.getGTestFlags()) {
            flags = String.format("%s %s", flags, gTestFlag);
        }
        return flags;
    }

    public String cleanFilter(String filter) {
        return filter.replace('#', '.');
    }

    @VisibleForTesting
    GTestXmlResultParser createXmlParser(String testRunName, ITestInvocationListener listener) {
        return new GTestXmlResultParser(testRunName, listener);
    }

    @VisibleForTesting
    IShellOutputReceiver createResultParser(String runName, ITestInvocationListener listener) {
        MultiLineReceiver receiver = null;
        if (this.mCollectTestsOnly) {
            GTestListTestParser resultParser = new GTestListTestParser(runName, listener);
            resultParser.setPrependFileName(this.mPrependFileName);
            receiver = resultParser;
        } else {
            GTestResultParser resultParser = new GTestResultParser(runName, listener);
            resultParser.setPrependFileName(this.mPrependFileName);
            receiver = resultParser;
        }
        this.erasePrependedFileName(this.mExcludeFilters, runName);
        this.erasePrependedFileName(this.mIncludeFilters, runName);
        return receiver;
    }

    protected String getGTestCmdLine(String fullPath, String flags) {
        StringBuilder gTestCmdLine = new StringBuilder();
        if (this.mLdLibraryPath != null) {
            gTestCmdLine.append(String.format("LD_LIBRARY_PATH=%s ", this.mLdLibraryPath));
        }
        if (this.getCoverageOptions().isCoverageEnabled()) {
            gTestCmdLine.append("GCOV_PREFIX=/data/misc/trace/testcoverage ");
        }
        if (this.mRunTestAs != null) {
            gTestCmdLine.append(String.format("su %s ", this.mRunTestAs));
        }
        gTestCmdLine.append(String.format("%s %s", fullPath, flags));
        return gTestCmdLine.toString();
    }

    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    public Collection<IRemoteTest> split(int shardCountHint) {
        if (shardCountHint <= 1 || this.mIsSharded) {
            return null;
        }
        if (this.mCollectTestsOnly) {
            return null;
        }
        ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>();
        for (int i = 0; i < shardCountHint; ++i) {
            tests.add(this.getTestShard(shardCountHint, i));
        }
        return tests;
    }

    protected String getExceptionMessage(Exception e) {
        StringBuilder msgBuilder = new StringBuilder();
        if (e.getMessage() != null) {
            msgBuilder.append(e.getMessage());
        }
        if (e.getCause() != null) {
            msgBuilder.append(" cause:");
            msgBuilder.append(e.getCause().getClass().getSimpleName());
            if (e.getCause().getMessage() != null) {
                msgBuilder.append(" (");
                msgBuilder.append(e.getCause().getMessage());
                msgBuilder.append(")");
            }
        }
        return msgBuilder.toString();
    }

    protected void erasePrependedFileName(Set<String> filters, String filename) {
        if (!this.mPrependFileName) {
            return;
        }
        LinkedHashSet<String> copy = new LinkedHashSet<String>();
        for (String filter : filters) {
            if (filter.startsWith(filename + ".")) {
                copy.add(filter.substring(filename.length() + 1));
                continue;
            }
            copy.add(filter);
        }
        filters.clear();
        filters.addAll(copy);
    }

    private IRemoteTest getTestShard(int shardCount, int shardIndex) {
        GTestBase shard = null;
        try {
            shard = (GTestBase)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            OptionCopier.copyOptionsNoThrow((Object)this, (Object)shard);
            shard.mShardIndex = shardIndex;
            shard.mShardCount = shardCount;
            shard.mIsSharded = true;
            shard.mRuntimeHint = this.mRuntimeHint / (long)shardCount;
            shard.mAbi = this.mAbi;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("%s (%s) when attempting to create shard object", e.getClass().getSimpleName(), this.getExceptionMessage(e)));
        }
        return shard;
    }

    protected IConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    protected CoverageOptions getCoverageOptions() {
        if (this.mConfiguration != null) {
            return this.mConfiguration.getCoverageOptions();
        }
        return new CoverageOptions();
    }

    protected ITestInvocationListener getGTestListener(ITestInvocationListener listener) {
        if (this.mDisableDuplicateCheck) {
            return listener;
        }
        return new GTestListener(listener);
    }

    static {
        DEFAULT_FILE_EXCLUDE_FILTERS.add(".*\\.so");
    }
}

