/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.ClangCodeCoverageListener;
import com.android.tradefed.testtype.GTestBase;
import com.android.tradefed.testtype.GTestXmlResultParser;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.NativeCodeCoverageListener;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="gtest")
public class GTest
extends GTestBase
implements IDeviceTest {
    static final String DEFAULT_NATIVETEST_PATH = "/data/nativetest";
    private ITestDevice mDevice = null;
    @Option(name="native-test-device-path", description="The path on the device where native tests are located.")
    private String mNativeTestDevicePath = "/data/nativetest";
    @Option(name="reboot-before-test", description="Reboot the device before the test suite starts.")
    private boolean mRebootBeforeTest = false;
    @Option(name="stop-runtime", description="Stops the Java application runtime before test execution.")
    private boolean mStopRuntime = false;
    @Deprecated
    @Option(name="coverage-flush", description="Forces coverage data to be flushed at the end of the test.")
    private boolean mCoverageFlush = false;
    @Deprecated
    @Option(name="coverage-processes", description="Name of processes to collect coverage data from.")
    private List<String> mCoverageProcesses = new ArrayList<String>();
    @Deprecated
    @Option(name="coverage-clear-before-test", description="Clears all coverage counters before test execution.")
    private boolean mCoverageClearBeforeTest = true;
    @Option(name="filter-non-matching-abi-folders", description="If an abi specific hierarchy seem to exists, only run the parts that match abi under test.")
    private boolean mFilterAbiFolders = true;
    private static final int GTEST_CMD_CHAR_LIMIT = 1000;

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    protected String loadFilter(String binaryOnDevice) throws DeviceNotAvailableException {
        try {
            String filterKey = this.getTestFilterKey();
            LogUtil.CLog.i((String)"Loading filter from file for key: '%s'", (Object[])new Object[]{filterKey});
            String filterFile = String.format("%s%s", binaryOnDevice, ".filter");
            if (this.getDevice().doesFileExist(filterFile)) {
                String content = this.getDevice().executeShellCommand(String.format("cat \"%s\"", filterFile));
                if (content != null && !content.isEmpty()) {
                    JSONObject filter = new JSONObject(content);
                    JSONObject filterObject = filter.getJSONObject(filterKey);
                    return filterObject.getString("filter");
                }
                LogUtil.CLog.e((String)"Error with content of the filter file %s: %s", (Object[])new Object[]{filterFile, content});
            } else {
                LogUtil.CLog.e((String)"Filter file %s not found", (Object[])new Object[]{filterFile});
            }
        }
        catch (JSONException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        return null;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mNativeTestDevicePath);
        String testModule = this.getTestModule();
        if (testModule != null) {
            testPath.append("/");
            testPath.append(testModule);
        }
        return testPath.toString();
    }

    @VisibleForTesting
    void doRunAllTestsInSubdirectory(String root, ITestDevice testDevice, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (testDevice.isDirectory(root)) {
            if (!this.shouldRunFolder(root)) {
                return;
            }
            for (String child : testDevice.getChildren(root)) {
                this.doRunAllTestsInSubdirectory(root + "/" + child, testDevice, listener);
            }
        } else {
            IShellOutputReceiver resultParser = this.createResultParser(this.getFileName(root), listener);
            if (this.shouldSkipFile(root)) {
                return;
            }
            String flags = this.getAllGTestFlags(root);
            LogUtil.CLog.i((String)"Running gtest %s %s on %s", (Object[])new Object[]{root, flags, testDevice.getSerialNumber()});
            if (this.isEnableXmlOutput()) {
                this.runTestXml(testDevice, root, flags, listener);
            } else {
                this.runTest(testDevice, resultParser, root, flags);
            }
        }
    }

    boolean shouldRunFolder(String path) {
        if (!this.mFilterAbiFolders) {
            return true;
        }
        if (this.getAbi() == null) {
            return true;
        }
        String fileName = this.getFileName(path);
        if (!AbiUtils.getArchSupported().contains(fileName)) {
            return true;
        }
        return fileName.equals(AbiUtils.getArchForAbi((String)this.getAbi().getName()));
    }

    String getFileName(String fullPath) {
        int pos = fullPath.lastIndexOf(47);
        if (pos == -1) {
            return fullPath;
        }
        String fileName = fullPath.substring(pos + 1);
        if (fileName.isEmpty()) {
            throw new IllegalArgumentException("input should not end with \"/\"");
        }
        return fileName;
    }

    protected boolean shouldSkipFile(String fullPath) throws DeviceNotAvailableException {
        if (fullPath == null || fullPath.isEmpty()) {
            return true;
        }
        if (!this.mDevice.isExecutable(fullPath)) {
            return true;
        }
        List<String> fileExclusionFilterRegex = this.getFileExclusionFilterRegex();
        if (fileExclusionFilterRegex == null || fileExclusionFilterRegex.isEmpty()) {
            return false;
        }
        for (String regex : fileExclusionFilterRegex) {
            if (!fullPath.matches(regex)) continue;
            LogUtil.CLog.i((String)"File %s matches exclusion file regex %s, skipping", (Object[])new Object[]{fullPath, regex});
            return true;
        }
        return false;
    }

    protected void executeCommandByScript(ITestDevice testDevice, String cmd, IShellOutputReceiver resultParser) throws DeviceNotAvailableException {
        String tmpFileDevice = "/data/local/tmp/gtest_script.sh";
        testDevice.pushString(String.format("#!/bin/bash\n%s", cmd), tmpFileDevice);
        testDevice.executeShellCommand(String.format("chmod 755 %s", tmpFileDevice));
        testDevice.executeShellCommand(String.format("sh %s", tmpFileDevice), resultParser, this.getMaxTestTimeMs(), TimeUnit.MILLISECONDS, 0);
        testDevice.deleteFile(tmpFileDevice);
    }

    @Override
    protected String getGTestCmdLine(String fullPath, String flags) {
        StringBuilder sb = new StringBuilder();
        if (this.getShardCount() > 0) {
            if (this.isCollectTestsOnly()) {
                LogUtil.CLog.w((String)"--collect-tests-only option ignores sharding parameters, and will cause each shard to collect all tests.");
            }
            sb.append(String.format("GTEST_SHARD_INDEX=%s ", this.getShardIndex()));
            sb.append(String.format("GTEST_TOTAL_SHARDS=%s ", this.getShardCount()));
        }
        sb.append(super.getGTestCmdLine(fullPath, flags));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String createFlagFile(String filter) throws DeviceNotAvailableException {
        String flagPath = super.createFlagFile(filter);
        if (flagPath == null) {
            return null;
        }
        File flagFile = new File(flagPath);
        String devicePath = "/data/local/tmp/" + flagFile.getName();
        try {
            if (!this.mDevice.pushFile(flagFile, devicePath)) {
                String string = null;
                return string;
            }
        }
        finally {
            FileUtil.deleteFile((File)flagFile);
        }
        return devicePath;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runTest(ITestDevice testDevice, IShellOutputReceiver resultParser, String fullPath, String flags) throws DeviceNotAvailableException {
        Object cmd;
        try {
            for (String cmd2 : this.getBeforeTestCmd()) {
                testDevice.executeShellCommand(cmd2);
            }
            if (this.mRebootBeforeTest && !this.isCollectTestsOnly()) {
                LogUtil.CLog.d((String)"Rebooting device before test starts as requested.");
                testDevice.reboot();
            }
            if (((String)(cmd = this.getGTestCmdLine(fullPath, flags))).length() < 1000) {
                testDevice.executeShellCommand((String)cmd, resultParser, this.getMaxTestTimeMs(), TimeUnit.MILLISECONDS, 0);
            } else {
                this.executeCommandByScript(testDevice, (String)cmd, resultParser);
            }
        }
        catch (DeviceNotAvailableException e) {
            try {
                throw e;
                catch (RuntimeException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                resultParser.flush();
                Iterator<String> iterator = this.getAfterTestCmd().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    String cmd3 = iterator.next();
                    testDevice.executeShellCommand(cmd3);
                }
            }
        }
        resultParser.flush();
        cmd = this.getAfterTestCmd().iterator();
        while (cmd.hasNext()) {
            String cmd2;
            cmd2 = (String)cmd.next();
            testDevice.executeShellCommand(cmd2);
        }
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runTestXml(ITestDevice testDevice, String fullPath, String flags, ITestInvocationListener listener) throws DeviceNotAvailableException {
        Object testRunName;
        CollectingOutputReceiver outputCollector = new CollectingOutputReceiver();
        File tmpOutput = null;
        try {
            testRunName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
            tmpOutput = FileUtil.createTempFile((String)testRunName, (String)".xml");
            String tmpResName = fullPath + "_res.xml";
            String extraFlag = String.format("--gtest_output=xml:%s", tmpResName);
            String fullFlagCmd = String.format("%s %s", flags, extraFlag);
            this.runTest(testDevice, (IShellOutputReceiver)outputCollector, fullPath, fullFlagCmd);
            testDevice.pullFile(tmpResName, tmpOutput);
            testDevice.deleteFile(tmpResName);
            GTestXmlResultParser parser = this.createXmlParser((String)testRunName, listener);
            if (tmpOutput.exists()) {
                parser.parseResult(tmpOutput, outputCollector);
            }
        }
        catch (DeviceNotAvailableException | RuntimeException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                outputCollector.flush();
                Iterator<String> iterator = this.getAfterTestCmd().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        FileUtil.deleteFile((File)tmpOutput);
                        throw throwable;
                    }
                    String cmd = iterator.next();
                    testDevice.executeShellCommand(cmd);
                }
            }
        }
        outputCollector.flush();
        testRunName = this.getAfterTestCmd().iterator();
        while (true) {
            if (!testRunName.hasNext()) {
                FileUtil.deleteFile((File)tmpOutput);
                return;
            }
            String cmd = (String)testRunName.next();
            testDevice.executeShellCommand(cmd);
        }
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        if (!this.mDevice.doesFileExist(testPath)) {
            LogUtil.CLog.w((String)"Could not find native test directory %s in %s!", (Object[])new Object[]{testPath, this.mDevice.getSerialNumber()});
            return;
        }
        if (this.mStopRuntime) {
            this.mDevice.executeShellCommand("stop");
        }
        listener = this.addNativeCoverageListenerIfEnabled(listener);
        listener = this.addClangCoverageListenerIfEnabled(listener);
        listener = this.getGTestListener(listener);
        NativeCodeCoverageFlusher flusher = new NativeCodeCoverageFlusher(this.mDevice, this.getCoverageOptions().getCoverageProcesses());
        Throwable throwable = null;
        try {
            if (this.getCoverageOptions().isCoverageEnabled()) {
                Verify.verify(this.mDevice.enableAdbRoot(), "Failed to enable adb root.", new Object[0]);
                flusher.resetCoverage();
                this.mDevice.executeShellCommand("mkdir /data/misc/trace/testcoverage");
            }
            this.doRunAllTestsInSubdirectory(testPath, this.mDevice, listener);
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            if (!(throwable instanceof DeviceNotAvailableException) && this.mStopRuntime) {
                this.mDevice.executeShellCommand("start");
                this.mDevice.waitForDeviceAvailable();
            }
        }
    }

    private ITestInvocationListener addNativeCoverageListenerIfEnabled(ITestInvocationListener listener) {
        CoverageOptions options = this.getCoverageOptions();
        if (options.isCoverageEnabled() && options.getCoverageToolchains().contains(CoverageOptions.Toolchain.GCOV)) {
            return new NativeCodeCoverageListener(this.mDevice, options, listener);
        }
        return listener;
    }

    private ITestInvocationListener addClangCoverageListenerIfEnabled(ITestInvocationListener listener) {
        CoverageOptions options = this.getCoverageOptions();
        if (options.isCoverageEnabled() && options.getCoverageToolchains().contains(CoverageOptions.Toolchain.CLANG)) {
            ClangCodeCoverageListener clangListener = new ClangCodeCoverageListener(this.mDevice, listener);
            clangListener.setConfiguration(this.getConfiguration());
            return clangListener;
        }
        return listener;
    }
}

