/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.companion;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.companion.CompanionAwarePreparer;
import com.android.tradefed.util.BluetoothUtils;
import java.util.Set;

public class CheckPairingPreparer
extends CompanionAwarePreparer {
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        String primaryMac = BluetoothUtils.getBluetoothMac((ITestDevice)device);
        String companionMac = BluetoothUtils.getBluetoothMac((ITestDevice)this.getCompanion(device));
        Set primaryBonded = BluetoothUtils.getBondedDevices((ITestDevice)device);
        Set companionBonded = BluetoothUtils.getBondedDevices((ITestDevice)this.getCompanion(device));
        boolean primaryHasCompanion = primaryBonded.contains(companionMac);
        boolean companionHasPrimary = companionBonded.contains(primaryMac);
        if (!primaryHasCompanion || !companionHasPrimary) {
            throw new TargetSetupError(String.format("device bonding error: primaryHasCompanion=%s, companionHasPrimary=%s", primaryHasCompanion, companionHasPrimary), device.getDeviceDescriptor());
        }
    }
}

