/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.base.MoreObjects;

@OptionClass(alias="user-cleaner")
public class UserCleaner
extends BaseTargetPreparer {
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        int ownerId = MoreObjects.firstNonNull(device.getPrimaryUserId(), device.getCurrentUser());
        device.switchUser(ownerId);
        for (Integer id : device.listUsers()) {
            if (id == ownerId || device.removeUser(id.intValue())) continue;
            LogUtil.CLog.w((String)"Failed to remove user %d", (Object[])new Object[]{id});
        }
    }
}

