/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.DefaultTestsZipInstaller;
import com.android.tradefed.targetprep.IDeviceFlasher;
import com.android.tradefed.targetprep.IFlashingResourcesRetriever;
import com.android.tradefed.targetprep.ITestsZipInstaller;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SystemUpdaterDeviceFlasher
implements IDeviceFlasher {
    private ITestsZipInstaller mTestsZipInstaller = new DefaultTestsZipInstaller();
    private IDeviceFlasher.UserDataFlashOption mFlashOption = IDeviceFlasher.UserDataFlashOption.TESTS_ZIP;
    private boolean mForceSystemFlash;
    private Collection<String> mDataWipeSkipList = new ArrayList<String>();

    public void setFlashingResourcesRetriever(IFlashingResourcesRetriever retriever) {
    }

    public void flash(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.i((String)"Flashing device %s  with build %s", (Object[])new Object[]{device.getSerialNumber(), deviceBuild.getDeviceBuildId()});
        if (this.installUpdate(device, deviceBuild) && this.mFlashOption == IDeviceFlasher.UserDataFlashOption.TESTS_ZIP) {
            this.mTestsZipInstaller.pushTestsZipOntoData(device, deviceBuild);
            LogUtil.CLog.d((String)"rebooting after installing tests");
            device.reboot();
        }
    }

    private boolean installUpdate(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        if (!this.mForceSystemFlash && deviceBuild.getDeviceBuildId().equals(device.getBuildId())) {
            LogUtil.CLog.i((String)"System is already version %s, skipping install", (Object[])new Object[]{device.getBuildId()});
            return false;
        }
        LogUtil.CLog.i((String)"Flashing system %s on device %s", (Object[])new Object[]{deviceBuild.getDeviceBuildId(), device.getSerialNumber()});
        File otaPackageFile = deviceBuild.getOtaPackageFile();
        if (otaPackageFile == null) {
            throw new TargetSetupError("No OTA package file present for build " + deviceBuild.getDeviceBuildId(), device.getDeviceDescriptor());
        }
        if (!device.pushFile(otaPackageFile, "/cache/update.zip")) {
            throw new TargetSetupError("Could not push OTA file to the target.", device.getDeviceDescriptor());
        }
        String commands = "echo --update_package > /cache/recovery/command &&echo /cache/update.zip >> /cache/recovery/command";
        device.executeShellCommand(commands);
        device.rebootIntoRecovery();
        device.waitForDeviceAvailable();
        return true;
    }

    void setTestsZipInstaller(ITestsZipInstaller testsZipInstaller) {
        this.mTestsZipInstaller = testsZipInstaller;
    }

    public void overrideDeviceOptions(ITestDevice device) {
    }

    public void setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption flashOption) {
        List<IDeviceFlasher.UserDataFlashOption> supported = Arrays.asList(IDeviceFlasher.UserDataFlashOption.TESTS_ZIP, IDeviceFlasher.UserDataFlashOption.RETAIN);
        if (!supported.contains(flashOption)) {
            throw new IllegalArgumentException(flashOption + " not supported. This implementation only supports flashing " + supported.toString());
        }
        this.mFlashOption = flashOption;
    }

    public IDeviceFlasher.UserDataFlashOption getUserDataFlashOption() {
        return this.mFlashOption;
    }

    public void setForceSystemFlash(boolean forceSystemFlash) {
        this.mForceSystemFlash = forceSystemFlash;
    }

    public void setDataWipeSkipList(Collection<String> dataWipeSkipList) {
        if (dataWipeSkipList != null) {
            this.mDataWipeSkipList = dataWipeSkipList;
        }
        if (this.mTestsZipInstaller != null) {
            this.mTestsZipInstaller.setDataWipeSkipList(this.mDataWipeSkipList);
        }
    }

    public void setWipeTimeout(long timeout) {
    }

    public CommandStatus getSystemFlashingStatus() {
        return null;
    }
}

