/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import java.util.ArrayList;
import java.util.Collection;

public class StopServicesSetup
extends BaseTargetPreparer {
    @Option(name="stop-framework", description="stop the framework. Default true.")
    private boolean mStopFramework = true;
    @Option(name="service", description="the service to stop on the device. Can be repeated.")
    private Collection<String> mServices = new ArrayList<String>();

    public void setUp(TestInformation testInfo) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (this.mStopFramework) {
            device.executeShellCommand("stop");
        }
        for (String service : this.mServices) {
            device.executeShellCommand(String.format("stop %s", service));
        }
    }

    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInformation.getDevice();
        if (this.mStopFramework) {
            device.executeShellCommand("start");
            device.waitForDeviceAvailable();
        }
        for (String service : this.mServices) {
            device.executeShellCommand(String.format("start %s", service));
        }
    }

    public void setStopFramework(boolean stopFramework) {
        this.mStopFramework = stopFramework;
    }

    public void addService(String service) {
        this.mServices.add(service);
    }
}

