/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@OptionClass(alias="run-host-script")
public class RunHostScriptTargetPreparer
extends BaseTargetPreparer {
    @Option(name="script-file", description="Path to the script to execute.")
    private String mScriptPath = null;
    @Option(name="work-dir", description="Working directory to use when executing script.")
    private File mWorkDir = null;
    @Option(name="script-timeout", description="Script execution timeout.")
    private Duration mTimeout = Duration.ofMinutes(1L);
    private IRunUtil mRunUtil;

    public final void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mScriptPath == null) {
            LogUtil.CLog.w((String)"No script to execute.");
            return;
        }
        ITestDevice device = testInfo.getDevice();
        File scriptFile = this.findScriptFile(testInfo);
        if (scriptFile == null || !scriptFile.isFile()) {
            throw new TargetSetupError(String.format("File %s not found.", this.mScriptPath), device.getDeviceDescriptor());
        }
        if (!scriptFile.canExecute()) {
            scriptFile.setExecutable(true);
        }
        this.getRunUtil().setWorkingDir(this.mWorkDir);
        this.getRunUtil().setEnvVariable("ANDROID_SERIAL", device.getSerialNumber());
        this.setPathVariable(testInfo);
        CommandResult result = this.getRunUtil().runTimedCmd(this.mTimeout.toMillis(), new String[]{scriptFile.getAbsolutePath()});
        switch (result.getStatus()) {
            case SUCCESS: {
                LogUtil.CLog.i((String)"Script executed successfully, stdout = [%s].", (Object[])new Object[]{result.getStdout()});
                break;
            }
            case FAILED: {
                throw new TargetSetupError(String.format("Script execution failed, stdout = [%s], stderr = [%s].", result.getStdout(), result.getStderr()), device.getDeviceDescriptor());
            }
            case TIMED_OUT: {
                throw new TargetSetupError("Script execution timed out.", device.getDeviceDescriptor());
            }
            case EXCEPTION: {
                throw new TargetSetupError(String.format("Exception during script execution, stdout = [%s], stderr = [%s].", result.getStdout(), result.getStderr()), device.getDeviceDescriptor());
            }
        }
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    @VisibleForTesting
    IDeviceManager getDeviceManager() {
        return GlobalConfiguration.getDeviceManagerInstance();
    }

    @Nullable
    private File findScriptFile(TestInformation testInfo) {
        File scriptFile = new File(this.mScriptPath);
        if (scriptFile.isAbsolute()) {
            return scriptFile;
        }
        if (this.mWorkDir != null && (scriptFile = new File(this.mWorkDir, this.mScriptPath)).isFile()) {
            return scriptFile;
        }
        try {
            return testInfo.getDependencyFile(this.mScriptPath, false);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private void setPathVariable(TestInformation testInfo) {
        File fastbootBinary;
        String fastbootPath;
        String adbPath;
        ArrayList<String> paths = new ArrayList<String>();
        File adbBinary = testInfo.executionFiles().get(ExecutionFiles.FilesKey.ADB_BINARY);
        if (adbBinary == null && !(adbPath = this.getDeviceManager().getAdbPath()).equals("adb")) {
            adbBinary = new File(adbPath);
        }
        if (adbBinary != null && adbBinary.isFile()) {
            paths.add(adbBinary.getParentFile().getAbsolutePath());
        }
        if (!(fastbootPath = this.getDeviceManager().getFastbootPath()).equals("fastboot") && (fastbootBinary = new File(fastbootPath)).isFile()) {
            paths.add(fastbootBinary.getParentFile().getAbsolutePath());
        }
        if (!paths.isEmpty()) {
            String separator = System.getProperty("path.separator");
            paths.add(System.getenv("PATH"));
            String path = paths.stream().distinct().collect(Collectors.joining(separator));
            LogUtil.CLog.d((String)"Using updated $PATH: %s", (Object[])new Object[]{path});
            this.getRunUtil().setEnvVariable("PATH", path);
        }
    }
}

