/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="root-preparer")
public final class RootTargetPreparer
extends BaseTargetPreparer {
    private boolean mWasRoot = false;
    @Option(name="force-root", description="Force the preparer to enable adb root if set to true. Otherwise, disable adb root during setup.")
    private boolean mForceRoot = true;
    @Option(name="throw-on-error", description="Throws TargetSetupError if adb root/unroot fails")
    private boolean mThrowOnError = true;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
        this.mWasRoot = device.isAdbRoot();
        if (!this.mWasRoot && this.mForceRoot && !device.enableAdbRoot()) {
            this.throwOrLog("Failed to adb root device", device.getDeviceDescriptor());
        } else if (this.mWasRoot && !this.mForceRoot && !device.disableAdbRoot()) {
            this.throwOrLog("Failed to adb unroot device", device.getDeviceDescriptor());
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
        if (!this.mWasRoot && this.mForceRoot) {
            device.disableAdbRoot();
        } else if (this.mWasRoot && !this.mForceRoot) {
            device.enableAdbRoot();
        }
    }

    private void throwOrLog(String message, DeviceDescriptor deviceDescriptor) throws TargetSetupError {
        if (this.mThrowOnError) {
            throw new TargetSetupError(message, deviceDescriptor, (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        LogUtil.CLog.w((String)(message + " " + deviceDescriptor));
    }
}

