/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="python-venv")
public class PythonVirtualenvPreparer
extends BaseTargetPreparer {
    private static final String PIP = "pip";
    private static final String PATH = "PATH";
    protected static final String PYTHONPATH = "PYTHONPATH";
    private static final int BASE_TIMEOUT = 60000;
    @Option(name="venv-dir", description="path of an existing virtualenv to use")
    private File mVenvDir = null;
    @Option(name="requirements-file", description="pip-formatted requirements file")
    private File mRequirementsFile = null;
    @Option(name="dep-module", description="modules which need to be installed by pip")
    private List<String> mDepModules = new ArrayList<String>();
    IRunUtil mRunUtil = new RunUtil();
    String mPip = "pip";

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.isDisabled()) {
            LogUtil.CLog.i((String)"Skipping PythonVirtualenvPreparer");
            return;
        }
        this.startVirtualenv(buildInfo, device);
        this.installDeps(buildInfo, device);
    }

    protected void installDeps(IBuildInfo buildInfo, ITestDevice device) throws TargetSetupError {
        boolean hasDependencies = false;
        if (this.mRequirementsFile != null) {
            CommandResult c = this.mRunUtil.runTimedCmd(300000L, new String[]{this.mPip, "install", "-r", this.mRequirementsFile.getAbsolutePath()});
            if (c.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e((String)"Installing dependencies from %s failed", (Object[])new Object[]{this.mRequirementsFile.getAbsolutePath()});
                throw new TargetSetupError("Failed to install dependencies with pip", device.getDeviceDescriptor());
            }
            hasDependencies = true;
        }
        if (!this.mDepModules.isEmpty()) {
            for (String dep : this.mDepModules) {
                LogUtil.CLog.i((String)"Attempting installation of %s", (Object[])new Object[]{dep});
                CommandResult c = this.mRunUtil.runTimedCmd(300000L, new String[]{this.mPip, "install", dep});
                if (c.getStatus() != CommandStatus.SUCCESS) {
                    LogUtil.CLog.e((String)"Installing %s failed", (Object[])new Object[]{dep});
                    throw new TargetSetupError("Failed to install dependencies with pip", device.getDeviceDescriptor());
                }
                hasDependencies = true;
            }
        }
        if (!hasDependencies) {
            LogUtil.CLog.i((String)"No dependencies to install");
        } else {
            buildInfo.setFile(PYTHONPATH, new File(this.mVenvDir, "local/lib/python2.7/site-packages"), buildInfo.getBuildId());
        }
    }

    protected void startVirtualenv(IBuildInfo buildInfo, ITestDevice device) throws TargetSetupError {
        if (this.mVenvDir != null) {
            LogUtil.CLog.i((String)"Using existing virtualenv based at %s", (Object[])new Object[]{this.mVenvDir.getAbsolutePath()});
            this.activate();
            return;
        }
        try {
            this.mVenvDir = FileUtil.createNamedTempDir((String)(buildInfo.getTestTag() + "-virtualenv"));
            this.mRunUtil.runTimedCmd(60000L, new String[]{"virtualenv", this.mVenvDir.getAbsolutePath()});
            this.activate();
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to create temp directory for virtualenv");
            throw new TargetSetupError("Error creating virtualenv", (Throwable)e, device.getDeviceDescriptor());
        }
    }

    protected void addDepModule(String module) {
        this.mDepModules.add(module);
    }

    protected void setRequirementsFile(File f) {
        this.mRequirementsFile = f;
    }

    private void activate() {
        File binDir = new File(this.mVenvDir, "bin");
        this.mRunUtil.setWorkingDir(binDir);
        String path = System.getenv(PATH);
        this.mRunUtil.setEnvVariable(PATH, binDir + ":" + path);
        File pipFile = new File(binDir, PIP);
        pipFile.setExecutable(true);
        this.mPip = pipFile.getAbsolutePath();
    }
}

