/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@OptionClass(alias="install-apk-from-env")
public class InstallBuildEnvApkSetup
extends BaseTargetPreparer {
    private static final String APK_SUFFIX = ".apk";
    @Option(name="apk-name", description="the file name of the apk to install. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mApkNames = new ArrayList<String>();

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        File testAppDir = this.getDataAppDirFromBuildEnv(device);
        Iterator<String> iterator = this.mApkNames.iterator();
        while (iterator.hasNext()) {
            String apkName;
            String apkPrimaryFileName = apkName = iterator.next();
            if (apkName.endsWith(APK_SUFFIX)) {
                apkPrimaryFileName = apkName.substring(0, apkName.length() - APK_SUFFIX.length());
            }
            File apk = FileUtil.getFileForPath((File)testAppDir, (String[])new String[]{apkPrimaryFileName, apkName});
            LogUtil.CLog.i((String)"Installing %s on %s", (Object[])new Object[]{apk.getName(), device.getSerialNumber()});
            String result = device.installPackage(apk, true, new String[0]);
            if (result == null) continue;
            throw new TargetSetupError(String.format("Failed to install %s on device %s. Reason: %s", apk.getAbsolutePath(), device.getSerialNumber(), result), device.getDeviceDescriptor());
        }
    }

    private File getDataAppDirFromBuildEnv(ITestDevice device) throws TargetSetupError {
        String buildRoot = System.getenv("ANDROID_PRODUCT_OUT");
        if (buildRoot == null) {
            throw new TargetSetupError("ANDROID_PRODUCT_OUT is not set. Are you in Android build env?", device.getDeviceDescriptor());
        }
        File testAppDir = new File(FileUtil.getPath((String[])new String[]{buildRoot, "data", "app"}));
        if (!testAppDir.exists()) {
            throw new TargetSetupError(String.format("Could not find test app dir %s", testAppDir.getAbsolutePath()), device.getDeviceDescriptor());
        }
        return testAppDir;
    }
}

