/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="fastboot-command-preparer")
public final class FastbootCommandPreparer
extends BaseTargetPreparer {
    @Option(name="fastboot-mode", description="True to boot the device into bootloader mode, false for fastbootd mode.")
    private FastbootMode mFastbootMode = FastbootMode.BOOTLOADER;
    @Option(name="stay-fastboot", description="True to keep the device in bootloader or fastbootd mode.")
    private boolean mStayFastboot = false;
    @Option(name="command", description="Fastboot commands to run.")
    private List<String> mFastbootCommands = new ArrayList<String>();

    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mFastbootMode == FastbootMode.BOOTLOADER) {
            testInformation.getDevice().rebootIntoBootloader();
        } else {
            testInformation.getDevice().rebootIntoFastbootd();
        }
        for (String cmd : this.mFastbootCommands) {
            if (cmd.trim().equals("reboot")) continue;
            testInformation.getDevice().executeFastbootCommand(cmd.split("\\s+"));
        }
        if (!this.mStayFastboot) {
            testInformation.getDevice().reboot();
        }
    }

    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        testInformation.getDevice().reboot();
    }

    private static enum FastbootMode {
        BOOTLOADER,
        FASTBOOTD;

    }
}

